  /**********************************************************************
  * Copyright (C) by Michael Loesler, http://derletztekick.com           *
  *                                                                      *
  * This program is free software; you can redistribute it and/or modify *
  * it under the terms of the GNU General Public License as published by *
  * the Free Software Foundation; either version 3 of the License, or    *
  * (at your option) any later version.                                  *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
  * GNU General Public License for more details.                         *
  *                                                                      *
  * You should have received a copy of the GNU General Public License    *
  * along with this program; if not, see <http://www.gnu.org/licenses/>  *
  * or write to the                                                      *
  * Free Software Foundation, Inc.,                                      *
  * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
  *                                                                      *
   **********************************************************************/

package com.derletztekick.tools.textfieldverifier;

import javax.swing.JComponent;
import javax.swing.JTextField;

public class AbsoluteValueFormattedTextFieldVerifier extends NumberValueFormattedTextFieldVerifier {
	 
	private final boolean excludeZeroValue;
	public AbsoluteValueFormattedTextFieldVerifier() {
		this(true, false);
	}
	
	public AbsoluteValueFormattedTextFieldVerifier(boolean excludeZeroValue) {
		this(excludeZeroValue, false);
	}
	
	public AbsoluteValueFormattedTextFieldVerifier(boolean excludeZeroValue, boolean allowEmptyValues) {
		super(allowEmptyValues);
		this.excludeZeroValue = excludeZeroValue;
	}
	
	@Override
	public boolean verify(JComponent comp) {
		if (super.verify(comp)) {
			JTextField textField = (JTextField) comp;
			String content = textField.getText().trim();
			double d = -1.0;
			try {
				d = Double.parseDouble(content);
			}
			catch (NumberFormatException nfe) {}

			return (content.isEmpty() || (this.excludeZeroValue && d > 0) || (!this.excludeZeroValue && d >= 0));
		}
		return false;
	}
}
