  /**********************************************************************
  *                                MySQL                                 *
  ************************************************************************
  * Copyright (C) Michael Loesler, http://derletztekick.com              *
  *                                                                      *
  * This program is free software; you can redistribute it and/or modify *
  * it under the terms of the GNU General Public License as published by *
  * the Free Software Foundation; either version 3 of the License, or    *
  * (at your option) any later version.                                  *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
  * GNU General Public License for more details.                         *
  *                                                                      *
  * You should have received a copy of the GNU General Public License    *
  * along with this program; if not, see <http://www.gnu.org/licenses/>  *
  * or write to the                                                      *
  * Free Software Foundation, Inc.,                                      *
  * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
  *                                                                      *
   **********************************************************************/

package com.derletztekick.tools.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MySQL extends DataBase {
	private final static String SQL_LAST_ID = "SELECT last_insert_id()";
	private final String uri, database;
	private final int port;
	public static final String JDBCDriver = "com.mysql.jdbc.Driver";
	
	public MySQL(String uri, String database) {
		this(uri, database, "", "");
	}

	public MySQL(String uri, String database, String username, String password) {
		this(uri, database, 3306, username, password);
	}
	
	public MySQL(String uri, String database, int port, String username, String password) {
		super(uri, MySQL.JDBCDriver, username, password);
		this.uri = uri;
		this.database = database;
		this.port = port;
	}

	@Override
	public String getURI() {
		return "jdbc:mysql://" + this.uri + ":" + this.port + "/" + this.database;
	}

	@Override
	public int getLastInsertId() throws SQLException {
		PreparedStatement statementId = this.getPreparedStatement(MySQL.SQL_LAST_ID);
		ResultSet lastId = statementId.executeQuery();
		if (!lastId.wasNull() && lastId.next())
			return lastId.getInt(1);
		return -1;
	}

}
