package com.derletztekick.tools.io.filter;

import java.io.File;

/**
 * Filefilter fuer JobXML-Dateien
 * @author Michael Loesler <derletztekick.com>
 *
 */
public class JobXMLFileFilter extends XMLFileFilter {
	
	@Override
	public boolean accept(File f) {
		return f.getName().toLowerCase().endsWith(".jxl") || f.isDirectory() || super.accept(f);
	}

	@Override
	public String getDescription() {
		return "JobXML (*.jxl, *.xml)";
	}
	
	@Override
	public String getDefaultExtension() {
		return ".jxl";
	}
}
