 /**********************************************************************
 *                            HSQLFileFilter                            *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.io.filter;

import java.io.File;

/**
* Filefilter fuer HSQLFileFilter-Dateien
* @author Michael Loesler <derletztekick.com>
*
*/

public class HSQLFileFilter extends DefaultFileFilter {
	//private final String regex = "(.+?)(\\.)(backup$|data$|properties$|script$)";
	@Override
	public boolean accept(File f) {
		if (f.isDirectory())
			return true;
		
		if (f.getName().toLowerCase().endsWith(".data")) {
			String exts[] = new String[] {".properties", ".script"};
			File dirName = f.getParentFile();
			
			String fileName = f.getName();
			String baseName = fileName.substring(0, fileName.lastIndexOf('.'));
						
			for (String ext : exts) {
				File tmp = new File(dirName, baseName + ext);
				if (tmp == null || !tmp.exists() || !tmp.isFile())
					return false;
			}
			return true;
		}
		
		//return f.getName().toLowerCase().matches(this.regex) || f.isDirectory();
		//return f.getName().toLowerCase().endsWith(".data") || f.isDirectory();
		return false;
	}

	@Override
	public String getDescription() {
		return new String("HyperSQL");
	}
	
	@Override
	public String getDefaultExtension() {
		return ".data";
	}

}
