 /**********************************************************************
 *                          DefaultFileFilter                           *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.io.filter;

import java.io.File;
import javax.swing.filechooser.FileFilter;

/**
* Standard Filefilter fuer alle Dateien
* @author Michael Loesler <derletztekick.com>
*
*/
public class DefaultFileFilter extends FileFilter {
	
	@Override
	public boolean accept(File f) {
		return true;
	}

	@Override
	public String getDescription() {
		return "Files (*.*)";
	}
	
	public String getDefaultExtension() {
		return "";
	}

}
