  /**********************************************************************
  *                            UpdateChecker                             *
  ************************************************************************
  * Copyright (C) by Michael Loesler, http://derletztekick.com           *
  *                                                                      *
  * This program is free software; you can redistribute it and/or modify *
  * it under the terms of the GNU General Public License as published by *
  * the Free Software Foundation; either version 3 of the License, or    *
  * (at your option) any later version.                                  *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
  * GNU General Public License for more details.                         *
  *                                                                      *
  * You should have received a copy of the GNU General Public License    *
  * along with this program; if not, see <http://www.gnu.org/licenses/>  *
  * or write to the                                                      *
  * Free Software Foundation, Inc.,                                      *
  * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
  *                                                                      *
   **********************************************************************/

package com.derletztekick.tools.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;


public class UpdateChecker {
	
	public class ReleasInformation {
		private double version = -1;
		private int build = -1;

		private URI uri = null;
		
		public void setVersionsNumber(double version) {
			this.version = version;
		}
		
		public double getVersionsNumber() {
			return this.version;
		}
		
		public void setBuildNumber(int build) {
			this.build = build;
		}
		
		public int getBuildNumber() {
			return this.build;
		}
		
		public void setURI(String uri) throws URISyntaxException{
			this.uri = new URI( uri );
		}
		
		public URI getURI() {
			return this.uri;
		}
		
		public boolean isComplete() {
			return this.version > 0 && this.build > 0 && this.uri != null;
		}
		
	}
//	private final String urlName = new String("http://javagraticule3d.sourceforge.net/update.php");
	private final String urlName;
	private int dateYYYYMMDD;
	private double version;
	private ReleasInformation releasInformation = new ReleasInformation();

	public UpdateChecker(String urlName, double version, int dateYYYYMMDD) {
		this.urlName = urlName;
		this.dateYYYYMMDD = dateYYYYMMDD;
		this.version = version;
	}
	
	/**
	 * Liefert also 
	 * <ul>
	 * <li>-1, bei einem Fehler</li>
	 * <li> 0, wenn die aktuelle Version mit der benutzten identisch ist</li>
	 * <li> 1, wenn es eine neuere Version gibt</li>
	 * </ul>
	 * @return hasUpdates
	 */
	public int hasUpdates() {
		if (!this.releasInformation.isComplete())
			return -1;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat( "yyyyMMdd" );
		try {
			Date dateOfCurrentVersion = simpleDateFormat.parse( String.valueOf( this.dateYYYYMMDD ) );
			Date dateOfNewVersion = simpleDateFormat.parse( String.valueOf(this.releasInformation.getBuildNumber()) );
			if (this.releasInformation.getVersionsNumber() > this.version)
				return 1;
			else if (this.releasInformation.getVersionsNumber() == this.version) {
				return dateOfNewVersion.compareTo(dateOfCurrentVersion);
			}
			else
				return -1;
			
		} catch (ParseException e) {
			e.printStackTrace();
			return -1;
		}
	}
	
	/**
	 * Stellt eine Verbindung zum Server her und prueft auf UPDATES. 
	 * Hierbei wird eine PHP-Datei gelesen bspw.:
	 * 
	 * <?php
	 * 	define("VERSION", 2.0);
	 * 	define("BUILD",   20091120);
	 * 	define("URI",     "http://sourceforge.net/projects/javagraticule3d/files/latest");
	 * 	
	 * 	header('X-Powered-By: JAG3D');
	 * 	header('Cache-Control: no-cache, no-store, max-age=0, must-revalidate');
	 * 	header('Pragma: no-cache');
	 * 
	 * 	if (isset($_POST['checkupdate']) && $_POST['checkupdate'] == "jag3d") {
	 * 		header('Content-Type: text/plain; charset=utf-8');
	 * 		echo "VERSION: ".VERSION."\r\n";
	 * 		echo "BUILD: ".BUILD."\r\n";
	 * 		echo "URI: ".URI."\r\n";
	 * 	} 
	 * 	else {
	 * 		header('Content-Type: text/html; charset=utf-8');
	 * 		header('HTTP/1.1 404 Not Found');
	 * 		print('<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
	 * 			<html><head>
	 * 			<title>404 Found</title>
	 * 			</head><body>
	 * 			<h1>Not Found</h1>
	 * 			<p>The requested URL was not found on this server.</p>
	 * 			<hr>
	 * 			<address>'.$_SERVER['SERVER_SOFTWARE'].' Server at '.$_SERVER['SERVER_NAME'].' Port '.$_SERVER['SERVER_PORT'].'</address>
	 * 			</body></html>');
	 * 		exit;
	 * 	}
	 * ?>
	 * 
	 * @param param
	 * @return connected
	 */
	public boolean connectServer(String param) {
		
		boolean canConnect = false;
		BufferedReader bufferedReader = null;
		OutputStreamWriter outputStreamWriter = null;
		
		try {
			String data = URLEncoder.encode("checkupdate", "UTF-8") + "=" + URLEncoder.encode(param, "UTF-8");
			//data += "&" + URLEncoder.encode("key2", "UTF-8") + "=" + URLEncoder.encode("value2", "UTF-8");

			URL url = new URL( this.urlName );
			URLConnection conn = url.openConnection();
	        conn.setDoOutput(true);
	        outputStreamWriter = new OutputStreamWriter(conn.getOutputStream());
	        outputStreamWriter.write(data);
	        outputStreamWriter.flush();
	    
	        bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
	        String line;
	        while ((line = bufferedReader.readLine()) != null) {
	        	//System.out.println(line);
	        	line = line.trim();
	        	try {
		        	if (line.startsWith("VERSION:"))
		        		this.releasInformation.setVersionsNumber( Double.parseDouble( line.replaceAll("^VERSION: (.+?)", "$1" ).trim()) );
		        	else if (line.startsWith("BUILD:"))
		        		this.releasInformation.setBuildNumber( Integer.parseInt( line.replaceAll("^BUILD: (.+?)", "$1" ).trim()) );
		        	else if (line.startsWith("URI:"))
		        		this.releasInformation.setURI( line.replaceAll("^URI: (.+?)", "$1" ).trim() );
	        	}  catch (NumberFormatException e) {
	        		e.printStackTrace();
	        		continue;
	        	}
	        	catch (URISyntaxException e) {
	        		e.printStackTrace();
	        		continue;
	        	}
	        }
	        canConnect = true;
		} catch (IOException e) {
	    	e.printStackTrace(); 
			canConnect = false;
	    }
	    finally { 
	    	if ( outputStreamWriter != null )
	    		try { 
	    			outputStreamWriter.close(); 
				} catch ( IOException e ) { }
	    	
			if ( bufferedReader != null ) 
				try { 
					bufferedReader.close(); 
				} catch ( IOException e ) { } 
		} 
		return canConnect;
	}
	
	/**
	 * Liefert die verfuegbaren Releas Informationen
	 * @return releasInformation
	 */
	public ReleasInformation getReleasInformation() {
		return this.releasInformation;
	}
	
}
