 /**********************************************************************
 *                             FileChooser                              *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.io;
import java.awt.Component;


import javax.swing.JFileChooser;

/**
 * Einfache Erweiterung des Standard JFileChooser
 * @author Michael Loesler <derletztekick.com>
 *
 */
public class FileChooser extends JFileChooser {
	private Component parent;
	private static final long serialVersionUID = -7705513223142420725L;
	public FileChooser(Component parent) {
		this.parent = parent;
	}
	
	@Override
	public int showSaveDialog(Component parent) {
		if (parent == null)
			return super.showSaveDialog(this.parent);
		return super.showSaveDialog(parent);
	}
	
	@Override
	public int showOpenDialog(Component parent) {
		if (parent == null)
			return super.showOpenDialog(this.parent);
		return super.showOpenDialog(parent);
	}
	
	/**
	 * Entfernt alle hinterlegten FileFilter
	 *
	 */
	public void removeAllChoosableFileFilters() {
		while (this.getChoosableFileFilters().length > 0){
			this.removeChoosableFileFilter(this.getChoosableFileFilters()[0]);
		}
	}
}
