  /**********************************************************************
  *                           TestStatisticType                          *
  ************************************************************************
  * Copyright (C) Michael Loesler, http://derletztekick.com              *
  *                                                                      *
  * This program is free software; you can redistribute it and/or modify *
  * it under the terms of the GNU General Public License as published by *
  * the Free Software Foundation; either version 3 of the License, or    *
  * (at your option) any later version.                                  *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
  * GNU General Public License for more details.                         *
  *                                                                      *
  * You should have received a copy of the GNU General Public License    *
  * along with this program; if not, see <http://www.gnu.org/licenses/>  *
  * or write to the                                                      *
  * Free Software Foundation, Inc.,                                      *
  * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
  *                                                                      *
   **********************************************************************/

package com.derletztekick.tools.geodesy.statistic;

public enum TestStatisticType {

	UNADJUSTED(1, "Unadjusted Test"),
	B_METHOD(2, "B-Method"), 
	SIDAK(3, "\u0160id\u00E1k"); 
	
	private final int id;
	private String label;
	private TestStatisticType(int id, String label) {
		this.id = id;
	}
		
	public int getId() {
		return this.id;
	}
	
	public static TestStatisticType getTestStatisticTypeById(int id) {
		for (TestStatisticType type : TestStatisticType.values()) 
			if (type.getId() == id)
				return type;
		return null;
	}
	
	public void setLabel(String label) {
		this.label = label;
	}
	
	@Override
	public String toString() {
		return this.label;
	}
}
