 /**********************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.set;

import java.util.Arrays;

public class OptInParameterSet {
	private final int id;
	private double par[];
	private boolean isSelected = false;
	private final double min, max;
	public OptInParameterSet(int id, double par[], boolean isSelected) {
		this(id, par, -Double.MAX_VALUE, Double.MAX_VALUE, isSelected);
	}
	
	public OptInParameterSet(int id, double par[], double min, double max, boolean isSelected) {
		this.id  = id;
		this.par = par;
		this.min = min;
		this.max = max;
		this.isSelected = isSelected;
	}
	
	@Override
	public String toString() {
		return "[id=" + id
				+ ", isSelected=" + isSelected + ", par="
				+ Arrays.toString(par) + "]";
	}

	/**
	 * Liefert die Parameter als Array
	 * @return par
	 */
	public double[] getParameters() {
		return par;
	}

	/**
	 * Setzt die Parameter der Anpassungsmethode
	 * @param par
	 */
	public void setParameters(double[] par) {
		this.par = par;
		// Pruefe Intervall
		for (int i=0; i<this.par.length; i++) {
			this.par[i] = Math.min(this.par[i], this.max);
			this.par[i] = Math.max(this.par[i], this.min);
		}
	}

	/**
	 * Liefert <code>true</code>, wenn die Anpassung aktiv ist
	 * @return isSelected
	 */
	public boolean isSelected() {
		return isSelected;
	}

	/**
	 * Aktiviert die Anpassung
	 * @param isSelected
	 */
	public void isSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}
	
	public final int getId() {
		return this.id;
	}
}
