package com.derletztekick.tools.geodesy.distribution;

import com.derletztekick.tools.geodesy.Constant;

public class NonCentralF {
	private final static int ITERMAX = 500;
	private static final double EPSILON   =  Math.sqrt(Constant.EPS);
	
	private NonCentralF() {}
	
	public static double ncfcdf(double x, double dfn, double dfd, double ncp) {
		double Lam = 0.5*ncp;
		double Pois = Math.exp(-Lam);
		double P=Pois*F.fcdf(x,dfn,dfd);
		int j=0;
		double Z=x*dfn;
		int itr = 0;
		while (j < Lam + 5.0*Math.sqrt(Lam) && itr++ <= ITERMAX) {
			j++;
			dfn=dfn+2;
			Pois=Pois*Lam/(double)j;
			P=P+Pois*F.fcdf(Z/dfn,dfn,dfd);
		}
		return P;
	}
	
	public static double ncfinv(double alpha, double dfn, double dfd, double ncp)  {
		if (alpha <= 0.0)
			return 0.0;
		else if (alpha >= 1.0) 
			return Double.POSITIVE_INFINITY;
		
		double lower = 0;
		double upper = 0;
		
		double p = ncfcdf(upper, dfn,dfd,ncp);
		while (alpha > p && p <= 1) {
			upper += 10;
			p = ncfcdf(upper, dfn,dfd,ncp);
		}
		lower = upper - 10;
		
		int i = 0;
		double mean = 0.5*(upper + lower);

		while ((Math.abs(upper - lower) > EPSILON || Math.abs(p - alpha) > EPSILON) && i++ < ITERMAX) {
			p = ncfcdf(mean, dfn,dfd,ncp);			
			if (p > alpha)
				upper = mean;
			else
				lower = mean;
			mean = 0.5*(upper + lower);			
		}
		return mean;
	}
	
	public static double cumulative(double x, double dfn, double dfd, double ncp, boolean lower_tail, boolean log_p) {
		double p = NonCentralF.ncfcdf(x, dfn, dfd, ncp);
		if (!lower_tail)
			p = 1.0 - p;
		if (log_p)
			p = Math.log(p);
		return p;
	}
	
	public static double quantile(double p, double dfn, double dfd, double ncp, boolean lower_tail, boolean log_p) {
		if (log_p)
			p = Math.pow(Math.E, p);
		if (!lower_tail)
			p = 1.0 - p;
		return NonCentralF.ncfinv(p, dfn, dfd, ncp);
	}
	
	public static void main(String args[]) {
		double p = -0.0010005049704290754;
//		double p = -6.90775064678418;
		double dfn = 50;
		double dfd = 1750;
		double ncp = 35;
		boolean lower_tail = true;
		boolean log_p = true;
		System.out.println(jdistlib.NonCentralF.quantile(p, dfn, dfd, ncp, lower_tail, log_p));
		System.out.println(NonCentralF.quantile(p, dfn, dfd, ncp, lower_tail, log_p));

		System.out.println(jdistlib.NonCentralF.cumulative(0.8324, dfn, dfd, ncp, lower_tail, log_p));
		System.out.println(NonCentralF.cumulative(0.8324, dfn, dfd, ncp, lower_tail, log_p));
	}

}
