package com.derletztekick.tools.geodesy.distribution;

import com.derletztekick.tools.geodesy.Constant;

public class F {
	private final static int ITERMAX = 500;
	private static final double EXPMIN    = -30.0,
								EPSILON   =  Math.sqrt(Constant.EPS);

	private F() {}
	
	public static double finv(double alpha, double dfn, double dfd)  {
		double unten, oben, mitte, p=1.0;

		if (alpha <= 0.0)
			return Double.POSITIVE_INFINITY;
		else if (alpha >= 1.0) 
			return 0.0;

		alpha = 1.0 - alpha;
		
		if (alpha<=0.5) {
			unten = 0.5;
			oben = unten;
			for (int iter=0; iter<ITERMAX; iter++) {
				oben*=2.0;
				p=ftail(oben,dfn,dfd);
				if (p>alpha)
					unten=oben;
				else
					break;
			}
			if (p>alpha)
				return oben;
	    }
	    else {
	    	oben = 2.0;
	    	unten = oben;
	    	for (int iter=0; iter<ITERMAX; iter++) {
	    		unten*=0.5;
	    		p = ftail(unten,dfn,dfd);
	    		if (p<alpha)
	    			oben=unten;
	    		else
	    			break;
	    	}
	    	if (p<alpha)
	    		return unten;
	    }

		mitte = 0.5*(oben+unten);
		for (int iter=0; iter<ITERMAX && (oben-unten)>EPSILON*mitte; iter++) {
			mitte = 0.5*(oben+unten);
			p = ftail(mitte,dfn,dfd);
			if (p<alpha)
				oben=mitte;
			else if (p>alpha)
				unten=mitte;
			else 
				break;
		}
		return mitte;
	}
	
	public static double fcdf(double F, double dfn, double dfd) {
		return 1.0 - ftail(F, dfn, dfd);
	}
	
	private static double ftail(double F, double dfn, double dfd) { 
        
		double p=1.0, retval=1.0;

	    if (F < EPSILON || dfn <= 0.0 || dfd <= 0.0);
	    else if ( F*dfn>=dfd || F > 1.0 + 20.0/dfn + 10.0/Math.sqrt(dfn) )
	    	p = series(F,dfn,dfd);
	    else
	    	p = 1.0 - series(1.0/F,dfd,dfn);
	    retval=p;
	    if (p>=1.0 || p<=0.0) {
	    	if (F > 1.0)
	    		retval = 0.0;
	    	else if (F == 1.0)
	    		retval = 0.5;
	    	else
	    		retval = 1.0;
	    }
	    return retval;
	}
	  
	  
	private static double series(double F, double dfn, double dfd){                                                  
		double x,c,er,s,t1,t,retval;
		int n=0;
		dfn = 0.5*dfn;
		dfd = 0.5*dfd;
		x = dfd/(dfd + dfn*F);
		c = gammln(dfn+dfd) - gammln(dfn) - gammln(dfd+1) + dfd * Math.log(x) + dfn * Math.log(1.0-x);
	    if (c < EXPMIN) {
	    	return -1.0;
	    }
	    else {
	    	dfn += dfd;
	    	dfd += 1.0;
	    	c = Math.exp(c);
	    	er = EPSILON/c;
	    	t = dfn*x/dfd;
	    	t1 = 0.0;
	    	s = t+1.0;

	    	while (t>er || t>t1){
	    		n++;
	    		t1 = t;
	    		t *= ((dfn+n)*x/(dfd+n));
	    		s += t;
	    	}
	    	retval=s*c;
	    }
	    return retval;
	}
	  

	private static double gammln(double xx){
	    // Returns the value ln[GAMMA(xx)] for xx > 0.
		double x = xx,
	           y = xx,
	           tmp = x + 5.5,
	           ser=1.000000000190015;

		double cof[] = {
	                      76.18009172947146,
	                     -86.50532032941677,
	                      24.01409824083091,
	                     -1.231739572450155,
	                      0.1208650973866179E-2,
	                     -0.5395239384953e-5
	                   };

		tmp -= (x+0.5)*Math.log(tmp);


		for (int j=0; j<6; j++)
			ser += cof[j]/(double)++y;
		return -tmp+Math.log(2.5066282746310005*ser/x);
	}
	
	public static double cumulative(double x, double dfn, double dfd, boolean lower_tail, boolean log_p) {
		double p = F.fcdf(x, dfn, dfd);
		if (!lower_tail)
			p = 1.0 - p;
		if (log_p)
			p = Math.log(p);
		return p;
	}
	
	public static double quantile(double p, double dfn, double dfd, boolean lower_tail, boolean log_p) {
		if (log_p)
			p = Math.pow(Math.E, p);
		if (!lower_tail)
			p = 1.0 - p;
		return F.finv(p, dfn, dfd);
	}
	
	public static void main(String args[]) {
//		double p = -0.0010005049704290754;
		double p = -6.90775064678418;
		double dfn = 50;
		double dfd = 1750;
		boolean lower_tail = true;
		boolean log_p = true;
		System.out.println(jdistlib.F.quantile(p, dfn, dfd, lower_tail, log_p));
		System.out.println(F.quantile(p, dfn, dfd, lower_tail, log_p));

		System.out.println(jdistlib.F.cumulative(0.8324, dfn, dfd, lower_tail, log_p));
		System.out.println(F.cumulative(0.8324, dfn, dfd, lower_tail, log_p));
	}
}
