 /**********************************************************************
 *                          StochasticTest                              *
 ************************************************************************
 * Copyright (C) Michael Loesler, http://derletztekick.com              *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.deprecated;

import com.derletztekick.tools.geodesy.distribution.F;

@Deprecated
public class StochasticTestABMeth {

	public final static int INFINITE = 100000;
	
	/**
	 * Liefert den kritischen Wert k der
	 * F-Verteilung fuer den Signifikanztest T<sub>prio</sub>
	 *
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @return k kritischer Wert
	 */
	public static double getTprioQuantile(double dim, double alpha){
		double quantilFDistA = F.finv(1.0 - 0.01*alpha, dim, StochasticTestABMeth.INFINITE+dim);
		if (quantilFDistA < 0)
			return Double.POSITIVE_INFINITY;
		return quantilFDistA;
	}

	/**
	 * Liefert den kritischen Wert k der
	 * F-Verteilung fuer den Signifikanztest T<sub>post</sub>
	 *
	 * @param degreeOfFreedom Freiheitsgrad der gesamten Ausgleichung
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @return k kritischer Wert
	 */
	public static double getTpostQuantile(double degreeOfFreedom, double dim, double alpha){
		if (degreeOfFreedom == 0 || dim == 0)
			return Double.POSITIVE_INFINITY;
		double quantilFDistA = F.finv(1.0 - 0.01*alpha, dim, degreeOfFreedom);

		if (quantilFDistA < 0)
			return Double.POSITIVE_INFINITY;
		return quantilFDistA;
	}
	
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>prio</sub>.
	 * Abstimmung erfolgt auf eine 1D-Testgroesse!
	 * 
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTprioQuantile(double dim, double alpha, double beta){
		double quantilFDistA = Double.POSITIVE_INFINITY;
		if (dim == 1) {
			quantilFDistA = F.finv(1.0 - 0.01*alpha, dim, StochasticTestABMeth.INFINITE+dim);
		}
		else if (dim > 1){
			ABMeth abMeth = new ABMeth(1, 
					                   (int)(StochasticTestABMeth.INFINITE+dim), 
					                   (int)dim, 
					                   (int)(StochasticTestABMeth.INFINITE+dim), 
					                   0.01*alpha, 
					                   0.01*beta
			);
			quantilFDistA = abMeth.getAdjustedQuantile();
		}
		if (quantilFDistA < 0)
			return Double.POSITIVE_INFINITY;
		return quantilFDistA;
	}
		  
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>post</sub>
	 * Abstimmung erfolgt auf eine 1D-Testgroesse!
	 * 
	 * @param degreeOfFreedom Freiheitsgrad der gesamten Ausgleichung
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTpostQuantile(double degreeOfFreedom, double dim, double alpha, double beta){
		if (degreeOfFreedom <= 0 || dim <= 0 || dim > degreeOfFreedom)
			return Double.POSITIVE_INFINITY;

		double quantilFDistA;
		ABMeth abMeth = new ABMeth(1, 
               (int)(StochasticTestABMeth.INFINITE+dim), 
               (int)dim, 
               (int)degreeOfFreedom, 
               0.01*alpha, 
               0.01*beta
		);
		quantilFDistA = abMeth.getAdjustedQuantile();

		if (quantilFDistA < 0)
			return Double.POSITIVE_INFINITY;
		return quantilFDistA;
	}
	
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>prio</sub>.
	 * Abstimmung erfolgt auf eine <code>dimLocal</code> D-Testgroesse!
	 * 
	 * @param dimLocal Dimension der Referenztestgroesse
	 * @param dimGlobal Dimension der gesuchten Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTprioQuantile(double dimLocal, double dimGlobal, double alpha, double beta){
		double quantilFDistA = Double.POSITIVE_INFINITY;

		if (dimLocal == 1 && dimGlobal == 1) {
			quantilFDistA = F.finv(1.0 - 0.01*alpha, dimGlobal, StochasticTestABMeth.INFINITE+dimGlobal);
		}
		else if (dimLocal > 1 && dimGlobal > 1){
			ABMeth abMeth = new ABMeth((int)dimLocal, 
					                   (int)(StochasticTestABMeth.INFINITE+dimLocal), 
					                   (int)dimGlobal, 
					                   (int)(StochasticTestABMeth.INFINITE+dimGlobal), 
					                   0.01*alpha, 
					                   0.01*beta
			);
			quantilFDistA = abMeth.getAdjustedQuantile();
		}
		if (quantilFDistA < 0)
			return Double.POSITIVE_INFINITY;
		return quantilFDistA;
	}
		  
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>post</sub>
	 * Abstimmung erfolgt auf eine <code>dimLocal</code> D-Testgroesse!
	 * 
	 * @param dimLocal Dimension der Referenztestgroesse
	 * @param dimGlobal Dimension der gesuchten Testgroesse
	 * @param degreeOfFreedom Freiheitsgrad der gesamten Ausgleichung
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTpostQuantile(double dimLocal, double degreeOfFreedom, double dimGlobal, double alpha, double beta){	
		if (degreeOfFreedom <= 0 || dimLocal <= 0 || dimGlobal <= 0 || dimGlobal > degreeOfFreedom)
			return Double.POSITIVE_INFINITY;

		double quantilFDistA;
		ABMeth abMeth = new ABMeth(
				(int)dimLocal, 
				(int)(StochasticTestABMeth.INFINITE+dimLocal), 
				(int)dimGlobal, 
				(int)degreeOfFreedom, 
				0.01*alpha, 
				0.01*beta
		);
		quantilFDistA = abMeth.getAdjustedQuantile();

		if (quantilFDistA < 0)
			return Double.POSITIVE_INFINITY;
		return quantilFDistA;
	}
	
	/**
	 * Liefert den Nichtzentralitaetsparameter &lamda;(dim, &alpha;, &beta;)
	 * @param dim
	 * @param alpha
	 * @param beta
	 * @return &lamda;
	 */
	public static double getNoncentralityParameter(double dim, double alpha, double beta){
		if (dim == 1) {
			double qA = F.finv(1.0 - 0.01*alpha, dim, StochasticTestABMeth.INFINITE+dim);
			double qB = F.finv(0.02*beta - 1.0, dim, StochasticTestABMeth.INFINITE+dim);
			return Math.pow(Math.sqrt(qA) + Math.sqrt(qB), 2);
		}

		ABMeth abMeth = new ABMeth(
				(int)dim, 
				(int)(StochasticTestABMeth.INFINITE+dim), 
				(int)dim, 
				(int)(StochasticTestABMeth.INFINITE+dim), 
				0.01*alpha, 
				0.01*beta
		);
		return abMeth.getNoncentralityParameter();

	}
}

