 /**********************************************************************
 *                            StochasticTest                            *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.deprecated;

import jdistlib.F;
import jdistlib.NonCentralF;
/**
 * Berechnung von stochastischen Groessen
 * @author Micha
 * @deprecated ersetzt durch {@link com.derletztekick.tools.geodesy.statistic.TestStatistic}
 */
@Deprecated
public class StochasticTest {

	public final static double INFINITE = 1000000.0;
	
	/**
	 * Liefert den kritischen Wert k der
	 * F-Verteilung fuer den Signifikanztest T<sub>prio</sub>
	 *
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @return k kritischer Wert
	 */
	public static double getTprioQuantile(double dim, double alpha){
		if (dim <= 0)
			return Double.POSITIVE_INFINITY;
		
		return F.quantile(1.0-0.01*alpha, dim, StochasticTest.INFINITE+dim, true, false);
	}

	/**
	 * Liefert den kritischen Wert k der
	 * F-Verteilung fuer den Signifikanztest T<sub>post</sub>
	 *
	 * @param degreeOfFreedom Freiheitsgrad der gesamten Ausgleichung
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @return k kritischer Wert
	 */
	public static double getTpostQuantile(double degreeOfFreedom, double dim, double alpha){
		if (degreeOfFreedom <= 0 || dim <= 0)
			return Double.POSITIVE_INFINITY;

		return F.quantile(1.0-0.01*alpha, dim, degreeOfFreedom, true, false);
	}
	
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>prio</sub>.
	 * Abstimmung erfolgt auf eine 1D-Testgroesse!
	 * 
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTprioQuantile(double dim, double alpha, double beta){
		if (dim == 1) {
			return F.quantile(1.0-0.01*alpha, dim, StochasticTest.INFINITE+dim, true, false);
		}
		else { //if (dim > 1){
			double ncp = StochasticTest.getNoncentralityParameter(1, StochasticTest.INFINITE, alpha, beta);
			return NonCentralF.quantile(1.0-0.01*beta, dim, StochasticTest.INFINITE+dim, ncp, true, false);
		}
		//return Double.POSITIVE_INFINITY;
	}
	
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>prio</sub>.
	 * Abstimmung erfolgt auf eine <code>dimLocal</code> D-Testgroesse!
	 * 
	 * @param dimLocal Dimension der Referenztestgroesse
	 * @param dimGlobal Dimension der gesuchten Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTprioQuantile(double dimLocal, double dimGlobal, double alpha, double beta){
		if (dimLocal <= 0 || dimGlobal <= 0)
			return Double.POSITIVE_INFINITY;
		
		if (dimLocal == 1 && dimGlobal == 1) {
			return F.quantile(1.0-0.01*alpha, dimGlobal, StochasticTest.INFINITE+dimGlobal, true, false);
		}
		else { //if (dimLocal >= 1 && dimGlobal >= 1){
			double ncp = StochasticTest.getNoncentralityParameter(dimLocal, StochasticTest.INFINITE, alpha, beta);
			return NonCentralF.quantile(1.0-0.01*beta, dimGlobal, StochasticTest.INFINITE+dimGlobal, ncp, true, false);
		}
		//return Double.POSITIVE_INFINITY;
	}
		  
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>post</sub>
	 * Abstimmung erfolgt auf eine 1D-Testgroesse!
	 * 
	 * @param degreeOfFreedom Freiheitsgrad der gesamten Ausgleichung
	 * @param dim Dimension der Testgroesse
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTpostQuantile(double degreeOfFreedom, double dim, double alpha, double beta){
		if (degreeOfFreedom <= 0 || dim <= 0)
			return Double.POSITIVE_INFINITY;
		
		if (dim == 1) {
			return F.quantile(1.0-0.01*alpha, dim, degreeOfFreedom, true, false);
		}
		else { // if (dim > 1){
			double ncp = StochasticTest.getNoncentralityParameter(1, StochasticTest.INFINITE, alpha, beta);
			return NonCentralF.quantile(1.0-0.01*beta, dim, degreeOfFreedom, ncp, true, false);
		}
		
		//return Double.POSITIVE_INFINITY;
	}
	
	/**
	 * Liefert den kritischen Wert k der 
	 * F-Verteilung fuer den Signifikanztest T<sub>post</sub>
	 * Abstimmung erfolgt auf eine <code>dimLocal</code> D-Testgroesse!
	 * 
	 * @param n1 Dimension der Referenztestgroesse
	 * @param dimGlobal Dimension der gesuchten Testgroesse
	 * @param degreeOfFreedom Freiheitsgrad der gesamten Ausgleichung
	 * @param alpha Irtumswahrscheinlichkeit [%]
	 * @param beta Macht des Tests [%]
	 * @return k kritischer Wert
	 */
	public static double getTpostQuantile(double dimLocal, double degreeOfFreedom, double dimGlobal, double alpha, double beta){	
		if (degreeOfFreedom <= 0 || dimLocal <= 0 || dimGlobal <= 0) // || dimGlobal > degreeOfFreedom)
			return Double.POSITIVE_INFINITY;

		double ncp = StochasticTest.getNoncentralityParameter(dimLocal, StochasticTest.INFINITE, alpha, beta);
		return NonCentralF.quantile(1.0-0.01*beta, dimGlobal, degreeOfFreedom, ncp, true, false);
	}
	
	/**
	 * Liefert den Nichtzentralitaetsparameter &lamda;(n, +Inf, &alpha;, &beta;)
	 * @param n
	 * @param alpha
	 * @param beta
	 * @return &lamda;
	 */
	public static double getNoncentralityParameter(double n, double alpha, double beta){
		return getNoncentralityParameter(n, StochasticTest.INFINITE, alpha, beta);
	}
		  	
	/**
	 * Liefert den Nichtzentralitaetsparameter &lamda;(n, m, &alpha;, &beta;)
	 * @param n
	 * @param m
	 * @param alpha
	 * @param beta
	 * @return &lamda;
	 */
	public static double getNoncentralityParameter(double n, double m, double alpha, double beta){
		double lowerNCP = Math.pow(
				Math.sqrt(F.quantile(1.0-0.01*alpha, 1, StochasticTest.INFINITE, true, false)) + 
				Math.sqrt(F.quantile(0.02*beta-1.0, 1, StochasticTest.INFINITE,  true, false)), 
				2);
		if (n == 1 && m >= StochasticTest.INFINITE)
			return lowerNCP;
		
		double upperNCP = n*lowerNCP;
		
		if (n < 1) {
			upperNCP = lowerNCP;
			lowerNCP = 0;
		}
		int itr = 0;
		double q1 = F.quantile(1.0-0.01*alpha, n, m, true, false);
		double q2 = NonCentralF.quantile(1.0-0.01*beta, n, m, upperNCP, true, false);
		
		double ncp = upperNCP;
		while (q1 > q2) {
			//upperNCP = upperNCP*2;
			upperNCP += ncp;
			q2 = NonCentralF.quantile(1.0-0.01*beta, n, m, upperNCP, true, false);
		}
		
//		while (Math.abs(q1 - q2) > 0.0001 && itr++ < 200) {
		while (Math.abs(upperNCP - lowerNCP) > 0.0001 && itr++ < 200) {
			ncp = 0.5*(lowerNCP + upperNCP);
			q2 = NonCentralF.quantile(1.0-0.01*beta, n, m, ncp, true, false);
			if (q1 > q2)
				lowerNCP = ncp;
			else
				upperNCP = ncp;
		}
		return 0.5*(lowerNCP + upperNCP);
	}
	
	/**
	 * Liefert die zum kritischen Wert gehoehrende Irrtumswahrscheinlichkeit &alpha; der <em>F</em>-Verteilung.
	 * Die Dimension des Nenners ist &infin;
	 * @param x    kritischen Wert (Quantil)
	 * @param dim  Dimension des Zaehlers
	 * @return &alpha;(dim, &infin;)
	 */
	public static double getAdjustedAlpha(double x, double dim) {
		if (Double.isNaN(x) || Double.isInfinite(x) || x <= 0)
			return Double.POSITIVE_INFINITY;
		return F.cumulative(x, dim, StochasticTest.INFINITE+dim, false, false);
	}
	
	/**
	 * Liefert die zum kritischen Wert gehoehrende Irrtumswahrscheinlichkeit &alpha; der <em>F</em>-Verteilung
	 * @param x     kritischen Wert (Quantil)
	 * @param dim   Dimension des Zaehlers
	 * @param degreeOfFreedom  Dimension des Nenners
	 * @return &alpha;(dim, degreeOfFreedom)
	 */
	public static double getAdjustedAlpha(double x, double dim, double degreeOfFreedom) {
		if (Double.isNaN(x) || Double.isInfinite(x) || x <= 0 || dim <= 0 || degreeOfFreedom <= 0)
			return Double.POSITIVE_INFINITY;
		return F.cumulative(x, dim, degreeOfFreedom, false, false);
	}
}