 /**********************************************************************
 *                      StandardNormalDistribution                      *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * Source: Guenther Gediga,                                             *
 * http://www.experiment-institut4.de/w3lib/normal.htm                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.deprecated;
@Deprecated
public class StandardNormalDistribution {
	private static final double SQRTI2PI = 1.0/Math.sqrt(2.0*Math.PI);
	
	/**
	 * Verteilungsfunktion der Standard-Normal-Verteilung
	 * @param z
	 * @return f
	 * @see <http://www.ggediga.de/w3lib/normal.htm>
	 */
	public static double DISTRIBUTION (double z) {
		double t,t1,a,z1,w,p1,zz,p;
		a = z;
	    if(a<0) 
			a=-a;
	    if (a>6.8) { 
			zz = a*a;
			w  = 1.0-1.0/(zz+3.0-1.0/(0.22*zz+0.704));
			p  = 0.5-SQRTI2PI*Math.exp(-zz/2.0)*w/a;
		}
	    else { 
			int i = 2;
			t = 1.0;
			p = 1.0;
			t1 = a*a/4.0;
			z1 = t1;
			p1 = 0.0;
			boolean canSolv = true;
			while (canSolv) { 
				t = z1*(t1-t)/i;
				i++;
				p += (t/i);
				if (p1==p) 
					canSolv=false;
				if (canSolv) { 
					t1 = z1*(t-t1)/i;
					i++;
					p1 = p;
				}
			}
			p = p*SQRTI2PI*a*Math.exp(-0.5*z1);
	    }
	    if (z < 0.0) 
			return 1.0-(0.5 + p);
	    else 
			return 1.0-(0.5 - p);
	}
	
	/**
	 * Dichtefunktion der Standard-Normal-Verteilung
	 * @param z
	 * @return f
	 */
	public static double DENSITY (double z) {
		return SQRTI2PI*Math.exp(-0.5*z*z);
	}
}


