 /**********************************************************************
 *                        ObservationTestValues                         *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.deprecated;

/**
* Der Individualtest fuer einzelne Beobachtungen 
* @author Michael Loesler <derletztekick.com>
*
*/
@Deprecated
public class ObservationTestValuesOld {
	private final double KpriosAB[], KpostsAB[],
				   		 KpriosA[],  KpostsA[],
				   		 Lamdas[],   Kglobal;

	public ObservationTestValuesOld(int maxDim, double alpha, double beta, int degreeOfFreedom)  {
		//init Arrays
		this.KpriosAB = new double[maxDim];
		this.KpostsAB = new double[maxDim];
		this.KpriosA  = new double[maxDim];
		this.KpostsA  = new double[maxDim];
		this.Lamdas   = new double[maxDim];
		
		for (int i=0; i<this.KpriosAB.length; i++) {
			this.KpriosAB[i] = StochasticTestABMeth.getTprioQuantile((i+1), alpha, beta);
			this.KpostsAB[i] = StochasticTestABMeth.getTpostQuantile(degreeOfFreedom - (i+1), (i+1), alpha, beta);
			
			this.KpriosA[i] = StochasticTestABMeth.getTprioQuantile((i+1), alpha);
			this.KpostsA[i] = StochasticTestABMeth.getTpostQuantile(degreeOfFreedom - (i+1), (i+1), alpha);
			
			this.Lamdas[i] = StochasticTestABMeth.getNoncentralityParameter((i+1), alpha, beta);
		}
		this.Kglobal = StochasticTestABMeth.getTprioQuantile(degreeOfFreedom, alpha, beta);
	}
	
	public ObservationTestValuesOld(int maxDim, double alpha, double beta, int dim, int degreeOfFreedom)  {
		//init Arrays
		this.KpriosAB = new double[maxDim];
		this.KpostsAB = new double[maxDim];
		this.KpriosA  = new double[maxDim];
		this.KpostsA  = new double[maxDim];
		this.Lamdas   = new double[maxDim];
		
		for (int i=0; i<this.KpriosAB.length; i++) {
			this.KpriosAB[i] = StochasticTestABMeth.getTprioQuantile(dim, (i+1), alpha, beta);
			this.KpostsAB[i] = StochasticTestABMeth.getTpostQuantile(dim, degreeOfFreedom - (i+1), (i+1), alpha, beta);
			
			this.KpriosA[i] = StochasticTestABMeth.getTprioQuantile((i+1), alpha);
			this.KpostsA[i] = StochasticTestABMeth.getTpostQuantile(degreeOfFreedom - (i+1), (i+1), alpha);
			
			this.Lamdas[i] = StochasticTestABMeth.getNoncentralityParameter((i+1), alpha, beta);
		}
		this.Kglobal = StochasticTestABMeth.getTprioQuantile(dim, degreeOfFreedom, alpha, beta);
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-priori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKprioA(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpriosA[dimension-1];
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-posteriori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKpostA(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpostsA[dimension-1];
	}	
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-priori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKprioAB(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpriosAB[dimension-1];
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-posteriori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKpostAB(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpostsAB[dimension-1];
	}
	
	/**
	 * Liefert den Nichtzentralitaetsparameter
	 * @param dimension
	 * @return lamda
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getNoncentralityParameter(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.Lamdas[dimension-1];
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> des Globaltests; 
	 * @return k kritischer Wert
	 */
	public double getKprioGlobal() {
		return this.Kglobal;
	}
	
}

