 /**********************************************************************
 *                        ObservationTestValues                         *
 ************************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.deprecated;

/**
 * Der Individualtest fuer einzelne Beobachtungen 
 * @author Michael Loesler <derletztekick.com>
 * @deprecated ersetzt durch {@link com.derletztekick.tools.geodesy.statistic.TestStatisticParameters}
 */
@Deprecated
public class ObservationTestValues {
	private final double KpriosAB[], KpostsAB[], KglobalAB[], 
						 alphasPrio[], alphasPost[],
				   		 KpriosA[],	 KpostsA[],
				   		 Lamdas[],
				   		 Kglobal, alphaGlobal, alpha, beta;
	public ObservationTestValues(double alpha, double beta, int degreeOfFreedom)  {
		this(alpha, beta, 1, degreeOfFreedom);
	}
	
	public ObservationTestValues(double alpha, double beta, int dim, int degreeOfFreedom)  {
		this(3, alpha, beta, dim, degreeOfFreedom);
	}
	
	public ObservationTestValues(int k, double alpha, double beta, int degreeOfFreedom)  {
		this(k, alpha, beta, 1, degreeOfFreedom);
	}
	
	public ObservationTestValues(int k, double alpha, double beta, int dim, int degreeOfFreedom)  {
		this.KpriosAB = new double[k];
		this.KpostsAB = new double[k];
		this.KpriosA  = new double[k];
		this.KpostsA  = new double[k];
		this.Lamdas   = new double[k];
		this.alphasPrio = new double[k];
		this.alphasPost = new double[k];
		this.KglobalAB  = new double[2];
		
		//init Arrays
		for (int i=0; i<this.KpriosAB.length; i++) {
			this.KpriosAB[i] = StochasticTest.getTprioQuantile(dim, (i+1), alpha, beta);
			this.KpostsAB[i] = StochasticTest.getTpostQuantile(dim, degreeOfFreedom - (i+1), (i+1), alpha, beta);
			
			this.alphasPrio[i] = StochasticTest.getAdjustedAlpha(this.KpriosAB[i], (i+1));
			this.alphasPost[i] = StochasticTest.getAdjustedAlpha(this.KpostsAB[i], (i+1), degreeOfFreedom - (i+1));
			
			this.KpriosA[i] = StochasticTest.getTprioQuantile((i+1), alpha);
			this.KpostsA[i] = StochasticTest.getTpostQuantile(degreeOfFreedom - (i+1), (i+1), alpha);
			
			this.Lamdas[i] = StochasticTest.getNoncentralityParameter((i+1), alpha, beta);
			
			
		}
		this.Kglobal     = StochasticTest.getTprioQuantile(dim, degreeOfFreedom, alpha, beta);
		this.alphaGlobal = StochasticTest.getAdjustedAlpha(this.Kglobal, degreeOfFreedom);
		this.KglobalAB[0] = StochasticTest.getTprioQuantile(degreeOfFreedom, 100.0 - 50.0 * this.alphaGlobal);
		this.KglobalAB[1] = StochasticTest.getTprioQuantile(degreeOfFreedom,         50.0 * this.alphaGlobal);
		this.alpha = alpha;
		this.beta  = beta;
	}
	
	/**
	 * Liefert den kritischen Wert (einseitig) fuer einen beliebigen Freiheitsgrad trgDim, der auf den srcDim abgestimmt wurde 
	 * @param srcDim
	 * @param trgDim
	 * @return k
	 */
	public double getKprioAB(double srcDim, double trgDim) {
		return StochasticTest.getTprioQuantile(srcDim, trgDim, this.alpha, this.beta);
	}
	
	/**
	 * Liefert die kritischen Werte (zweiseitig) des Vertrauensbereichs fuer einen beliebigen Freiheitsgrad trgDim, der auf den srcDim abgestimmt wurde 
	 * @param srcDim
	 * @param trgDim
	 * @return k
	 */
	public double[] getKprioBoundariesAB(double srcDim, double trgDim) {
		double k = StochasticTest.getTprioQuantile(srcDim, trgDim, this.alpha, this.beta);
		double alpha = StochasticTest.getAdjustedAlpha(k, trgDim);

		return new double[] {
				StochasticTest.getTprioQuantile(trgDim, 100.0 - 50.0 * alpha),
				StochasticTest.getTprioQuantile(trgDim,         50.0 * alpha)
		};
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> des Globaltests (einseitig); 
	 * @return k kritischer Wert
	 */
	public double getKprioGlobal() {
		return this.Kglobal;
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> des Globaltests (zweiseitig); 
	 * @return k kritischer Wert
	 */
	public double[] getKprioBoundariesGlobal() {
		return this.KglobalAB;
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-priori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKprioA(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpriosA[dimension-1];
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-posteriori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKpostA(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpostsA[dimension-1];
	}	
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-priori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKprioAB(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpriosAB[dimension-1];
	}
	
	/**
	 * Liefert den kritischen Wert <code>K</code> der <em>F</em>-Verteilung
	 * auf Grundlage des a-posteriori Varianzfaktors
	 * @param dimension Dimension der Testgroesse
	 * @return k kritischer Wert
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getKpostAB(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.KpostsAB[dimension-1];
	}
	
	/**
	 * Liefert anhand der Dimension das &alpha; der <em>F</em>-Verteilung fuer einen a-priori Test
	 * @param dimension Dimension der Testgroesse
	 * @return &alpha; Irrtumswahrscheinlichkeit
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getAlphaPrio(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.alphasPrio[dimension-1];
	}
	
	/**
	 * Liefert anhand der Dimension das &alpha; der <em>F</em>-Verteilung fuer einen a-posteriori Test
	 * @param dimension Dimension der Testgroesse
	 * @return &alpha; Irrtumswahrscheinlichkeit
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getAlphaPost(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.alphasPost[dimension-1];
	}
	
	/**
	 * Liefert den Nichtzentralitaetsparameter
	 * @param dimension
	 * @return lamda
	 * @throws ArrayIndexOutOfBoundsException
	 */
	public double getNoncentralityParameter(int dimension) throws ArrayIndexOutOfBoundsException {
		return this.Lamdas[dimension-1];
	}
	
	/**
	 * Liefert das &alpha; der <em>F</em>-Verteilung fuer den Globaltest
	 * @return k kritischer Wert
	 */
	public double getAlphaGlobal() {
		return this.alphaGlobal;
	}	
}

