  /**********************************************************************
  *                               ABMeth                                 *
  ************************************************************************
  * Copyright (C) by Michael Loesler, http://derletztekick.com           *
  *                                                                      *
  * This program is free software; you can redistribute it and/or modify *
  * it under the terms of the GNU General Public License as published by *
  * the Free Software Foundation; either version 3 of the License, or    *
  * (at your option) any later version.                                  *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
  * GNU General Public License for more details.                         *
  *                                                                      *
  * You should have received a copy of the GNU General Public License    *
  * along with this program; if not, see <http://www.gnu.org/licenses/>  *
  * or write to the                                                      *
  * Free Software Foundation, Inc.,                                      *
  * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
  *                                                                      *
   **********************************************************************/

package com.derletztekick.tools.geodesy.deprecated;

import com.derletztekick.tools.geodesy.Constant;
import com.derletztekick.tools.geodesy.distribution.F;

/**
 * Die Klasse ABMeth dient zur gegenseitigen Abstimmung der Irrtumswahrscheinlichkeiten 
 * &alpha;<sub>1</sub> und &alpha;<sub>2</sub> zweiter F<sub>m,n</sub>-verteilten Testgroessen.
 * 
 * <em>Bemerkung: </em> Die Funktion lag als FORTRAN77-Code vor und wurde lediglich in JAVA lauffaehig gemacht.
 * Der Code ist daher extrem unuebersichtlich, vieles ist doppel bzw. unnoetig verkompliziert. Kurz, es besteht
 * hier Optimierungsbedarf. Die korrekten Ergebnisse entschaedigen dies jedoch vorlaufig ;-)
 * 
 * @see <[Hahn et al., 1991] Ein Verfahren zur Abstimmung der Signifikanzniveaus fuer allgemeine F<sub>m,n</sub>-verteilte Teststatistiken - Teil II: Anwendung, Zeitschrift fuer Vermessungswesen (ZfV) 116(1)>
 * 
 * @author Michael Loesler <derletztekick.com>
 *
 */
@Deprecated
public class ABMeth {

	private double alf0 = 0.001, bet0 = 0.8;
	
    private  double alfa, fwert, lam = 10.0, betq;
    private  double EPS2 = Math.sqrt(Constant.EPS), //1.0E-8,
                    EPS3 = Math.sqrt(Constant.EPS),
                    EPS4 = Math.sqrt(Constant.EPS),
                    EPS5 = Math.sqrt(Constant.EPS);
	
	
	public ABMeth(int m1, int n1, int m2, int n2, double alpha, double beta) {
        double quantile;
        this.fwert = quantile = F.finv(1.0 - 0.01*alpha, m1, n1);

        if (this.fwert <=0) {
			this.alfa = alf0;
			this.fwert = -1;
			return;
		}
        
//		if (this.fwert <=0 || (m1 == 1 && n1 == 2) || (m1 == 2 && n2 == 3) || ((m1 < 1) || (n1 <= m1)) || ((m2 < 1) || (n2 <= m2)) || (alpha <= 0) || (alf0 > 1) || (beta <= 0.5) || (beta > 1)) {
        if ((m1 == 1 && n1 == 2) || (m1 == 2 && n2 == 3) || ((m1 < 1) || (n1 <= m1)) || (m2 < 1) || (alpha <= 0) || (alpha > 1) || (beta <= 0.5) || (beta > 1)) {
        	throw new IllegalArgumentException(this.getClass().getSimpleName() + " Ungueltige Initialisierungsparameter!");
        }

		this.alf0 = alpha;
		this.bet0 = beta;
		
		if (!this.calcLamda(m1, n1) || !this.calcALPHA(m2, n2)) {
			this.alfa = alf0;
			this.fwert = quantile;
		}
	}
	

	/**
	 * Bestimmt den Nichtzentralitätsparameter zwischen den F-Verteilungen
	 * @param m Freiheitsgrad
	 * @param n Freiheitsgrad
	 * @return isCalulated
	 */
	private boolean calcLamda(int m, int n) {
		boolean b1, b2;
		double aj, nj, x = 1, gn = 6.0, fn = this.fwert, emx = 0, flam, elam, emxlog;
		double s0, n0, sj, fj, pj, p0, fakt, dl;
		double fsum, psum, sum, kx;
		double adl = Double.MAX_VALUE;
		int og1, og2;


		int nm2 = n-2,
		    mm2 = m-2;


		double rn2 = (double)nm2,
			   rm  = (double)m,
			   rn22 = rn2/2.0,
			   rm22 = (double)mm2/2.0,
			   rm2 = rm/2.0,
			   rnn = (double)n/2.0,
			   fak  = 1.0 + rn2/rm,
			   fak2 = rm2/rnn,
			   k    = 0.5/Math.atan(1.0);

		b1 = !(m%2==0);
		b2 = !(n%2==0);

		og1 = (int)(rm22+0.00001);
		og2 = (int)(rn22+0.00001);

		if (b1 && b2) {
			og1 = (int)((m-1)/2);
			og2 = (int)((n-3)/2);
		}

		x = 1.0/(1.0+fak2*fn);
		emx = 1.0 - x;

		while (x <= 0 || (emx/x) <= 0) {
			gn = gn - 0.1;
			fn = gn;

			if (gn <= 0) {
				System.err.println(this.getClass().getSimpleName() + " Fehler beim Berechnen der unvollstaendigen Beta-Funktion!");
				return false;
			}
			x = 1.0/(1.0+fak2*fn);
			emx = 1.0 - x;
		}
		kx = Math.sqrt(emx/x);

		do {
			flam = this.lam/2.0;
			elam = Math.exp(-flam);

			// N und M ungerade
			if (b1 && b2) {
				aj = Math.log10(k) + Math.log10(x);
				sum = Math.pow(10,aj);


				for (int j=1; j<=og2; j++) {
					aj = aj + Math.log10(x/(1.0+1.0/(((double)(2*j)))));
					sum = sum + Math.pow(10,aj);
				}
				s0 = k*Math.atan(kx)+kx*sum;
				aj = aj - Math.log10(kx);
				sum = 0.0;
				emxlog = Math.log10(emx);

				for (int j=1; j<=og1; j++) {
					aj = aj + emxlog + Math.log10(1.0+rn2/(((double)(2*j-1))));
					sum = sum + Math.pow(10,aj);
				}

				s0 = s0-sum;
				aj = Math.pow(10,aj);
				n0 = aj*emx*fak;

			}
			// N gerade m ungerade
			else if (b1) {
				aj = rm2 * Math.log10(emx);
				emxlog = Math.log10(x);
				sum = Math.pow(10,aj);
				for (int j=1; j<=og2; j++) {
					aj = aj + emxlog + Math.log10( 1.0 + rm22/((double)j) );
					sum = sum + Math.pow(10,aj);
				}

				aj = Math.pow(10,aj);
				s0 = sum;
				n0 = aj*x*fak;
			}
			// M gerade
			else {
				aj = rnn * Math.log10(x);
				sum = Math.pow(10,aj);
				emxlog = Math.log10(emx);
				for (int j=1; j<=og1; j++) {
					aj = aj + emxlog + Math.log10( 1.0 + rn22/((double)j) );
					sum = sum + Math.pow(10,aj);
				}
				aj = Math.pow(10,aj);
				s0 = 1.0-sum;
				n0 = aj*emx*fak;
			}
			s0 = s0 > 0.999999?0.999999:s0;
			p0 = -s0;
			sum = s0;
			fsum = rm2*n0;
			psum = p0;
			sj = s0;
			pj = p0;
			nj = n0;

			int j = 1;
			do {
				fakt = flam/(double)j;
				pj = (1.0-fakt)*(sj-nj);
				sj = fakt*(sj-nj);
				nj = fakt*emx*nj*(1.0+rn2/(rm+2.0*(double)j));
				fj = (rm2+(double)j)*nj;
				sum = sum+sj;
				psum = psum + pj;
				fsum = fsum + fj;
				j=j+1;
			}
			while( Math.abs(sj/sum) > EPS2 || Math.abs(fj/fsum) > EPS3 || Math.abs(pj/psum) > EPS4);

			this.betq = 1.0-elam*sum;
			double p = 0.5*(elam*psum);
			dl = (this.betq-this.bet0)/p;
			dl = dl>10?10.0:dl;
			this.lam = this.lam + dl;
			adl = Math.abs(dl);
			EPS4 = 0.05*EPS5/adl;
		}
		while (adl >= EPS5);

		if (Double.isNaN(this.betq) || Double.isNaN(this.lam))
			return false;
		return true;
	}
	
	/** 
	 * Berechnung der abgestimmten Irrtumswahrscheinlichkeit und zugehoeriges Quantil
	 * @param m Freiheitsgrad
	 * @param n Freiheitsgrad
	 * @return isCalulated
	 */
    private boolean calcALPHA(int m, int n) {
    	boolean b1, b2;

        double aj, nj, x = 1, gn = 6.0, fn, emx = 0, flam, elam, emxlog;
        double s0, n0, sj, fj, pj, p0, fakt, df;
        double fsum, psum, sum, kx;
        double adf = Double.MAX_VALUE;
        int og1, og2;


        fn = 6.0;
        gn = fn;

        int nm2 = n-2,
        mm2 = m-2;


		double rn2 = (double)nm2,
		   	   rm  = (double)m,
		   	   rn22 = rn2/2.0,
		   	   rm22 = (double)mm2/2.0,
		   	   rm2 = rm/2.0,
		   	   rnn = (double)n/2.0,
		   	   fak  = 1.0 + rn2/rm,
		   	   fak2 = rm2/rnn,
		   	   k    = 0.5/Math.atan(1.0);

		b1 = !(m%2==0);
		b2 = !(n%2==0);

		og1 = (int)(rm22+0.00001);
		og2 = (int)(rn22+0.00001);

		if (b1 && b2) {
			og1 = (int)((m-1)/2);
			og2 = (int)((n-3)/2);
		}

		do {
			x = 1.0/(1.0+fak2*fn);
			emx = 1.0 - x;
                     
			while (x <= 0 || (emx/x) <= 0) {
				gn = gn - 0.1;
				fn = gn;

				if (gn <= 0) {
					System.err.println(this.getClass().getSimpleName() + " Fehler beim Berechnen der unvollstaendigen Beta-Funktion!");
					return false;
				}
				x = 1.0/(1.0+fak2*fn);
				emx = 1.0 - x;
			}
			kx = Math.sqrt(emx/x);
			flam = this.lam/2.0;
			elam = Math.exp(-flam);

			// N und M ungerade
			if (b1 && b2) {
				aj = Math.log10(k) + Math.log10(x);
				sum = Math.pow(10,aj);

				for (int j=1; j<=og2; j++) {
					aj = aj + Math.log10(x/(1.0+1.0/(((double)(2*j)))));
					sum = sum + Math.pow(10,aj);
				}

				s0 = k*Math.atan(kx)+kx*sum;
				aj = aj - Math.log10(kx);
				sum = 0.0;
				emxlog = Math.log10(emx);

				for (int j=1; j<=og1; j++) {
					aj = aj + emxlog + Math.log10(1.0+rn2/(((double)(2*j-1))));
					sum = sum + Math.pow(10,aj);
				}

				s0 = s0-sum;
				aj = Math.pow(10,aj);
				n0 = aj*emx*fak;
			}
			// N gerade M ungerade
			else if (b1) {
				aj = rm2 * Math.log10(emx);
				emxlog = Math.log10(x);
				sum = Math.pow(10,aj);

				for (int j=1; j<=og2; j++) {
					aj = aj + emxlog + Math.log10( 1.0 + rm22/((double)j) );
					sum = sum + Math.pow(10,aj);
				}
                               
				aj = Math.pow(10,aj);
				s0 = sum;
				n0 = aj*x*fak;
			}
			// M gerade
			else {
				aj = rnn * Math.log10(x);
				sum = Math.pow(10,aj);
				emxlog = Math.log10(emx);
				for (int j=1; j<=og1; j++) {
					aj = aj + emxlog + Math.log10( 1.0 + rn22/((double)j) );
					sum = sum + Math.pow(10,aj);
				}

				aj = Math.pow(10,aj);
				s0 = 1.0-sum;
				n0 = aj*emx*fak;
			}
			s0 = s0 > 0.999999?0.999999:s0;
			p0 = -s0;
			sum = s0;
			fsum = rm2*n0;
			psum = p0;
			sj = s0;
			pj = p0;
			nj = n0;

			int j = 1;
			do {
				fakt = flam/(double)j;
				pj = (1.0-fakt)*(sj-nj);
				sj = fakt*(sj-nj);
				nj = fakt*emx*nj*(1.0+rn2/(rm+2.0*(double)j));
				fj = (rm2+(double)j)*nj;
				sum = sum+sj;
				psum = psum + pj;
				fsum = fsum + fj;
				j=j+1;
			}
			while( Math.abs(sj/sum) > EPS2 || Math.abs(fj/fsum) > EPS3 || Math.abs(pj/psum) > EPS4);

			betq = 1.0-elam*sum;
			double f = elam*fak2*fsum/(kx*kx);
			//System.out.println("BETQ1  "+betq+"  "+elam+"  "+sum);

			df = (this.betq-this.bet0)/f;
			df = df>10?10.0:df;
			fn = fn + df;
			EPS2 = f*EPS5*0.05/this.betq;
			adf = Math.abs(df);
			EPS3 = 0.05*EPS5/adf;

		}
		while (adf >= EPS5);
		this.fwert = fn;
		double fzent = rm2*x*aj*(1.0+rm22/rnn);
		if (b1 && !b2) {
			fzent = fzent/(kx*kx);
		}
		this.alfa = 1.0-s0-fzent*df;
		if (Double.isNaN(this.betq) || Double.isNaN(this.alfa) || Double.isNaN(this.fwert))
			return false;
		return true;

    }
	

    /**
     * Liefert die abgestimmte Irrtumswahrscheinlichkeit
     * @return alfa
     */
	public double getAdjustedAlpha() {
		return this.alfa;
	}
	
	/**
	 * Liefert das Qualtil der abgestimmten Irrtumswahrscheinlichkeit
	 * @return fwert
	 */
	public double getAdjustedQuantile() {
		return this.fwert;
	}
	
	/**
	 * Liefert den Nichtzentralitätsparameter
	 * @return lam
	 */
	public double getNoncentralityParameter() {
		return this.lam;
	}


}
