 /**********************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.delaunay;

public class Point3D extends Point2D {
	private double z = 0;
	public Point3D(String id, double x, double y, double z) {
		super(id, x, y);
		this.z = z;
	}
	
	public double getZ() {
		return this.z;
	}

	public double distance(Point3D p) {
		double dx = this.getX() - p.getX();
		double dy = this.getY() - p.getY();
		double dz = this.z - p.getZ();
		return Math.sqrt(dx*dx + dy*dy + dz*dz);
	}
	
	public String toString() {
		return this.getClass().getSimpleName() + " ID: " + this.getId() + " [" + this.getX() + " / " + this.getY() + " / " + this.z + "]";
	}
	
	public Point3D clone() {
		return new Point3D(this.getId(), this.getX(), this.getY(), this.z);
	}
}
