 /**********************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy.delaunay;

public class Circle2D {
	private Point2D centerPoint;
	private double r=-1;
	private boolean isCircle = false;
	
	private Point2D[] circlePoints = new Point2D[3];
	
	public Circle2D(Point2D pi, Point2D pj, Point2D pk) {
		this.init(pi, pj, pk);
	}
	
	public boolean isCircle() {
		//return (xk-xj)*(yj-yi) - (xj-xi)*(yk-yi) == 0;
		return this.isCircle;
	}
	
	/**
	 * Liefert den Radius
	 * @return r
	 */
	public double getRadius() {
		return this.r;
	}
	
	/**
	 * Gibt den Mittelpunkt zurueck
	 * @return center
	 */
	public Point2D getCenter() {
		return this.centerPoint;
	}
	
	/**
	 * Gint die drei Punkte, die den Kreis definieren, zurueck.
	 * @return circlePoints
	 */
	public Point2D[] getCirclePoints() {
		return this.circlePoints;
	}
	
	/**
	 * Ermittelt, ob ein Punkt p im Kreis liegt
	 * Im Kreis   == -1
	 * Auf Kreis  ==  0
	 * Ausserhalb ==  1
	 * 
	 * @param p
	 * @return inCircle
	 */
	public int containsPoint(Point2D p) {
		for (Point2D point : this.circlePoints)
			if (p.getId().equals(point.getId()))
				return 0;
		return (int)Math.signum(this.centerPoint.distance(p) - this.r);
	}
	
	private void init(Point2D pi, Point2D pj, Point2D pk) {
		double xc = 0;
		double yc = 0;
		double xi = pi.getX(); 
		double yi = pi.getY();  
		double xj = pj.getX();  
		double yj = pj.getY();  
		double xk = pk.getX();  
		double yk = pk.getY(); 
		
		double det = (xk-xj)*(yj-yi) - (xj-xi)*(yk-yj);
		this.isCircle = det != 0;

		if (this.isCircle) {
			xc = (yk-yj)*(xi*xi+yi*yi) + (yi-yk)*(xj*xj+yj*yj) + (yj-yi)*(xk*xk+yk*yk);
			yc = (xk-xj)*(xi*xi+yi*yi) + (xi-xk)*(xj*xj+yj*yj) + (xj-xi)*(xk*xk+yk*yk);
			
			xc *=  0.5/det;
			yc *= -0.5/det;
			
			this.centerPoint = new Point2D(this.getClass().getSimpleName(), xc, yc);
			this.r = this.centerPoint.distance(pi);

			this.circlePoints = new Point2D[] {
					pi, pj, pk
			};
		}
	}
	
	@Override
	public String toString() {
		return this.getClass().getSimpleName() + " [" + this.centerPoint.getX() + " / " + this.centerPoint.getY() + "] r = " + this.r; 
	}
}
