 /**********************************************************************
 * Copyright (C) by Michael Loesler, http://derletztekick.com           *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy;

import com.derletztekick.tools.geodesy.MathExtension;

import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public class UpperSymmSparseMatrix extends FlexCompRowMatrix {
	private long onesOnMainDiag = 0;
		
	public UpperSymmSparseMatrix(int size) {
		super(size, size);
	}
		
	public UpperSymmSparseMatrix(Matrix m) {
		this(Math.min(m.numColumns(), m.numRows()));
		this.set(m);
		this.compact();
	}
	
//	private void setMatrix(Matrix matrix) {
//		for (MatrixEntry element : matrix) {
//			this.set(element.row(), element.column(), element.get());
//		}	
//	}
	
	@Override
	public boolean isSquare() {
		return true;
	}

	@Override
	public void set(int row, int column, double value) {
		double oldValue = this.get(row, column);
		if (row == column) {
			if (oldValue == 1 && value != 1)
				this.onesOnMainDiag--;
			else if (oldValue != 1 && value == 1)
				this.onesOnMainDiag++;
			super.set(column,row,value);
		}
		else if (row > column)				
			super.set(column,row,value);
		else
			super.set(row,column,value);
	}
	
	public long onesOnMainDiag() {
		return this.onesOnMainDiag;
	}
	
	public Matrix getSymmSubMatrix(int indices[]) {
		if (this.onesOnMainDiag == this.numColumns && this.numSuperDiagonals() == 0)
			return MathExtension.identity(indices.length);
		return new UpperSymmSparseMatrix(Matrices.getSubMatrix(this, indices, indices));		
	}

	public int numSubDiagonals() {
		return this.numSuperDiagonals();
	}
	
	public int numSuperDiagonals() {
        int ku = 0;
        for (MatrixEntry element : this) {
            ku = Math.max(ku, element.column() - element.row());
            // Vollbesetzt
            if (ku+1 == this.numColumns)
            	break;
        }
        return ku;
    }
	
	@Override
	public double get(int row, int column) {
		if (row > column)
			return super.get(column,row);
		return super.get(row,column);
	}
	
	@Override
	public Vector solve(Vector b, Vector x) {
		Matrix A = new UpperSymmPackMatrix(this);
		A.solve(b, x);
		return x;
	}
	
	@Override
	public Matrix solve(Matrix B, Matrix X) {
		Matrix A = new UpperSymmPackMatrix(this);
		A.solve(B, X);
		return new UpperSymmSparseMatrix(X);
	}
}
