 /**********************************************************************
 *                              Constant                                *
 ************************************************************************
 * Copyright (C) 2008 by Michael Loesler, http://derletztekick.com      *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 3 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, see <http://www.gnu.org/licenses/>  *
 * or write to the                                                      *
 * Free Software Foundation, Inc.,                                      *
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
 *                                                                      *
  **********************************************************************/

package com.derletztekick.tools.geodesy;

/**
 * Klasse mit ein paar (Natur)konstanten
 * @author Michael Loesler <derletztekick.com>
 *
 */
public final class Constant {
	
	/**
	 * <code>&rho;<sub>DEG -> RAD</sub> = &pi; / 180</code>
	 * Konstante zum Umrechnen von Winkeln: Grad ins Bogenma&szlig; 
	 */
	public static final double RHO_DEG2RAD = Math.PI/180.0;
	
	/**
	 * <code>&rho;<sub>RAD -> DEG</sub> = 180 / &pi;</code>
	 * Konstante zum Umrechnen von Winkeln: Bogenma&szlig in Grad; 
	 */
	public static final double RHO_RAD2DEG = 180.0/Math.PI;
	
	/**
	 * <code>&rho;<sub>DEG -> GRAD</sub> = 200 / 180</code>
	 * Konstante zum Umrechnen von Winkeln: Altgrad nach Neugrad 
	 */
	public static final double RHO_DEG2GRAD = 200.0/180.0;	
	
	/**
	 * <code>&rho;<sub>GRAD -> DEG</sub> = 180 / 200</code>
	 * Konstante zum Umrechnen von Winkeln: Neugrad nach Altgrad 
	 */
	public static final double RHO_GRAD2DEG = 180.0/200.0;	

	/**
	 * <code>&rho;<sub>GRAD -> RAD</sub> = &pi; / 200</code>
	 * Konstante zum Umrechnen von Winkeln: Neugrad ins Bogenma&szlig; 
	 */
	public static final double RHO_GRAD2RAD = Math.PI/200.0;

	/**
	 * <code>&rho;<sub>RAD -> GRAD</sub> = 200 / &pi;</code>
	 * Konstante zum Umrechnen von Winkeln: Bogenma&szlig; nach Neugrad 
	 */
	public static final double RHO_RAD2GRAD = 200.0/Math.PI;
	
	/**
	 * Erdradius R=6371000m
	 */
	public static final double EARTH_RADIUS = 6371000.0;


	/**
	 * EPS - Gleitkommazahlgenauigkeit.
	 */
	public static final double EPS = Constant.mashEPS();
 
	/**
	 * Methode zum Berechnen der relativen EPS-Genauigkeit.
	 * @return Relative EPS-Genauigkeit
	 * @see Gisela Engeln-Mllges und Fritz Reutter: Formelsammlung zur Numerischen Mathematik mit C-Programmen
	 */
	private static double mashEPS(){
		double eps=1.0,x=2.0,y=1.0;
		while (y<x) {
			eps *= 0.5;
			x = 1.0+eps;
		}
		return eps;
	}
	
//	/**
//	 * Methode zum Berechnen der relativen Gleitkommazahlgenauigkeit.
//	 * 
//	 * @return Relative EPS-Genauigkeit
//	 * @see http://en.wikipedia.org/wiki/Machine_epsilon#Approximation_using_Java
//	 */
//	private static double mashEPS(){
//		double eps = 1.0;
//		do {
//			eps /= 2.0;
//		} while ((1.0 + (eps/2.0)) != 1.0);
//		return eps;
//	}
}
