  /**********************************************************************
  *                               Babel                                  *
  ************************************************************************
  * Copyright (C) by Michael Loesler, http://derletztekick.com           *
  *                                                                      *
  * This program is free software; you can redistribute it and/or modify *
  * it under the terms of the GNU General Public License as published by *
  * the Free Software Foundation; either version 3 of the License, or    *
  * (at your option) any later version.                                  *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
  * GNU General Public License for more details.                         *
  *                                                                      *
  * You should have received a copy of the GNU General Public License    *
  * along with this program; if not, see <http://www.gnu.org/licenses/>  *
  * or write to the                                                      *
  * Free Software Foundation, Inc.,                                      *
  * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
  *                                                                      *
   **********************************************************************/

package com.derletztekick.tools.babel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.swing.JOptionPane;

public class Babel {
	private ResourceBundle message;
	private Locale currentLocale;
	
	private String errorMsgNoLangBody  = "Die Sprachdatei (%s) oder Teile von dieser konnte nicht geladen werden! Das Programm wird beendet.",
	   			   errorMsgNoLangTitle = "Fehler beim Laden der Sprachdatei";
	
	
	public Babel(String resource) {
		this.setLocale(resource, Locale.getDefault());
	}
	
	public Babel(String resource, Locale locale) {
		this.setLocale(resource, locale);
	}
	
	public void setLocale(String resource, Locale locale) {
		this.currentLocale = locale;
		try {
			this.message = ResourceBundle.getBundle(resource, this.currentLocale);
		}
		catch (Exception e) {
			JOptionPane.showMessageDialog(null,
				    String.format(errorMsgNoLangBody+"\n"+e, this.currentLocale), 
				    errorMsgNoLangTitle,
				    JOptionPane.ERROR_MESSAGE
			);
			System.exit(-1);
		}
	}	
	
	public String[] getStringArray(String className, String key) {
		try {
			return this.message.getString(className+"."+key).trim().split(",\\s+");
		}
		catch (Exception e) {
			JOptionPane.showMessageDialog(null,
				    String.format(errorMsgNoLangBody+"\n"+e, this.currentLocale), 
				    errorMsgNoLangTitle,
				    JOptionPane.ERROR_MESSAGE
			);
		}
		return null; 
	}
	
	public String getString(String className, String key) {
		try {
			return this.message.getString(className+"."+key);
		}
		catch (Exception e) {
			JOptionPane.showMessageDialog(null,
				    String.format(errorMsgNoLangBody+"\n"+e, this.currentLocale), 
				    errorMsgNoLangTitle,
				    JOptionPane.ERROR_MESSAGE
			);
		}
		return "N/A";
	}
	
	public Locale getLocale() {
		return this.currentLocale;
	}
	
	public void writeToFile(File file) {
		try {
			Properties properties = new Properties();
			FileOutputStream fileOut = new FileOutputStream(file);
			Map<String, String> map = convertResourceBundleToMap(this.message);

			Iterator<String> iterator = map.keySet().iterator();
			while (iterator.hasNext()) {
				String key = (String) iterator.next();
				String value = map.get(key);
				System.out.println("key = " + key + ", " + "value = " + value);
				properties.setProperty(key, value);
			}
			properties.store(fileOut, "Auto-Exported File");
			fileOut.close();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	static Map<String, String> convertResourceBundleToMap(ResourceBundle resource) {
		Map<String, String> map = new LinkedHashMap<String, String>();

		Enumeration<String> keys = resource.getKeys();
		while (keys.hasMoreElements()) {
			String key = keys.nextElement();
			map.put(key, resource.getString(key));
		}

		return map;
	}
}
