/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class NTReader {
    public NTGrid[] read(String filePath) throws Exception {
        return this.read(Paths.get(filePath, new String[0]));
    }

    public NTGrid[] read(File file) throws Exception {
        return this.read(file.toPath());
    }

    public abstract NTGrid[] read(Path var1) throws Exception;

    static Date toDate(String dateString) {
        String[] dateFormatPatterns;
        String[] stringArray = dateFormatPatterns = new String[]{"yy-MM-dd", "ddMMyyyy", "M/y", "M/d/y", "M-d-y", "yyyy-MM-dd", "yyyyy/MM/dd", "dd/MM/yyyyy", "dd-MM-yyyy", "yyyy MMM dd", "yyyy dd MMM", "dd MMM yyyy", "dd MMM", "MMM dd", "dd MMM yyyy", "yyyyMMdd"};
        int n = dateFormatPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            try {
                return new SimpleDateFormat(pattern).parse(dateString);
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        return null;
    }

    static NTGrid[] allocateSubGrids(NTGrid[] ntGrids) {
        if (ntGrids == null) {
            return null;
        }
        int i = 0;
        while (i < ntGrids.length) {
            NTGrid ntChildGrid = ntGrids[i];
            if (ntChildGrid.getParentName() != null && !ntChildGrid.getParentName().equalsIgnoreCase("NONE")) {
                int j = 0;
                while (j < ntGrids.length) {
                    NTGrid ntParentGrid = ntGrids[j];
                    if (i != j && ntParentGrid.getSubFileName().equals(ntChildGrid.getParentName())) {
                        ntChildGrid.setParent(ntParentGrid);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ntGrids;
    }
}

