/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTGridValue;
import com.derletztekick.geodesy.geotra.io.nt.NTHeader;

public class NTMemoryGrid
extends NTGrid {
    private NTGridValue[] values = null;

    NTMemoryGrid(NTHeader ntHeader) {
        super(ntHeader);
    }

    @Override
    void setNumberOfGridShiftValues(int gsCount) {
        this.values = new NTGridValue[gsCount];
        super.setNumberOfGridShiftValues(gsCount);
    }

    void add(int index, NTGridValue value) {
        if (this.values != null) {
            this.values[index] = value;
        }
    }

    @Override
    public NTGridValue[] get(int indexSE, int indexNE, int indexSW, int indexNW) {
        int[] indices = new int[]{indexSE, indexNE, indexSW, indexNW};
        NTGridValue[] ntGridValues = new NTGridValue[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index < 0 || this.getNumberOfGridShiftValues() < 0 || index >= this.getNumberOfGridShiftValues()) {
                return null;
            }
            ntGridValues[i] = this.values[index];
            ++i;
        }
        return ntGridValues;
    }
}

