/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTUnit;

public class NTHeader {
    private int numOREC = -1;
    private int numSREC = -1;
    private int numFILE = -1;
    private double majorF = -1.0;
    private double minorF = -1.0;
    private double majorT = -1.0;
    private double minorT = -1.0;
    private NTUnit unit = null;
    private String systemF = null;
    private String systemT = null;
    private String version = null;

    public boolean isComplete() {
        return this.numOREC > 0 && this.numSREC > 0 && this.numFILE > 0 && this.majorF > 0.0 && this.minorF > 0.0 && this.majorT > 0.0 && this.minorT > 0.0 && this.systemF != null && this.systemT != null && this.version != null && this.unit != null;
    }

    public int getNumberOfOverviewRecordFields() {
        return this.numOREC;
    }

    void setNumberOfOverviewRecordFields(int numOREC) {
        this.numOREC = numOREC;
    }

    public int getNumberOfGridHeaderRecordFields() {
        return this.numSREC;
    }

    void setNumberOfGridHeaderRecordFields(int numSREC) {
        this.numSREC = numSREC;
    }

    public int getNumberOfSubFiles() {
        return this.numFILE;
    }

    void setNumberOfSubFiles(int numFILE) {
        this.numFILE = numFILE;
    }

    public double getMajorFrom() {
        return this.majorF;
    }

    void setMajorFrom(double majorF) {
        this.majorF = majorF;
    }

    public double getMinorFrom() {
        return this.minorF;
    }

    void setMinorFrom(double minorF) {
        this.minorF = minorF;
    }

    public double getMajorTo() {
        return this.majorT;
    }

    void setMajorTo(double majorT) {
        this.majorT = majorT;
    }

    public double getMinorTo() {
        return this.minorT;
    }

    void setMinorTo(double minorT) {
        this.minorT = minorT;
    }

    public NTUnit getUnit() {
        return this.unit;
    }

    void setUnit(NTUnit unit) {
        this.unit = unit;
    }

    public String getSystemFrom() {
        return this.systemF;
    }

    void setSystemFrom(String systemF) {
        this.systemF = systemF;
    }

    public String getSystemTo() {
        return this.systemT;
    }

    void setSystemTo(String systemT) {
        this.systemT = systemT;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "NTHeader [numOREC=" + this.numOREC + ", numSREC=" + this.numSREC + ", numFILE=" + this.numFILE + ", majorF=" + this.majorF + ", minorF=" + this.minorF + ", majorT=" + this.majorT + ", minorT=" + this.minorT + ", unit=" + String.valueOf((Object)this.unit) + ", systemF=" + this.systemF + ", systemT=" + this.systemT + ", version=" + this.version + "]";
    }
}

