/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.projection.MapProjection;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.geodesy.geotra.io.nt.NTGridValue;
import com.derletztekick.geodesy.geotra.io.nt.NTHeader;
import com.derletztekick.geodesy.geotra.io.nt.NTUnit;
import com.derletztekick.tools.geodesy.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class NTGrid {
    private final NTHeader ntHeader;
    private String subName = null;
    private String parentName = "NONE";
    private NTGrid parent = null;
    private Date created = null;
    private Date updated = null;
    private int gsCount = -1;
    private double sLat = Double.NaN;
    private double nLat = Double.NaN;
    private double eLong = Double.NaN;
    private double wLong = Double.NaN;
    private double latInc = -1.0;
    private double longInc = -1.0;
    private double pseudoValueForExtrapolationLimit = Double.MAX_VALUE;
    private List<NTGrid> subGrids = new ArrayList<NTGrid>();

    NTGrid(NTHeader ntHeader) {
        this.ntHeader = ntHeader;
    }

    public boolean isComplete() {
        return this.subName != null && !Double.isNaN(this.sLat) && !Double.isNaN(this.nLat) && !Double.isNaN(this.eLong) && !Double.isNaN(this.wLong) && this.latInc > 0.0 && this.longInc > 0.0 && this.gsCount > 0;
    }

    public boolean contains(PointLatLonH point) {
        double lat = point.getLatitude();
        double lon = -point.getLongitude();
        return this.sLat <= lat && lat <= this.nLat && this.eLong <= lon && lon <= this.wLong;
    }

    void setSubFileName(String subName) {
        this.subName = subName;
    }

    public String getSubFileName() {
        return this.subName;
    }

    void setParentName(String parentName) {
        if (this.parent == null) {
            this.parentName = parentName;
        }
    }

    String getParentName() {
        return this.parent != null ? this.parent.getSubFileName() : this.parentName;
    }

    void setParent(NTGrid parent) {
        this.parent = parent;
        this.parentName = this.parent.getSubFileName();
        this.parent.addSubGrid(this);
    }

    public NTGrid getParent(NTGrid parent) {
        return this.parent;
    }

    void setCreationDate(Date created) {
        this.created = created;
        if (this.updated == null) {
            this.updated = this.created;
        }
    }

    public Date getCreationDate() {
        return this.created;
    }

    void setLastRevisionDate(Date updated) {
        this.updated = updated;
    }

    public Date getLastRevisionDate() {
        return this.updated;
    }

    void setSouthLatitude(double sLat) {
        this.sLat = sLat;
    }

    public double getSouthLatitude() {
        return this.sLat;
    }

    void setNorthLatitude(double nLat) {
        this.nLat = nLat;
    }

    public double getNorthLatitude() {
        return this.nLat;
    }

    void setEastLongitude(double eLong) {
        this.eLong = eLong;
    }

    public double getEastLongitude() {
        return this.eLong;
    }

    void setWestLongitude(double wLong) {
        this.wLong = wLong;
    }

    public double getWestLongitude() {
        return this.wLong;
    }

    void setLatitudeIncrement(double latInc) {
        this.latInc = latInc;
    }

    public double getLatitudeIncrement() {
        return this.latInc;
    }

    void setLongitudeIncrement(double longInc) {
        this.longInc = longInc;
    }

    public double getLongitudeIncrement() {
        return this.longInc;
    }

    void setNumberOfGridShiftValues(int gsCount) {
        this.gsCount = gsCount;
    }

    public int getNumberOfGridShiftValues() {
        return this.gsCount;
    }

    public final NTHeader getNTHeader() {
        return this.ntHeader;
    }

    public void setValueForExtrapolationLimit(double value) {
        NTUnit unit = this.ntHeader.getUnit();
        this.pseudoValueForExtrapolationLimit = value <= 0.0 ? Double.MAX_VALUE : unit.toRadians(value - Math.sqrt(Constant.EPS));
    }

    public PointLatLonH inverseTransform(PointLatLonH point, PointLatLonH tmpPoint) {
        double[] shiftValues = this.getShiftParameters(tmpPoint);
        if (shiftValues == null) {
            return null;
        }
        return new PointLatLonH(point.getLatitude() - shiftValues[0], point.getLongitude() + shiftValues[1], point.getHeight());
    }

    public PointLatLonH transform(PointLatLonH point) {
        double[] shiftValues = this.getShiftParameters(point);
        if (shiftValues == null) {
            return null;
        }
        return new PointLatLonH(point.getLatitude() + shiftValues[0], point.getLongitude() - shiftValues[1], point.getHeight());
    }

    public double[] getShiftParameters(PointLatLonH point) {
        double lat = point.getLatitude();
        double lon = -point.getLongitude();
        double fcol = (lon - this.eLong) / this.longInc;
        double frow = (lat - this.sLat) / this.latInc;
        int col = (int)fcol;
        int row = (int)frow;
        int ppr = (int)((this.wLong - this.eLong) / this.longInc + 0.5) + 1;
        int ppc = (int)((this.nLat - this.sLat) / this.latInc + 0.5) + 1;
        int se = row * ppr + col;
        int sw = se + 1;
        int ne = se + ppr;
        int nw = ne + 1;
        if (col >= ppr - 1) {
            nw = sw = se;
        }
        if (row >= ppc - 1) {
            ne = se;
            nw = sw;
        }
        double dx = fcol - (double)col;
        double dy = frow - (double)row;
        return this.interp(ne, nw, se, sw, dx, dy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[] interp(int ne, int nw, int se, int sw, double dx, double dy) {
        if (ne >= this.gsCount || nw >= this.gsCount || sw >= this.gsCount || sw >= this.gsCount) {
            System.err.println(this.getClass().getSimpleName() + " Fehler, Indizes der Eckpunkte ueberstreigen Datengroesse: ne = " + ne + ", nw = " + nw + ", se = " + se + ", sw = " + sw + " und size = " + this.gsCount);
            return null;
        }
        try {
            NTGridValue[] ntGridValues = this.get(se, ne, sw, nw);
            if (ntGridValues == null) {
                return null;
            }
            double latSSE = ntGridValues[0].getLatitude();
            double lonSSE = ntGridValues[0].getLongitude();
            double latSNE = ntGridValues[1].getLatitude();
            double lonSNE = ntGridValues[1].getLongitude();
            double latSSW = ntGridValues[2].getLatitude();
            double lonSSW = ntGridValues[2].getLongitude();
            double latSNW = ntGridValues[3].getLatitude();
            double lonSNW = ntGridValues[3].getLongitude();
            NTGridValue[] nTGridValueArray = ntGridValues;
            int n = ntGridValues.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    double latS = (1.0 - dx) * (1.0 - dy) * latSSE + dx * (1.0 - dy) * latSSW + (1.0 - dx) * dy * latSNE + dx * dy * latSNW;
                    double lonS = (1.0 - dx) * (1.0 - dy) * lonSSE + dx * (1.0 - dy) * lonSSW + (1.0 - dx) * dy * lonSNE + dx * dy * lonSNW;
                    return new double[]{latS, lonS};
                }
                NTGridValue ntGridValue = nTGridValueArray[n2];
                double lat = ntGridValue.getLatitude();
                double lon = ntGridValue.getLongitude();
                if (Math.abs(lat) >= this.pseudoValueForExtrapolationLimit || Math.abs(lon) >= this.pseudoValueForExtrapolationLimit) {
                    return null;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean addSubGrid(NTGrid childGrid) {
        if (childGrid.getParentName().equals(this.subName)) {
            return this.subGrids.add(childGrid);
        }
        return false;
    }

    public NTGrid[] getSubGrids() {
        return this.subGrids.toArray(new NTGrid[this.subGrids.size()]);
    }

    public GeodeticDatum getTargetDatum() {
        String datumName = this.ntHeader.getSystemTo();
        GeodeticDatumType datumType = GeodeticDatumType.valueByName(datumName);
        if (datumType == GeodeticDatumType.UNDEFINED) {
            datumType = GeodeticDatumType.UNKNOWN_TARGET_GEODETIC_DATUM;
            datumType.setLabel(datumName);
        }
        return this.getGeodeticDatum(datumType, this.ntHeader.getMajorTo(), this.ntHeader.getMinorTo());
    }

    public GeodeticDatum getSourceDatum() {
        String datumName = this.ntHeader.getSystemFrom();
        GeodeticDatumType datumType = GeodeticDatumType.valueByName(datumName);
        if (datumType == GeodeticDatumType.UNDEFINED) {
            datumType = GeodeticDatumType.UNKNOWN_SOURCE_GEODETIC_DATUM;
            datumType.setLabel(datumName);
        }
        return this.getGeodeticDatum(datumType, this.ntHeader.getMajorFrom(), this.ntHeader.getMinorFrom());
    }

    private GeodeticDatum getGeodeticDatum(GeodeticDatumType datum, double a, double b) {
        if (datum == GeodeticDatumType.UNDEFINED || datum == GeodeticDatumType.UNKNOWN_SOURCE_GEODETIC_DATUM || datum == GeodeticDatumType.UNKNOWN_TARGET_GEODETIC_DATUM) {
            Ellipsoid ellipsoid = new Ellipsoid(datum.getLabel(), a, b);
            MapProjection projection = new MapProjection(ellipsoid, ProjectionType.UTM_N);
            return new GeodeticDatum(datum, projection);
        }
        return new GeodeticDatum(datum);
    }

    public abstract NTGridValue[] get(int var1, int var2, int var3, int var4);

    public String toString() {
        return this.subName;
    }
}

