/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTFileChannelGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTHeader;
import com.derletztekick.geodesy.geotra.io.nt.NTReader;
import com.derletztekick.geodesy.geotra.io.nt.NTUnit;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class NTGSBReader
extends NTReader {
    @Override
    public NTGrid[] read(Path path) throws IOException {
        if (path != null && Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path)) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(path, StandardOpenOption.READ);){
                fileChannel.lock(0L, Long.MAX_VALUE, true);
                NTHeader ntHeader = this.readOverviewHeader(fileChannel);
                NTGrid[] nTGridArray = ntHeader.isComplete() ? this.readGrids(path, fileChannel, ntHeader) : null;
                return nTGridArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private NTHeader readOverviewHeader(FileChannel fileChannel) throws IOException {
        NTHeader ntHeader = new NTHeader();
        CharBuffer charBuffer = null;
        int maxLoops = 100;
        int pointerPosition = 0;
        do {
            String key;
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, pointerPosition * 16, 16L);
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            charBuffer = StandardCharsets.UTF_8.decode(mappedByteBuffer);
            charBuffer.position(0);
            charBuffer.limit(8);
            block13 : switch (key = charBuffer.toString().trim()) {
                case "NUM_OREC": {
                    ntHeader.setNumberOfOverviewRecordFields(mappedByteBuffer.getInt(8));
                    break;
                }
                case "NUM_SREC": {
                    ntHeader.setNumberOfGridHeaderRecordFields(mappedByteBuffer.getInt(8));
                    break;
                }
                case "NUM_FILE": {
                    ntHeader.setNumberOfSubFiles(mappedByteBuffer.getInt(8));
                    break;
                }
                case "MAJOR_F": {
                    ntHeader.setMajorFrom(mappedByteBuffer.getDouble(8));
                    break;
                }
                case "MINOR_F": {
                    ntHeader.setMinorFrom(mappedByteBuffer.getDouble(8));
                    break;
                }
                case "MAJOR_T": {
                    ntHeader.setMajorTo(mappedByteBuffer.getDouble(8));
                    break;
                }
                case "MINOR_T": {
                    ntHeader.setMinorTo(mappedByteBuffer.getDouble(8));
                    break;
                }
                case "SYSTEM_F": 
                case "SYSTEM_T": 
                case "GS_TYPE": 
                case "VERSION": {
                    charBuffer.position(8);
                    charBuffer.limit(16);
                    String value = charBuffer.toString().trim();
                    switch (key) {
                        case "VERSION": {
                            ntHeader.setVersion(value);
                            break block13;
                        }
                        case "SYSTEM_F": {
                            ntHeader.setSystemFrom(value);
                            break block13;
                        }
                        case "SYSTEM_T": {
                            ntHeader.setSystemTo(value);
                            break block13;
                        }
                        case "GS_TYPE": {
                            ntHeader.setUnit(NTUnit.valueOf(value));
                        }
                    }
                }
            }
            if (ntHeader.getNumberOfOverviewRecordFields() > 0) {
                maxLoops = ntHeader.getNumberOfOverviewRecordFields();
            }
            charBuffer.clear();
        } while (pointerPosition++ < maxLoops && !ntHeader.isComplete());
        return ntHeader;
    }

    private NTGrid[] readGrids(Path path, FileChannel fileChannel, NTHeader ntHeader) throws IOException {
        int numFiles = ntHeader.getNumberOfSubFiles();
        NTGrid[] ntGrids = new NTGrid[numFiles];
        CharBuffer charBuffer = null;
        NTUnit unit = ntHeader.getUnit();
        long pointerPosition = ntHeader.getNumberOfOverviewRecordFields();
        int numGridHeaderRecords = ntHeader.getNumberOfGridHeaderRecordFields();
        int idxFile = 0;
        while (idxFile < numFiles) {
            NTFileChannelGrid ntGrid = new NTFileChannelGrid(ntHeader, path, pointerPosition);
            int idxGridHeaderRecord = 0;
            while (idxGridHeaderRecord < numGridHeaderRecords) {
                String key;
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, ((long)idxGridHeaderRecord + pointerPosition) * 16L, 16L);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                charBuffer = StandardCharsets.UTF_8.decode(mappedByteBuffer);
                charBuffer.position(0);
                charBuffer.limit(8);
                switch (key = charBuffer.toString().trim()) {
                    case "PARENT": 
                    case "SUB_NAME": 
                    case "UPDATED": 
                    case "CREATED": {
                        charBuffer.position(8);
                        charBuffer.limit(16);
                        String value = charBuffer.toString().trim();
                        switch (key) {
                            case "SUB_NAME": {
                                ntGrid.setSubFileName(value);
                                break;
                            }
                            case "PARENT": {
                                ntGrid.setParentName(value);
                                break;
                            }
                            case "CREATED": {
                                ntGrid.setCreationDate(NTGSBReader.toDate(value));
                                break;
                            }
                            case "UPDATED": {
                                ntGrid.setLastRevisionDate(NTGSBReader.toDate(value));
                            }
                        }
                        break;
                    }
                    case "S_LAT": {
                        ntGrid.setSouthLatitude(unit.toRadians(mappedByteBuffer.getDouble(8)));
                        break;
                    }
                    case "N_LAT": {
                        ntGrid.setNorthLatitude(unit.toRadians(mappedByteBuffer.getDouble(8)));
                        break;
                    }
                    case "E_LONG": {
                        ntGrid.setEastLongitude(unit.toRadians(mappedByteBuffer.getDouble(8)));
                        break;
                    }
                    case "W_LONG": {
                        ntGrid.setWestLongitude(unit.toRadians(mappedByteBuffer.getDouble(8)));
                        break;
                    }
                    case "LAT_INC": {
                        ntGrid.setLatitudeIncrement(unit.toRadians(mappedByteBuffer.getDouble(8)));
                        break;
                    }
                    case "LONG_INC": {
                        ntGrid.setLongitudeIncrement(unit.toRadians(mappedByteBuffer.getDouble(8)));
                        break;
                    }
                    case "GS_COUNT": {
                        ntGrid.setNumberOfGridShiftValues(mappedByteBuffer.getInt(8));
                    }
                }
                ++idxGridHeaderRecord;
            }
            if (ntGrid.isComplete()) {
                int numOfGridShiftValues = ntGrid.getNumberOfGridShiftValues();
                pointerPosition += (long)numGridHeaderRecords;
                pointerPosition += (long)numOfGridShiftValues;
            } else {
                return null;
            }
            ntGrids[idxFile] = ntGrid;
            ++idxFile;
        }
        return NTGSBReader.allocateSubGrids(ntGrids);
    }
}

