/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTBufferedReaderGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTGridValue;
import com.derletztekick.geodesy.geotra.io.nt.NTHeader;
import com.derletztekick.geodesy.geotra.io.nt.NTMemoryGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTReader;
import com.derletztekick.geodesy.geotra.io.nt.NTUnit;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class NTGSAReader
extends NTReader {
    /*
     * Loose catch block
     */
    @Override
    public NTGrid[] read(Path path) throws IOException, NumberFormatException {
        if (path != null && Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path)) {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                NTGrid[] nTGridArray;
                BufferedReader reader;
                FileChannel fileChannel;
                block17: {
                    block16: {
                        fileChannel = (FileChannel)Files.newByteChannel(path, StandardOpenOption.READ);
                        reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                        fileChannel.lock(0L, Long.MAX_VALUE, true);
                        NTHeader ntHeader = this.readOverviewHeader(reader);
                        nTGridArray = ntHeader.isComplete() ? this.readGrids(path, reader, ntHeader) : null;
                        if (reader == null) break block16;
                        reader.close();
                    }
                    if (fileChannel == null) break block17;
                    fileChannel.close();
                }
                return nTGridArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fileChannel != null) {
                                fileChannel.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return null;
    }

    private NTHeader readOverviewHeader(BufferedReader reader) throws IOException, NumberFormatException {
        String line;
        NTHeader ntHeader = new NTHeader();
        int maxLoops = 100;
        int pointerPosition = 0;
        while ((line = reader.readLine()) != null) {
            block52: {
                if (line.trim().length() <= 8) break block52;
                String key = line.substring(0, 8).trim();
                String value = line.substring(8).trim();
                block13 : switch (key) {
                    case "NUM_OREC": {
                        ntHeader.setNumberOfOverviewRecordFields(Integer.parseInt(value));
                        break;
                    }
                    case "NUM_SREC": {
                        ntHeader.setNumberOfGridHeaderRecordFields(Integer.parseInt(value));
                        break;
                    }
                    case "NUM_FILE": {
                        ntHeader.setNumberOfSubFiles(Integer.parseInt(value));
                        break;
                    }
                    case "MAJOR_F": {
                        ntHeader.setMajorFrom(Double.parseDouble(value));
                        break;
                    }
                    case "MINOR_F": {
                        ntHeader.setMinorFrom(Double.parseDouble(value));
                        break;
                    }
                    case "MAJOR_T": {
                        ntHeader.setMajorTo(Double.parseDouble(value));
                        break;
                    }
                    case "MINOR_T": {
                        ntHeader.setMinorTo(Double.parseDouble(value));
                        break;
                    }
                    case "SYSTEM_F": 
                    case "SYSTEM_T": 
                    case "GS_TYPE": 
                    case "VERSION": {
                        switch (key) {
                            case "VERSION": {
                                ntHeader.setVersion(value);
                                break block13;
                            }
                            case "SYSTEM_F": {
                                ntHeader.setSystemFrom(value);
                                break block13;
                            }
                            case "SYSTEM_T": {
                                ntHeader.setSystemTo(value);
                                break block13;
                            }
                            case "GS_TYPE": {
                                ntHeader.setUnit(NTUnit.valueOf(value));
                            }
                        }
                    }
                }
                if (ntHeader.getNumberOfOverviewRecordFields() > 0) {
                    maxLoops = ntHeader.getNumberOfOverviewRecordFields();
                }
            }
            if (pointerPosition++ < maxLoops && !ntHeader.isComplete()) continue;
        }
        return ntHeader;
    }

    private NTGrid[] readGrids(Path path, BufferedReader reader, NTHeader ntHeader) throws IOException, NumberFormatException, ArrayIndexOutOfBoundsException {
        if (Files.size(path) < 0x6400000L) {
            return this.readMemoryGrids(reader, ntHeader);
        }
        return this.readBufferedReaderGrids(path, reader, ntHeader);
    }

    private NTGrid[] readBufferedReaderGrids(Path path, BufferedReader reader, NTHeader ntHeader) throws IOException, NumberFormatException, ArrayIndexOutOfBoundsException {
        int numFiles = ntHeader.getNumberOfSubFiles();
        NTGrid[] ntGrids = new NTGrid[numFiles];
        NTUnit unit = ntHeader.getUnit();
        int pointerPosition = ntHeader.getNumberOfOverviewRecordFields();
        int numGridHeaderRecords = ntHeader.getNumberOfGridHeaderRecordFields();
        int idxFile = 0;
        while (idxFile < numFiles) {
            NTBufferedReaderGrid ntGrid = new NTBufferedReaderGrid(ntHeader, path, pointerPosition);
            int idxGridHeaderRecord = 0;
            while (idxGridHeaderRecord < numGridHeaderRecords) {
                block57: {
                    String line = reader.readLine();
                    if (line == null) break;
                    if (line.trim().length() <= 8) break block57;
                    String key = line.substring(0, 8).trim();
                    String value = line.substring(8).trim();
                    switch (key) {
                        case "PARENT": 
                        case "SUB_NAME": 
                        case "UPDATED": 
                        case "CREATED": {
                            switch (key) {
                                case "SUB_NAME": {
                                    ntGrid.setSubFileName(value);
                                    break;
                                }
                                case "PARENT": {
                                    ntGrid.setParentName(value);
                                    break;
                                }
                                case "CREATED": {
                                    ntGrid.setCreationDate(NTGSAReader.toDate(value));
                                    break;
                                }
                                case "UPDATED": {
                                    ntGrid.setLastRevisionDate(NTGSAReader.toDate(value));
                                }
                            }
                            break;
                        }
                        case "S_LAT": {
                            ntGrid.setSouthLatitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "N_LAT": {
                            ntGrid.setNorthLatitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "E_LONG": {
                            ntGrid.setEastLongitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "W_LONG": {
                            ntGrid.setWestLongitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "LAT_INC": {
                            ntGrid.setLatitudeIncrement(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "LONG_INC": {
                            ntGrid.setLongitudeIncrement(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "GS_COUNT": {
                            ntGrid.setNumberOfGridShiftValues(Integer.parseInt(value));
                        }
                    }
                }
                ++idxGridHeaderRecord;
            }
            if (ntGrid.isComplete()) {
                int numOfGridShiftValues = ntGrid.getNumberOfGridShiftValues();
                if (idxFile < numFiles - 1) {
                    int idxGridShiftValue = 0;
                    while (idxGridShiftValue < numOfGridShiftValues) {
                        String line = reader.readLine();
                        if (line == null) {
                            return null;
                        }
                        ++idxGridShiftValue;
                    }
                }
                pointerPosition += numGridHeaderRecords;
                pointerPosition += numOfGridShiftValues;
            } else {
                return null;
            }
            ntGrids[idxFile] = ntGrid;
            ++idxFile;
        }
        return NTGSAReader.allocateSubGrids(ntGrids);
    }

    private NTGrid[] readMemoryGrids(BufferedReader reader, NTHeader ntHeader) throws IOException, NumberFormatException, ArrayIndexOutOfBoundsException {
        int numFiles = ntHeader.getNumberOfSubFiles();
        NTGrid[] ntGrids = new NTGrid[numFiles];
        NTUnit unit = ntHeader.getUnit();
        int numGridHeaderRecords = ntHeader.getNumberOfGridHeaderRecordFields();
        int idxFile = 0;
        while (idxFile < numFiles) {
            String line;
            NTMemoryGrid ntGrid = new NTMemoryGrid(ntHeader);
            int idxGridHeaderRecord = 0;
            while (idxGridHeaderRecord < numGridHeaderRecords) {
                block57: {
                    line = reader.readLine();
                    if (line == null) break;
                    if (line.trim().length() <= 8) break block57;
                    String key = line.substring(0, 8).trim();
                    String value = line.substring(8).trim();
                    switch (key) {
                        case "PARENT": 
                        case "SUB_NAME": 
                        case "UPDATED": 
                        case "CREATED": {
                            switch (key) {
                                case "SUB_NAME": {
                                    ntGrid.setSubFileName(value);
                                    break;
                                }
                                case "PARENT": {
                                    ntGrid.setParentName(value);
                                    break;
                                }
                                case "CREATED": {
                                    ntGrid.setCreationDate(NTGSAReader.toDate(value));
                                    break;
                                }
                                case "UPDATED": {
                                    ntGrid.setLastRevisionDate(NTGSAReader.toDate(value));
                                }
                            }
                            break;
                        }
                        case "S_LAT": {
                            ntGrid.setSouthLatitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "N_LAT": {
                            ntGrid.setNorthLatitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "E_LONG": {
                            ntGrid.setEastLongitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "W_LONG": {
                            ntGrid.setWestLongitude(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "LAT_INC": {
                            ntGrid.setLatitudeIncrement(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "LONG_INC": {
                            ntGrid.setLongitudeIncrement(unit.toRadians(Double.parseDouble(value)));
                            break;
                        }
                        case "GS_COUNT": {
                            ntGrid.setNumberOfGridShiftValues(Integer.parseInt(value));
                        }
                    }
                }
                ++idxGridHeaderRecord;
            }
            if (!ntGrid.isComplete()) {
                return null;
            }
            int idxValue = 0;
            while (idxValue < ntGrid.getNumberOfGridShiftValues()) {
                line = reader.readLine();
                if (line == null) {
                    return null;
                }
                if (line.length() >= 20) {
                    double uncertaintyLatitude = 0.0;
                    double uncertaintyLongitude = 0.0;
                    double latitude = unit.toRadians(Double.parseDouble(line.substring(0, 10).trim()));
                    double longitude = unit.toRadians(Double.parseDouble(line.substring(10, 20).trim()));
                    if (line.length() >= 40) {
                        uncertaintyLatitude = Double.parseDouble(line.substring(20, 30).trim());
                        uncertaintyLongitude = Double.parseDouble(line.substring(30, 40).trim());
                    }
                    ntGrid.add(idxValue, new NTGridValue(latitude, longitude, uncertaintyLatitude, uncertaintyLongitude));
                }
                ++idxValue;
            }
            ntGrids[idxFile] = ntGrid;
            ++idxFile;
        }
        return NTGSAReader.allocateSubGrids(ntGrids);
    }
}

