/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTGridValue;
import com.derletztekick.geodesy.geotra.io.nt.NTHeader;
import com.derletztekick.geodesy.geotra.io.nt.NTUnit;
import com.derletztekick.geodesy.util.MaxSizeHashMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class NTFileChannelGrid
extends NTGrid {
    private final Path path;
    private final NTUnit unit;
    private final long pointer;
    private final int numGridHeaderRecords;
    private MaxSizeHashMap<Integer, NTGridValue> ringBuffer = new MaxSizeHashMap(10000);

    NTFileChannelGrid(NTHeader ntHeader, Path path, long pointer) {
        super(ntHeader);
        this.unit = ntHeader.getUnit();
        this.path = path;
        this.pointer = pointer;
        this.numGridHeaderRecords = ntHeader.getNumberOfGridHeaderRecordFields();
    }

    @Override
    public NTGridValue[] get(int indexSE, int indexNE, int indexSW, int indexNW) {
        NTGridValue ntGridValueNW;
        NTGridValue ntGridValueSW;
        NTGridValue ntGridValueNE;
        NTGridValue ntGridValueSE;
        block27: {
            int[] indices = new int[]{indexSE, indexNE, indexSW, indexNW};
            Arrays.sort(indices);
            if (indices[indices.length - 1] >= this.getNumberOfGridShiftValues()) {
                return null;
            }
            ntGridValueSE = null;
            ntGridValueNE = null;
            ntGridValueSW = null;
            ntGridValueNW = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                try {
                    int[] nArray = indices;
                    int n = indices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        NTGridValue ntGridValue = null;
                        if (this.ringBuffer.containsKey(index)) {
                            ntGridValue = (NTGridValue)this.ringBuffer.get(index);
                        } else {
                            if (fileChannel == null) {
                                fileChannel = (FileChannel)Files.newByteChannel(this.path, StandardOpenOption.READ);
                            }
                            ((FileChannel)fileChannel).lock((this.pointer + (long)this.numGridHeaderRecords + (long)index) * 16L, 16L, true);
                            MappedByteBuffer mappedByteBuffer = ((FileChannel)fileChannel).map(FileChannel.MapMode.READ_ONLY, (this.pointer + (long)this.numGridHeaderRecords + (long)index) * 16L, 16L);
                            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            ntGridValue = new NTGridValue(this.unit.toRadians(new BigDecimal(mappedByteBuffer.getFloat(0), MathContext.DECIMAL32).doubleValue()), this.unit.toRadians(new BigDecimal(mappedByteBuffer.getFloat(4), MathContext.DECIMAL32).doubleValue()), new BigDecimal(mappedByteBuffer.getFloat(8), MathContext.DECIMAL32).doubleValue(), new BigDecimal(mappedByteBuffer.getFloat(12), MathContext.DECIMAL32).doubleValue());
                            this.ringBuffer.put(index, ntGridValue);
                        }
                        if (index == indexSE) {
                            ntGridValueSE = ntGridValue;
                        } else if (index == indexNE) {
                            ntGridValueNE = ntGridValue;
                        } else if (index == indexSW) {
                            ntGridValueSW = ntGridValue;
                        } else if (index == indexNW) {
                            ntGridValueNW = ntGridValue;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (fileChannel != null) {
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (ntGridValueSE != null && ntGridValueNE != null && ntGridValueSW != null && ntGridValueNW != null) {
            return new NTGridValue[]{ntGridValueSE, ntGridValueNE, ntGridValueSW, ntGridValueNW};
        }
        return null;
    }
}

