/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io.nt;

import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTGridValue;
import com.derletztekick.geodesy.geotra.io.nt.NTHeader;
import com.derletztekick.geodesy.geotra.io.nt.NTUnit;
import com.derletztekick.geodesy.util.MaxSizeHashMap;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class NTBufferedReaderGrid
extends NTGrid {
    private final Path path;
    private final NTUnit unit;
    private final int pointer;
    private final int numGridHeaderRecords;
    private MaxSizeHashMap<Integer, NTGridValue> ringBuffer = new MaxSizeHashMap(10000);

    NTBufferedReaderGrid(NTHeader ntHeader, Path path, int pointer) {
        super(ntHeader);
        this.unit = ntHeader.getUnit();
        this.path = path;
        this.pointer = pointer;
        this.numGridHeaderRecords = ntHeader.getNumberOfGridHeaderRecordFields();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NTGridValue[] get(int indexSE, int indexNE, int indexSW, int indexNW) {
        indices = new int[]{indexSE, indexNE, indexSW, indexNW};
        Arrays.sort(indices);
        if (indices[indices.length - 1] >= this.getNumberOfGridShiftValues()) {
            return null;
        }
        ntGridValueSE = null;
        ntGridValueNE = null;
        ntGridValueSW = null;
        ntGridValueNW = null;
        try {
            var10_10 = null;
            var11_13 = null;
            try {
                fileChannel = (FileChannel)Files.newByteChannel(this.path, new OpenOption[]{StandardOpenOption.READ});
                try {
                    reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);
                    try {
                        fileChannel.lock(0L, 0x7FFFFFFFFFFFFFFFL, true);
                        lineCounter = 0;
                        var18_19 = indices;
                        var17_20 = indices.length;
                        var16_21 = 0;
                        ** GOTO lbl85
                    }
                    catch (Throwable var10_11) {
                        if (reader == null) throw var10_11;
                        reader.close();
                        throw var10_11;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        reader.close();
                        while (true) {
                            if (fileChannel == null) return null;
                            ** GOTO lbl58
                            break;
                        }
                        break;
                    }
                }
                catch (Throwable var11_14) {
                    block29: {
                        if (var10_10 == null) {
                            var10_10 = var11_14;
                        } else if (var10_10 != var11_14) {
                            var10_10.addSuppressed(var11_14);
                        }
                        if (fileChannel == null) throw var10_10;
                        fileChannel.close();
                        throw var10_10;
                        while (true) {
                            block31: {
                                index = var18_19[var16_21];
                                ntGridValue = null;
                                if (!this.ringBuffer.containsKey(index)) break block31;
                                ntGridValue = (NTGridValue)this.ringBuffer.get(index);
                                ** GOTO lbl73
                            }
                            lineNumber = this.pointer + this.numGridHeaderRecords + index;
                            line = null;
lbl51:
                            // 2 sources

                            while (lineCounter <= lineNumber) {
                                line = reader.readLine();
                                if (line != null) ** GOTO lbl-1000
                                if (reader == null) ** continue;
                                ** continue;
lbl56:
                                // 1 sources

                                ** GOTO lbl28
                            }
                            ** GOTO lbl62
                            break;
                        }
lbl58:
                        // 1 sources

                        fileChannel.close();
                        return null;
lbl-1000:
                        // 1 sources

                        {
                            ++lineCounter;
                            ** GOTO lbl51
lbl62:
                            // 1 sources

                            if (lineCounter - 1 == lineNumber && line != null && line.length() >= 20) {
                                uncertaintyLatitude = 0.0;
                                uncertaintyLongitude = 0.0;
                                latitude = this.unit.toRadians(Double.parseDouble(line.substring(0, 10).trim()));
                                longitude = this.unit.toRadians(Double.parseDouble(line.substring(10, 20).trim()));
                                if (line.length() >= 40) {
                                    uncertaintyLatitude = Double.parseDouble(line.substring(20, 30).trim());
                                    uncertaintyLongitude = Double.parseDouble(line.substring(30, 40).trim());
                                }
                                ntGridValue = new NTGridValue(latitude, longitude, uncertaintyLatitude, uncertaintyLongitude);
                                this.ringBuffer.put(index, ntGridValue);
                            }
lbl73:
                            // 4 sources

                            if (index == indexSE) {
                                ntGridValueSE = ntGridValue;
                            } else if (index == indexNE) {
                                ntGridValueNE = ntGridValue;
                            } else if (index == indexSW) {
                                ntGridValueSW = ntGridValue;
                            } else if (index == indexNW) {
                                ntGridValueNW = ntGridValue;
                            }
                            ++var16_21;
lbl85:
                            // 2 sources

                            if (var16_21 < var17_20) ** continue;
                            if (reader == null) break block29;
                        }
                        reader.close();
                    }
                    ** if (fileChannel == null) goto lbl-1000
                }
lbl-1000:
                // 1 sources

                {
                    fileChannel.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var11_15) {
                if (var10_10 == null) {
                    var10_10 = var11_15;
                    throw var10_10;
                }
                if (var10_10 == var11_15) throw var10_10;
                var10_10.addSuppressed(var11_15);
                throw var10_10;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ntGridValueSE == null) return null;
        if (ntGridValueNE == null) return null;
        if (ntGridValueSW == null) return null;
        if (ntGridValueNW == null) return null;
        return new NTGridValue[]{ntGridValueSE, ntGridValueNE, ntGridValueSW, ntGridValueNW};
    }
}

