/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io;

import com.derletztekick.geodesy.earth.point.PointXYZ;
import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.geodesy.earth.transformation.HomologuePointSet;
import com.derletztekick.geodesy.earth.transformation.TransformationType;
import com.derletztekick.geodesy.earth.transformation.Transformator;
import com.derletztekick.geodesy.geotra.io.CoordinateType;
import com.derletztekick.tools.io.LockFileReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public class DualPointFileReaderAndWriter
extends LockFileReader {
    private Set<String> nonTransformedPointIds = new LinkedHashSet<String>();
    private final Transformator transformator;
    private final File destFile;
    private boolean hasHigherResolutionGrids = false;
    private PrintWriter printWriter = null;
    private final CoordinateType submissionType;
    private final String format2 = "%10s \t%+14.10f \t%+14.10f  \t%+16.5f \t%+16.5f  \t%+14.10f \t%+14.10f  \t%+16.5f \t%+16.5f%n";
    private final String format3 = "%10s \t%+14.10f \t%+14.10f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f  \t%+14.10f \t%+14.10f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f%n";

    public DualPointFileReaderAndWriter(Transformator transformator, CoordinateType submissionType, String srcFileName, String destFileName) {
        this(transformator, submissionType, new File(srcFileName), new File(destFileName));
    }

    public DualPointFileReaderAndWriter(Transformator transformator, CoordinateType submissionType, File srcFile, File destFile) {
        super(srcFile);
        this.ignoreLinesWhichStartWith("#");
        this.transformator = transformator;
        this.destFile = destFile;
        this.submissionType = submissionType;
    }

    @Override
    public void parse(String line) {
        if (this.printWriter == null) {
            return;
        }
        line = line.trim();
        String[] columns = line.split("[\\s,;]+");
        if (this.transformator.getTransformationType() != TransformationType.HELMERT_3D && columns.length < 3 || this.transformator.getTransformationType() == TransformationType.HELMERT_3D && columns.length < 4) {
            return;
        }
        String id = columns[0];
        double valueA = 0.0;
        double valueB = 0.0;
        double valueC = 0.0;
        try {
            valueA = Double.parseDouble(columns[1]);
            valueB = Double.parseDouble(columns[2]);
            if (this.transformator.getTransformationType() == TransformationType.HELMERT_3D) {
                valueC = Double.parseDouble(columns[3]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        HomologuePointSet pointSet = null;
        if (this.submissionType == CoordinateType.LatLonHeight) {
            pointSet = this.transformator.transformLatitudeLongitudeHeight(new PointLatLonH(valueB * (Math.PI / 180), valueA * (Math.PI / 180), valueC));
        } else if (this.submissionType == CoordinateType.XYZ) {
            pointSet = this.transformator.transformXYZ(new PointXYZ(valueA, valueB, valueC));
        } else if (this.submissionType == CoordinateType.EastNorthHeight) {
            pointSet = this.transformator.transformEastNorthHeight(new PointENH(valueA, valueB, valueC));
        }
        if (pointSet == null) {
            this.nonTransformedPointIds.add(id);
            return;
        }
        if (this.transformator.getTransformationType() != TransformationType.HELMERT_3D) {
            this.hasHigherResolutionGrids = this.hasHigherResolutionGrids || this.transformator.hasHigherResolutionGrid();
            this.printWriter.printf(Locale.ENGLISH, "%10s \t%+14.10f \t%+14.10f  \t%+16.5f \t%+16.5f  \t%+14.10f \t%+14.10f  \t%+16.5f \t%+16.5f%n", id, pointSet.getSourcePointLatitudeLongitudeHeight().getLongitude() * 57.29577951308232, pointSet.getSourcePointLatitudeLongitudeHeight().getLatitude() * 57.29577951308232, pointSet.getSourcePointEastNorthHeight().getY(), pointSet.getSourcePointEastNorthHeight().getX(), pointSet.getTargetPointLatitudeLongitudeHeight().getLongitude() * 57.29577951308232, pointSet.getTargetPointLatitudeLongitudeHeight().getLatitude() * 57.29577951308232, pointSet.getTargetPointEastNorthHeight().getY(), pointSet.getTargetPointEastNorthHeight().getX());
        } else if (this.transformator.getTransformationType() == TransformationType.HELMERT_3D) {
            this.printWriter.printf(Locale.ENGLISH, "%10s \t%+14.10f \t%+14.10f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f  \t%+14.10f \t%+14.10f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f  \t%+16.5f \t%+16.5f \t%+16.5f%n", id, pointSet.getSourcePointLatitudeLongitudeHeight().getLongitude() * 57.29577951308232, pointSet.getSourcePointLatitudeLongitudeHeight().getLatitude() * 57.29577951308232, pointSet.getSourcePointLatitudeLongitudeHeight().getHeight(), pointSet.getSourcePointEastNorthHeight().getY(), pointSet.getSourcePointEastNorthHeight().getX(), pointSet.getSourcePointEastNorthHeight().getHeight(), pointSet.getSourcePointXYZ().getX(), pointSet.getSourcePointXYZ().getY(), pointSet.getSourcePointXYZ().getZ(), pointSet.getTargetPointLatitudeLongitudeHeight().getLongitude() * 57.29577951308232, pointSet.getTargetPointLatitudeLongitudeHeight().getLatitude() * 57.29577951308232, pointSet.getTargetPointLatitudeLongitudeHeight().getHeight(), pointSet.getTargetPointEastNorthHeight().getY(), pointSet.getTargetPointEastNorthHeight().getX(), pointSet.getTargetPointEastNorthHeight().getHeight(), pointSet.getTargetPointXYZ().getX(), pointSet.getTargetPointXYZ().getY(), pointSet.getTargetPointXYZ().getZ());
        }
    }

    public Set<String> getNonTransformedPointIds() {
        return this.nonTransformedPointIds;
    }

    public boolean hasHigherResolutionGrids() {
        return this.transformator.getTransformationType() == TransformationType.NTv2_GRID && this.hasHigherResolutionGrids;
    }

    @Override
    public boolean readSourceFile() {
        if (this.destFile == null) {
            return false;
        }
        boolean isRead = false;
        try {
            try {
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.destFile)));
                isRead = super.readSourceFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                isRead = false;
                if (this.printWriter != null) {
                    this.printWriter.close();
                }
            }
        }
        finally {
            if (this.printWriter != null) {
                this.printWriter.close();
            }
        }
        return isRead;
    }
}

