/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.io;

import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.tools.io.LockFileReader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class BasePointsFileReader
extends LockFileReader {
    private Map<String, PointENH> basePoints = new HashMap<String, PointENH>();

    public BasePointsFileReader(String fileName) {
        this(new File(fileName));
    }

    public BasePointsFileReader(File sf) {
        super(sf);
        this.ignoreLinesWhichStartWith("#");
        this.basePoints.clear();
    }

    @Override
    public void parse(String line) {
        if (line == null || line.trim().isEmpty()) {
            return;
        }
        String[] dataSet = line.trim().split(",");
        if (dataSet.length < 3 && dataSet[0].trim().matches("^\\D+$")) {
            return;
        }
        try {
            String key = dataSet[0].trim();
            double east = Double.parseDouble(dataSet[1].trim()) / 1000.0;
            double north = Double.parseDouble(dataSet[2].trim()) / 1000.0;
            this.basePoints.put(key, new PointENH(east, north, 0.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, PointENH> getBasePoints() {
        return this.basePoints;
    }
}

