/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.textfieldverifier;

import com.derletztekick.tools.textfieldverifier.NumberValueFormattedTextFieldVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class GeographicCoordinateFormattedTextFieldVerifier
extends NumberValueFormattedTextFieldVerifier {
    public GeographicCoordinateFormattedTextFieldVerifier(boolean allowEmptyValues) {
        super(allowEmptyValues);
    }

    @Override
    public boolean verify(JComponent comp) {
        if (comp instanceof JTextField) {
            if (super.verify(comp)) {
                return true;
            }
            JTextField textField = (JTextField)comp;
            String content = textField.getText().trim();
            double sig = 1.0;
            if (content.startsWith("-")) {
                sig = -1.0;
                content = content.substring(1);
            }
            String[] columns = content.split("[^\\d\\.]+");
            try {
                double dd = 0.0;
                double mm = 0.0;
                double ss = 0.0;
                if (columns.length >= 1) {
                    dd = Math.abs(Double.parseDouble(columns[0]));
                }
                if (columns.length >= 2) {
                    mm = Math.abs(Double.parseDouble(columns[1]));
                }
                if (columns.length >= 3) {
                    ss = Math.abs(Double.parseDouble(columns[2]));
                }
                textField.setText(String.valueOf(sig * (dd + mm / 60.0 + ss / 3600.0)));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return super.verify(comp);
    }
}

