/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.tools.textfieldverifier.NumberValueFormattedTextFieldVerifier;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class TransformationParameterPanel
extends JPanel {
    private static final long serialVersionUID = 4808662847709402959L;
    private JFormattedTextField[] fields = new JFormattedTextField[7];

    public TransformationParameterPanel() {
        double[][] size = new double[][]{{-1.0, -2.0, 5.0, -2.0, 15.0, -2.0, 5.0, -2.0, 15.0, -2.0, 5.0, -2.0, 15.0, -2.0, 5.0, -2.0, -1.0}, {-2.0, 10.0, -2.0}};
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.initComponents();
    }

    public void setValues(double[] values) {
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i].setValue(values[i]);
            ++i;
        }
    }

    public double[] getValues() {
        double[] values = new double[this.fields.length];
        int i = 0;
        while (i < this.fields.length) {
            values[i] = ((Number)this.fields[i].getValue()).doubleValue();
            ++i;
        }
        return values;
    }

    private void initComponents() {
        NumberFormat format = this.getDoubleNumberDisplayFormat();
        String[] labels = new String[]{"Tx [m]:", "Ty [m]", "Tz [m]", "s [ppm]", "Rx [\u2033]:", "Ry [\u2033]:", "Rz [\u2033]:"};
        int col = 1;
        int row = 0;
        int i = 0;
        while (i < labels.length) {
            JFormattedTextField field = i == 3 ? this.getFormattedTextField(this.getPartsPerMillionFormatter(format), this.getPartsPerMillionFormatter(format)) : (i > 3 ? this.getFormattedTextField(this.getAngleSecondFormatter(format), this.getAngleSecondFormatter(format)) : this.getFormattedTextField(new NumberFormatter(format), new NumberFormatter(format)));
            this.add((Component)new JLabel(labels[i]), col + "," + row);
            this.add((Component)field, col + 2 + "," + row);
            this.fields[i] = field;
            if ((col += 4) >= 15) {
                col = 1;
                row = 2;
            }
            ++i;
        }
    }

    private JFormattedTextField getFormattedTextField(NumberFormatter display, NumberFormatter edit) {
        JFormattedTextField jft = new JFormattedTextField(new DefaultFormatterFactory(display, edit));
        jft.setInputVerifier(new NumberValueFormattedTextFieldVerifier(false));
        jft.setFocusLostBehavior(1);
        jft.setHorizontalAlignment(4);
        jft.setColumns(5);
        return jft;
    }

    private NumberFormat getDoubleNumberDisplayFormat() {
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        doubleFormat.setMinimumFractionDigits(3);
        doubleFormat.setMaximumFractionDigits(5);
        doubleFormat.setMinimumIntegerDigits(1);
        doubleFormat.setGroupingUsed(false);
        return doubleFormat;
    }

    private NumberFormatter getPartsPerMillionFormatter(NumberFormat format) {
        return new NumberFormatter(format){
            private static final long serialVersionUID = 1L;

            @Override
            public String valueToString(Object o) throws ParseException {
                Number number = (Number)o;
                if (number != null) {
                    double d = (number.doubleValue() - 1.0) * 1000000.0;
                    number = d;
                }
                return super.valueToString(number);
            }

            @Override
            public Object stringToValue(String s) throws ParseException {
                Number number = (Number)super.stringToValue(s);
                if (number != null) {
                    double d = 1.0 + number.doubleValue() * 1.0E-6;
                    number = d;
                }
                return number;
            }
        };
    }

    private NumberFormatter getAngleSecondFormatter(NumberFormat format) {
        return new NumberFormatter(format){
            private static final long serialVersionUID = 1L;

            @Override
            public String valueToString(Object o) throws ParseException {
                Number number = (Number)o;
                if (number != null) {
                    double d = number.doubleValue() * 3600.0 / (Math.PI / 180);
                    number = d;
                }
                return super.valueToString(number);
            }

            @Override
            public Object stringToValue(String s) throws ParseException {
                Number number = (Number)super.stringToValue(s);
                if (number != null) {
                    double d = number.doubleValue() * (Math.PI / 180) / 3600.0;
                    number = d;
                }
                return number;
            }
        };
    }
}

