/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.transformation.HomologuePointSet;
import com.derletztekick.geodesy.earth.transformation.Transformator;
import com.derletztekick.geodesy.geotra.gui.GeoTra;
import com.derletztekick.geodesy.geotra.gui.panel.BatchFilePanel;
import com.derletztekick.geodesy.geotra.gui.panel.CoordinatePanel;
import com.derletztekick.geodesy.geotra.gui.panel.StrictSystemPanel;
import com.derletztekick.geodesy.geotra.io.CoordinateType;
import com.derletztekick.geodesy.geotra.io.DualPointFileReaderAndWriter;
import com.derletztekick.tools.io.FileChooser;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StrictTransformationSettingPanel
extends JPanel {
    private static final long serialVersionUID = 8499874926690297875L;
    private StrictSystemPanel srcSystemPanel = new StrictSystemPanel();
    private StrictSystemPanel trgSystemPanel = new StrictSystemPanel();
    private CoordinatePanel srcCoordPanel = new CoordinatePanel(true, true);
    private CoordinatePanel trgCoordPanel = new CoordinatePanel(false, true);
    private FileChooser fileChooser = new FileChooser(this);
    private BatchFilePanel srcBatchFilePanel = new BatchFilePanel(this.fileChooser, true);
    private BatchFilePanel trgBatchFilePanel = new BatchFilePanel(this.fileChooser, false);

    public StrictTransformationSettingPanel() {
        double[][] size = new double[][]{{-1.0, -2.0, 10.0, -2.0, -1.0}, {-2.0, 15.0, -2.0, 15.0, -2.0, 15.0, -2.0}};
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        this.srcSystemPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.system")));
        this.trgSystemPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.system")));
        this.srcCoordPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.coords")));
        this.trgCoordPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.coords")));
        this.srcBatchFilePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.batch")));
        this.trgBatchFilePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.batch")));
        this.add((Component)this.srcSystemPanel, "1,0,3,0");
        this.add((Component)this.trgSystemPanel, "1,2,3,2");
        this.add((Component)this.srcCoordPanel, "1,4");
        this.add((Component)this.trgCoordPanel, "3,4");
        this.add((Component)this.srcBatchFilePanel, "1,6");
        this.add((Component)this.trgBatchFilePanel, "3,6");
        this.srcSystemPanel.addProjectionChangedListener(this.srcCoordPanel);
        this.trgSystemPanel.addProjectionChangedListener(this.trgCoordPanel);
    }

    private void resetWarningMessages() {
        this.srcCoordPanel.displayWarningMessage(null);
        this.trgCoordPanel.displayWarningMessage(null);
    }

    public void transform() {
        this.resetWarningMessages();
        GeodeticDatum srcDatum = this.srcSystemPanel.getGeodeticDatum();
        GeodeticDatum trgDatum = this.trgSystemPanel.getGeodeticDatum();
        boolean hasSrcRefLonLat = this.srcCoordPanel.hasReferenceLongitudeAndLatitude();
        boolean hasTrgRefLonLat = this.trgCoordPanel.hasReferenceLongitudeAndLatitude();
        boolean hasSrcRefLon = !hasSrcRefLonLat && this.srcCoordPanel.hasReferenceLongitude();
        boolean hasTrgRefLon = !hasTrgRefLonLat && this.trgCoordPanel.hasReferenceLongitude();
        Transformator transformator = new Transformator(srcDatum, trgDatum);
        boolean isValidCenterMeridian = true;
        if (hasSrcRefLonLat) {
            refLonSrc = this.srcCoordPanel.getReferenceLongitude();
            double refLatSrc = this.srcCoordPanel.getReferenceLatitude();
            transformator.setReferenceLongitudeAndLatitudeSourceSystem(refLonSrc, refLatSrc);
        } else if (hasSrcRefLon) {
            boolean isValidSourceSystemCenterMeridian;
            refLonSrc = this.srcCoordPanel.getReferenceLongitude();
            transformator.setReferenceLongitudeSourceSystem(refLonSrc);
            isValidCenterMeridian = isValidSourceSystemCenterMeridian = transformator.isValidSourceSystemCenterMeridian();
            if (!isValidSourceSystemCenterMeridian) {
                this.srcCoordPanel.displayWarningMessage(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaIconTooltip"));
            }
        }
        if (hasTrgRefLonLat) {
            refLonTrg = this.trgCoordPanel.getReferenceLongitude();
            double refLatTrg = this.trgCoordPanel.getReferenceLatitude();
            transformator.setReferenceLongitudeAndLatitudeTargetSystem(refLonTrg, refLatTrg);
        } else if (hasTrgRefLon) {
            refLonTrg = this.trgCoordPanel.getReferenceLongitude();
            transformator.setReferenceLongitudeTargetSystem(refLonTrg);
            boolean isValidTargetSystemCenterMeridian = transformator.isValidTargetSystemCenterMeridian();
            boolean bl = isValidCenterMeridian = isValidCenterMeridian && isValidTargetSystemCenterMeridian;
            if (!transformator.isValidTargetSystemCenterMeridian()) {
                this.trgCoordPanel.displayWarningMessage(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaIconTooltip"));
            }
        }
        if (!isValidCenterMeridian && JOptionPane.showConfirmDialog(this, GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaTitle"), 0) == 1) {
            return;
        }
        HomologuePointSet pointSet = null;
        boolean hasUserSubmission = true;
        if (this.srcCoordPanel.isLatLonCoordsSubmission(true)) {
            pointSet = transformator.transformLatitudeLongitudeHeight(this.srcCoordPanel.getLatLonCoords());
        } else if (this.srcCoordPanel.isEastNorthCoordsSubmission(true)) {
            pointSet = transformator.transformEastNorthHeight(this.srcCoordPanel.getEastNorthCoords());
        } else if (this.srcCoordPanel.isXYZCoordsSubmission(true)) {
            pointSet = transformator.transformXYZ(this.srcCoordPanel.getXYZCoords());
        } else {
            hasUserSubmission = false;
        }
        if (pointSet != null) {
            this.srcCoordPanel.setXYZCoords(pointSet.getSourcePointXYZ());
            this.srcCoordPanel.setEastNorthCoords(pointSet.getSourcePointEastNorthHeight());
            this.srcCoordPanel.setLatLonCoords(pointSet.getSourcePointLatitudeLongitudeHeight());
            this.trgCoordPanel.setXYZCoords(pointSet.getTargetPointXYZ());
            this.trgCoordPanel.setEastNorthCoords(pointSet.getTargetPointEastNorthHeight());
            this.trgCoordPanel.setLatLonCoords(pointSet.getTargetPointLatitudeLongitudeHeight());
        } else if (pointSet == null && hasUserSubmission) {
            JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoTitle"), 0);
        }
        File srcFile = this.srcBatchFilePanel.getFile();
        File destFile = this.trgBatchFilePanel.getFile();
        if (srcFile != null && destFile != null) {
            DualPointFileReaderAndWriter dualPointFileReaderAndWriter = null;
            if (this.srcCoordPanel.isLatLonCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.LatLonHeight, srcFile, destFile);
            } else if (this.srcCoordPanel.isEastNorthCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.EastNorthHeight, srcFile, destFile);
            } else if (this.srcCoordPanel.isXYZCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.XYZ, srcFile, destFile);
            }
            if (dualPointFileReaderAndWriter == null || !dualPointFileReaderAndWriter.readSourceFile()) {
                System.err.println(this.getClass().getSimpleName() + " Fehler beim Konvertieren der Daten! " + srcFile.getName() + " --> " + destFile.getName());
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.batchBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.batchTitle"), 0);
                return;
            }
            Set<String> nonTransformedPointIds = dualPointFileReaderAndWriter.getNonTransformedPointIds();
            if (nonTransformedPointIds.size() > 0) {
                StringBuffer ids = new StringBuffer("");
                int counter = 0;
                int lineSize = 0;
                for (String id : nonTransformedPointIds) {
                    if (lineSize > 40) {
                        ids.append("\n");
                        lineSize = 0;
                    }
                    ids.append(id);
                    lineSize += id.length();
                    if (counter < nonTransformedPointIds.size() - 1) {
                        ids.append(", ");
                    }
                    ++counter;
                }
                JOptionPane.showMessageDialog(this.getParent(), String.format(Locale.ENGLISH, GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchBodyWithWarning"), nonTransformedPointIds.size(), ids), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchTitleWithWarning"), 2);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchTitle"), 1);
            }
        }
    }
}

