/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.ellipsoid.EllipsoidType;
import com.derletztekick.geodesy.earth.projection.MapProjection;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.geotra.gui.GeoTra;
import com.derletztekick.geodesy.geotra.gui.combobox.DatumComboBox;
import com.derletztekick.geodesy.geotra.gui.combobox.EllipsoidComboBox;
import com.derletztekick.geodesy.geotra.gui.combobox.ProjectionComboBox;
import com.derletztekick.geodesy.geotra.gui.panel.ProjectionChangedEvent;
import com.derletztekick.geodesy.geotra.gui.panel.ProjectionChangedListener;
import com.derletztekick.geodesy.geotra.gui.panel.TransformationParameterPanel;
import com.derletztekick.tools.textfieldverifier.AbsoluteValueFormattedTextFieldVerifier;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.EventListenerList;

public class StrictSystemPanel
extends JPanel {
    private static final long serialVersionUID = -3258804414700165249L;
    private boolean eventAtWork = false;
    private JCheckBox estimationTypeCB;
    private DatumComboBox datumComboBox = new DatumComboBox();
    private ProjectionComboBox projectionComboBox = new ProjectionComboBox(this.datumComboBox);
    private EllipsoidComboBox ellipsoidComboBox = new EllipsoidComboBox();
    private JFormattedTextField ellipsoidMajorAxisFTF;
    private JFormattedTextField ellipsoidMinorAxisFTF;
    private TransformationParameterPanel transformationParameterPanel = new TransformationParameterPanel();
    private ProjectionActionListener projectionListener = new ProjectionActionListener();
    private DatumComboBoxListener datumListener = new DatumComboBoxListener();
    private EventListenerList listenerList = new EventListenerList();

    public StrictSystemPanel() {
        double[][] size = new double[][]{{-1.0, 100.0, 20.0, -2.0, 5.0, -2.0, 10.0, -2.0, 5.0, -2.0, -1.0}, {-2.0, 10.0, -2.0, 10.0, -2.0, 5.0, -2.0}};
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.initComponents();
    }

    private void initComponents() {
        TitledBorder trafoPanelBorder = BorderFactory.createTitledBorder("\u2192 WGS84");
        this.estimationTypeCB = new JCheckBox(GeoTra.BABEL.getString("TransformationSettingPanel", "strictEstimation"), false);
        this.transformationParameterPanel.setBorder(trafoPanelBorder);
        NumberFormat format = this.getDoubleNumberDisplayFormat();
        this.ellipsoidMajorAxisFTF = this.getFormattedTextField(format, true);
        this.ellipsoidMinorAxisFTF = this.getFormattedTextField(format, true);
        this.add((Component)this.datumComboBox, "1,0, 5,0");
        this.add((Component)this.projectionComboBox, "7,0,9,0");
        this.add((Component)this.ellipsoidComboBox, "1,2");
        this.add((Component)new JLabel("a [m]:"), "3,2");
        this.add((Component)new JLabel("b [m]:"), "7,2");
        this.add((Component)this.ellipsoidMajorAxisFTF, "5,2");
        this.add((Component)this.ellipsoidMinorAxisFTF, "9,2");
        this.add((Component)this.transformationParameterPanel, "1,4,9,4");
        this.add((Component)this.estimationTypeCB, "1,6,9,6");
        this.setGeodeticDatum(GeodeticDatumType.ETRS89);
        this.datumComboBox.addActionListener(this.datumListener);
        this.ellipsoidComboBox.addActionListener(this.datumListener);
        this.projectionComboBox.addActionListener(this.datumListener);
        this.projectionComboBox.addActionListener(this.projectionListener);
    }

    private JFormattedTextField getFormattedTextField(NumberFormat format, boolean excludeZeroValues) {
        JFormattedTextField jft = new JFormattedTextField(format);
        jft.setInputVerifier(new AbsoluteValueFormattedTextFieldVerifier(excludeZeroValues, false));
        jft.setFocusLostBehavior(1);
        jft.setHorizontalAlignment(4);
        jft.setColumns(12);
        jft.setEditable(false);
        return jft;
    }

    private NumberFormat getDoubleNumberDisplayFormat() {
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        doubleFormat.setMinimumFractionDigits(3);
        doubleFormat.setMaximumFractionDigits(8);
        doubleFormat.setMinimumIntegerDigits(1);
        doubleFormat.setGroupingUsed(false);
        return doubleFormat;
    }

    public void setGeodeticDatum(GeodeticDatumType type) {
        if (type != GeodeticDatumType.UNDEFINED) {
            GeodeticDatum datum = new GeodeticDatum(type);
            MapProjection projection = datum.getProjection();
            Ellipsoid ellipsoid = projection.getEllipsoid();
            this.projectionComboBox.setSelectedItem((Object)projection.getType());
            this.setEllipsoid(ellipsoid.getType());
            this.transformationParameterPanel.setValues(datum.getTransformationFromLocalToWGS84().getTransformationParameter());
        }
    }

    public GeodeticDatum getGeodeticDatum() {
        GeodeticDatum geodeticDatum = null;
        GeodeticDatumType type = this.datumComboBox.getSelectedItem();
        double[] trafoParam = this.transformationParameterPanel.getValues();
        if (type == GeodeticDatumType.UNDEFINED || type == GeodeticDatumType.MGI_A) {
            MapProjection projection = this.getMapProjection();
            geodeticDatum = new GeodeticDatum(type, projection, trafoParam[0], trafoParam[1], trafoParam[2], trafoParam[3], trafoParam[4], trafoParam[5], trafoParam[6]);
        } else {
            geodeticDatum = new GeodeticDatum(type, trafoParam[0], trafoParam[1], trafoParam[2], trafoParam[3], trafoParam[4], trafoParam[5], trafoParam[6]);
        }
        geodeticDatum.getProjection().useApproximation(!this.estimationTypeCB.isSelected());
        return geodeticDatum;
    }

    private MapProjection getMapProjection() {
        return new MapProjection(this.getEllipsoid(), this.projectionComboBox.getSelectedItem(), !this.estimationTypeCB.isSelected());
    }

    private Ellipsoid getEllipsoid() {
        EllipsoidType type = this.ellipsoidComboBox.getSelectedItem();
        if (type == EllipsoidType.USER_DEFINED) {
            double a = ((Number)this.ellipsoidMajorAxisFTF.getValue()).doubleValue();
            double b = ((Number)this.ellipsoidMinorAxisFTF.getValue()).doubleValue();
            return new Ellipsoid(type.getLabel(), Math.max(a, b), Math.min(a, b));
        }
        return new Ellipsoid(type);
    }

    private void setEllipsoid(EllipsoidType type) {
        TitledBorder trafoPanelBorder = (TitledBorder)this.transformationParameterPanel.getBorder();
        if (type != EllipsoidType.USER_DEFINED) {
            Ellipsoid ellipsoid = new Ellipsoid(type);
            this.ellipsoidComboBox.setSelectedItem((Object)ellipsoid.getType());
            this.ellipsoidMajorAxisFTF.setValue(ellipsoid.getMajorAxis());
            this.ellipsoidMinorAxisFTF.setValue(ellipsoid.getMinorAxis());
            this.ellipsoidMajorAxisFTF.setEditable(false);
            this.ellipsoidMinorAxisFTF.setEditable(false);
            trafoPanelBorder.setTitle(type.getLabel() + " \u2192 WGS84");
        } else {
            trafoPanelBorder.setTitle("User Defined \u2192 WGS84");
            this.ellipsoidMajorAxisFTF.setEditable(true);
            this.ellipsoidMinorAxisFTF.setEditable(true);
        }
    }

    void addProjectionChangedListener(ProjectionChangedListener listener) {
        this.listenerList.add(ProjectionChangedListener.class, listener);
    }

    void removeProjectionChangedListener(ProjectionChangedListener listener) {
        this.listenerList.remove(ProjectionChangedListener.class, listener);
    }

    private void fireProjectionChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ProjectionChangedEvent event = new ProjectionChangedEvent(this.projectionComboBox);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ProjectionChangedListener.class) {
                ((ProjectionChangedListener)listeners[i + 1]).projectionChanged(event);
            }
            i -= 2;
        }
    }

    private class DatumComboBoxListener
    implements ActionListener {
        private DatumComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (StrictSystemPanel.this.eventAtWork) {
                return;
            }
            if (evt.getSource() == StrictSystemPanel.this.datumComboBox) {
                StrictSystemPanel.this.eventAtWork = true;
                if (StrictSystemPanel.this.datumComboBox.getSelectedItem() instanceof GeodeticDatumType) {
                    StrictSystemPanel.this.setGeodeticDatum(StrictSystemPanel.this.datumComboBox.getSelectedItem());
                } else {
                    StrictSystemPanel.this.setGeodeticDatum(GeodeticDatumType.UNDEFINED);
                }
                StrictSystemPanel.this.eventAtWork = false;
            } else if (evt.getSource() == StrictSystemPanel.this.projectionComboBox) {
                StrictSystemPanel.this.eventAtWork = true;
                StrictSystemPanel.this.fireProjectionChanged();
                ProjectionType projectionType = StrictSystemPanel.this.projectionComboBox.getSelectedItem();
                if (StrictSystemPanel.this.datumComboBox.getSelectedItem() != GeodeticDatumType.MGI_A || projectionType != ProjectionType.MGI_M28 && projectionType != ProjectionType.MGI_M31 && projectionType != ProjectionType.MGI_M34) {
                    StrictSystemPanel.this.datumComboBox.setSelectedItem((Object)GeodeticDatumType.UNDEFINED);
                }
                StrictSystemPanel.this.eventAtWork = false;
            } else if (evt.getSource() == StrictSystemPanel.this.ellipsoidComboBox) {
                StrictSystemPanel.this.eventAtWork = true;
                StrictSystemPanel.this.datumComboBox.setSelectedItem((Object)GeodeticDatumType.UNDEFINED);
                if (StrictSystemPanel.this.ellipsoidComboBox.getSelectedItem() instanceof EllipsoidType) {
                    StrictSystemPanel.this.setEllipsoid(StrictSystemPanel.this.ellipsoidComboBox.getSelectedItem());
                } else {
                    StrictSystemPanel.this.setEllipsoid(EllipsoidType.USER_DEFINED);
                }
                StrictSystemPanel.this.eventAtWork = false;
            }
        }
    }

    private class ProjectionActionListener
    implements ActionListener {
        private ProjectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == StrictSystemPanel.this.projectionComboBox && StrictSystemPanel.this.estimationTypeCB != null) {
                StrictSystemPanel.this.estimationTypeCB.setEnabled(StrictSystemPanel.this.projectionComboBox.getSelectedItem() != ProjectionType.SOLDNER);
            }
        }
    }
}

