/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.transformation.HomologuePointSet;
import com.derletztekick.geodesy.earth.transformation.TransformationType;
import com.derletztekick.geodesy.earth.transformation.Transformator;
import com.derletztekick.geodesy.geotra.gui.GeoTra;
import com.derletztekick.geodesy.geotra.gui.combobox.FileComboBox;
import com.derletztekick.geodesy.geotra.gui.combobox.GridComboBox;
import com.derletztekick.geodesy.geotra.gui.panel.BatchFilePanel;
import com.derletztekick.geodesy.geotra.gui.panel.CoordinatePanel;
import com.derletztekick.geodesy.geotra.gui.panel.GridSystemPanel;
import com.derletztekick.geodesy.geotra.io.CoordinateType;
import com.derletztekick.geodesy.geotra.io.DualPointFileReaderAndWriter;
import com.derletztekick.geodesy.geotra.io.nt.NTGSAReader;
import com.derletztekick.geodesy.geotra.io.nt.NTGSBReader;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTReader;
import com.derletztekick.tools.io.FileChooser;
import com.derletztekick.tools.textfieldverifier.AbsoluteValueFormattedTextFieldVerifier;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GridTransformationSettingPanel
extends JPanel {
    private static final long serialVersionUID = -3433866053388462046L;
    private static final String PATH2GRIDS = "NTv2/";
    private GridSystemPanel srcSystemPanel = new GridSystemPanel();
    private GridSystemPanel trgSystemPanel = new GridSystemPanel();
    private FileComboBox fileComboBox;
    private File lastSelectedGridFile = null;
    private GridComboBox gridComboBox = new GridComboBox();
    private CoordinatePanel srcCoordPanel = new CoordinatePanel(true, false);
    private CoordinatePanel trgCoordPanel = new CoordinatePanel(false, false);
    private FileChooser fileChooser = new FileChooser(this);
    private BatchFilePanel srcBatchFilePanel = new BatchFilePanel(this.fileChooser, true);
    private BatchFilePanel trgBatchFilePanel = new BatchFilePanel(this.fileChooser, false);
    private JCheckBox autoSelectingSubGrid;
    private JCheckBox pseudoExtrapolationCB;
    private JLabel warnIconLabel = new JLabel();
    private Icon warnIcon = null;
    private JFormattedTextField pseudoExtrapolationValueFTF;

    public GridTransformationSettingPanel() {
        double[][] size = new double[][]{{-1.0, -2.0, 10.0, -2.0, -1.0}, {-2.0, 3.0, -2.0, 10.0, -2.0, 15.0, -2.0, 15.0, -2.0, 15.0, -2.0}};
        try {
            this.warnIcon = new ImageIcon(this.getClass().getResource("/com/derletztekick/geodesy/geotra/gui/icon/exclamation.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        NumberFormat format = this.getDoubleNumberDisplayFormat();
        this.pseudoExtrapolationValueFTF = this.getFormattedTextField(format, true);
        this.pseudoExtrapolationValueFTF.setValue(99);
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.initComponents();
    }

    private void initComponents() {
        GridActionListener gal = new GridActionListener();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        File[] grids = this.getGridFiles();
        if (grids == null || grids.length == 0) {
            JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.noNTV2DirBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.noNTV2DirTitle"), 0);
        }
        this.srcSystemPanel.addProjectionChangedListener(this.srcCoordPanel);
        this.trgSystemPanel.addProjectionChangedListener(this.trgCoordPanel);
        this.fileComboBox = new FileComboBox(grids);
        File[] fileArray = grids;
        int n = grids.length;
        int n2 = 0;
        while (n2 < n) {
            File grid = fileArray[n2];
            if (grid.getName().contains("BETA2007")) {
                this.fileComboBox.setSelectedItem(grid);
                break;
            }
            ++n2;
        }
        this.autoSelectingSubGrid = new JCheckBox(GeoTra.BABEL.getString("TransformationSettingPanel", "autoSelectingSubGrid"), true);
        this.autoSelectingSubGrid.setActionCommand("GRID");
        this.autoSelectingSubGrid.addActionListener(gal);
        this.pseudoExtrapolationCB = new JCheckBox(GeoTra.BABEL.getString("TransformationSettingPanel", "extrapolationLimitValue"), false);
        this.pseudoExtrapolationCB.setActionCommand("EXTRAPOLATION");
        this.pseudoExtrapolationCB.addActionListener(gal);
        this.setGrid(this.getGridFromFile());
        this.srcSystemPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.system")));
        this.trgSystemPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.system")));
        this.srcCoordPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.coords")));
        this.trgCoordPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.coords")));
        this.srcBatchFilePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.batch")));
        this.trgBatchFilePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.batch")));
        this.add((Component)this.fileComboBox, "1,0");
        this.add((Component)this.gridComboBox, "3,0");
        JPanel extrapolationGridPanel = new JPanel();
        extrapolationGridPanel.setLayout(new FlowLayout(0, 5, 3));
        extrapolationGridPanel.add(this.pseudoExtrapolationCB);
        extrapolationGridPanel.add(this.pseudoExtrapolationValueFTF);
        this.add((Component)extrapolationGridPanel, "1,2");
        JPanel autoGridPanel = new JPanel();
        autoGridPanel.setLayout(new FlowLayout(0, 5, 3));
        autoGridPanel.add(this.autoSelectingSubGrid);
        autoGridPanel.add(this.warnIconLabel);
        this.add((Component)autoGridPanel, "3,2");
        this.add((Component)this.srcSystemPanel, "1,4,3,4");
        this.add((Component)this.trgSystemPanel, "1,6,3,6");
        this.add((Component)this.srcCoordPanel, "1,8");
        this.add((Component)this.trgCoordPanel, "3,8");
        this.add((Component)this.srcBatchFilePanel, "1,10");
        this.add((Component)this.trgBatchFilePanel, "3,10");
        this.fileComboBox.setActionCommand("FILE");
        this.fileComboBox.addActionListener(gal);
        this.gridComboBox.setEnabled(false);
    }

    private void setGrid(NTGrid[] grids) {
        if (grids == null || grids.length == 0) {
            return;
        }
        boolean visible = grids.length > 1;
        this.gridComboBox.removeAllItems();
        this.gridComboBox.addItems(grids);
        this.gridComboBox.setVisible(visible);
        this.autoSelectingSubGrid.setVisible(visible);
        NTGrid subgrid = grids[0];
        this.srcSystemPanel.setGrid(grids, subgrid.getSourceDatum().getType());
        this.trgSystemPanel.setGrid(grids, subgrid.getTargetDatum().getType());
    }

    private NTGrid[] getGridFromFile() {
        NTGrid[] grids = null;
        File file = this.fileComboBox.getSelectedItem();
        if (file != null) {
            if (file == this.lastSelectedGridFile) {
                return null;
            }
            try {
                NTReader reader = file.getName().matches("(?i).+\\.gsb$") ? new NTGSBReader() : new NTGSAReader();
                grids = reader.read(file);
            }
            catch (Exception e) {
                grids = null;
                e.printStackTrace();
            }
            if (grids == null || grids.length == 0) {
                JOptionPane.showMessageDialog(this.getParent(), String.format(Locale.ENGLISH, GeoTra.BABEL.getString("TransformationSettingPanel", "err.ioNTV2FileBody"), file.getName()), GeoTra.BABEL.getString("TransformationSettingPanel", "err.ioNTV2FileTitle"), 0);
            } else {
                this.lastSelectedGridFile = file;
            }
        }
        return grids;
    }

    private File[] getGridFiles() {
        URL url = this.getClass().getClassLoader().getResource(PATH2GRIDS);
        if (url == null) {
            return new File[0];
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String name = entry.getFileName().toString().toLowerCase();
                return !name.matches("(?i)readme\\.txt$") && name.matches("(?i).+\\.gs[a|b]$");
            }
        };
        ArrayList<File> fileList = new ArrayList<File>();
        DirectoryStream<Path> stream = null;
        try {
            try {
                Path root = Paths.get(url.toURI());
                stream = Files.newDirectoryStream(root, (DirectoryStream.Filter<? super Path>)filter);
                for (Path p : stream) {
                    if (!Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)) continue;
                    fileList.add(p.toFile());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                File[] fileArray = new File[]{};
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return fileArray;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        File[] files = fileList.toArray(new File[fileList.size()]);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                if (file1.getName().matches("(?i).+\\.gsb$") && file2.getName().matches("(?i).+\\.gsb$") || !file1.getName().matches("(?i).+\\.gsb$") && !file2.getName().matches("(?i).+\\.gsb$")) {
                    return file1.compareTo(file2);
                }
                if (file1.getName().matches("(?i).+\\.gsb$")) {
                    return -1;
                }
                if (file2.getName().matches("(?i).+\\.gsb$")) {
                    return 1;
                }
                if (!file1.getName().matches("(?i).+\\.gsb$")) {
                    return 1;
                }
                if (!file2.getName().matches("(?i).+\\.gsb$")) {
                    return -1;
                }
                return file1.compareTo(file2);
            }
        });
        return files;
    }

    private void resetWarningMessages() {
        this.warnIconLabel.setIcon(null);
        this.warnIconLabel.setToolTipText("");
        this.srcCoordPanel.displayWarningMessage(null);
        this.trgCoordPanel.displayWarningMessage(null);
    }

    private NumberFormat getDoubleNumberDisplayFormat() {
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        doubleFormat.setMinimumFractionDigits(1);
        doubleFormat.setMaximumFractionDigits(6);
        doubleFormat.setMinimumIntegerDigits(1);
        doubleFormat.setGroupingUsed(false);
        return doubleFormat;
    }

    private JFormattedTextField getFormattedTextField(NumberFormat format, boolean excludeZeroValues) {
        JFormattedTextField jft = new JFormattedTextField(format);
        jft.setInputVerifier(new AbsoluteValueFormattedTextFieldVerifier(excludeZeroValues, false));
        jft.setFocusLostBehavior(1);
        jft.setHorizontalAlignment(4);
        jft.setColumns(3);
        jft.setEditable(false);
        return jft;
    }

    public void transform() {
        boolean useSelectedGrid;
        this.resetWarningMessages();
        NTGrid[] grids = this.srcSystemPanel.getGrids();
        NTGrid grid = null;
        if (grids == null || grids.length == 0 || (grid = this.gridComboBox.getSelectedItem()) == null) {
            return;
        }
        boolean bl = useSelectedGrid = !this.autoSelectingSubGrid.isSelected();
        if (useSelectedGrid) {
            grids = new NTGrid[]{grid};
        }
        GeodeticDatum srcDatum = this.srcSystemPanel.getGeodeticDatum();
        GeodeticDatum trgDatum = this.trgSystemPanel.getGeodeticDatum();
        boolean hasSrcRefLonLat = this.srcCoordPanel.hasReferenceLongitudeAndLatitude();
        boolean hasTrgRefLonLat = this.trgCoordPanel.hasReferenceLongitudeAndLatitude();
        boolean hasSrcRefLon = !hasSrcRefLonLat && this.srcCoordPanel.hasReferenceLongitude();
        boolean hasTrgRefLon = !hasTrgRefLonLat && this.trgCoordPanel.hasReferenceLongitude();
        Transformator transformator = new Transformator(grids, srcDatum, trgDatum, !useSelectedGrid);
        boolean isValidCenterMeridian = true;
        double extrapolationLimit = 0.0;
        if (this.pseudoExtrapolationCB.isSelected()) {
            extrapolationLimit = ((Number)this.pseudoExtrapolationValueFTF.getValue()).doubleValue();
        }
        transformator.setValueForExtrapolationLimit(extrapolationLimit);
        if (hasSrcRefLonLat) {
            refLonSrc = this.srcCoordPanel.getReferenceLongitude();
            double refLatSrc = this.srcCoordPanel.getReferenceLatitude();
            transformator.setReferenceLongitudeAndLatitudeSourceSystem(refLonSrc, refLatSrc);
        } else if (hasSrcRefLon) {
            boolean isValidSourceSystemCenterMeridian;
            refLonSrc = this.srcCoordPanel.getReferenceLongitude();
            transformator.setReferenceLongitudeSourceSystem(refLonSrc);
            isValidCenterMeridian = isValidSourceSystemCenterMeridian = transformator.isValidSourceSystemCenterMeridian();
            if (!isValidSourceSystemCenterMeridian) {
                this.srcCoordPanel.displayWarningMessage(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaIconTooltip"));
            }
        }
        if (hasTrgRefLonLat) {
            refLonTrg = this.trgCoordPanel.getReferenceLongitude();
            double refLatTrg = this.trgCoordPanel.getReferenceLatitude();
            transformator.setReferenceLongitudeAndLatitudeTargetSystem(refLonTrg, refLatTrg);
        } else if (hasTrgRefLon) {
            refLonTrg = this.trgCoordPanel.getReferenceLongitude();
            transformator.setReferenceLongitudeTargetSystem(refLonTrg);
            boolean isValidTargetSystemCenterMeridian = transformator.isValidTargetSystemCenterMeridian();
            boolean bl2 = isValidCenterMeridian = isValidCenterMeridian && isValidTargetSystemCenterMeridian;
            if (!transformator.isValidTargetSystemCenterMeridian()) {
                this.trgCoordPanel.displayWarningMessage(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaIconTooltip"));
            }
        }
        if (!isValidCenterMeridian && JOptionPane.showConfirmDialog(this, GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaTitle"), 0) == 1) {
            return;
        }
        HomologuePointSet pointSet = null;
        boolean hasUserSubmission = true;
        if (this.srcCoordPanel.isLatLonCoordsSubmission(true)) {
            pointSet = transformator.transformLatitudeLongitudeHeight(this.srcCoordPanel.getLatLonCoords());
        } else if (this.srcCoordPanel.isEastNorthCoordsSubmission(true)) {
            pointSet = transformator.transformEastNorthHeight(this.srcCoordPanel.getEastNorthCoords());
        } else {
            hasUserSubmission = false;
        }
        if (pointSet != null) {
            this.srcCoordPanel.setEastNorthCoords(pointSet.getSourcePointEastNorthHeight());
            this.srcCoordPanel.setLatLonCoords(pointSet.getSourcePointLatitudeLongitudeHeight());
            this.trgCoordPanel.setEastNorthCoords(pointSet.getTargetPointEastNorthHeight());
            this.trgCoordPanel.setLatLonCoords(pointSet.getTargetPointLatitudeLongitudeHeight());
            if (transformator.hasHigherResolutionGrid()) {
                NTGrid bestGrid = Transformator.getSubGrid(grids, pointSet, true);
                this.warnIconLabel.setIcon(this.warnIcon);
                this.warnIconLabel.setToolTipText(String.format(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.gridIconTooltip"), bestGrid == null ? "" : bestGrid.toString()));
            }
        } else if (pointSet == null && hasUserSubmission) {
            if (transformator.getTransformationType() == TransformationType.NTv2_GRID) {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoNTv2Body"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoNTv2Title"), 0);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoTitle"), 0);
            }
        }
        File srcFile = this.srcBatchFilePanel.getFile();
        File destFile = this.trgBatchFilePanel.getFile();
        if (srcFile != null && destFile != null) {
            Set<String> nonTransformedPointIds;
            DualPointFileReaderAndWriter dualPointFileReaderAndWriter = null;
            if (this.srcCoordPanel.isLatLonCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.LatLonHeight, srcFile, destFile);
            } else if (this.srcCoordPanel.isEastNorthCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.EastNorthHeight, srcFile, destFile);
            }
            if (dualPointFileReaderAndWriter == null || !dualPointFileReaderAndWriter.readSourceFile()) {
                System.err.println(this.getClass().getSimpleName() + " Fehler beim Konvertieren der Daten! " + srcFile.getName() + " --> " + destFile.getName());
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.batchBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.batchTitle"), 0);
                return;
            }
            if (dualPointFileReaderAndWriter.hasHigherResolutionGrids()) {
                this.warnIconLabel.setIcon(this.warnIcon);
                this.warnIconLabel.setToolTipText(String.format(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.gridIconTooltip"), ""));
            }
            if ((nonTransformedPointIds = dualPointFileReaderAndWriter.getNonTransformedPointIds()).size() > 0) {
                int maxNumOfPoints = Math.min(nonTransformedPointIds.size(), 35);
                StringBuffer ids = new StringBuffer("");
                int counter = 0;
                int lineSize = 0;
                for (String id : nonTransformedPointIds) {
                    if (lineSize > 40) {
                        ids.append("\n");
                        lineSize = 0;
                    }
                    ids.append(id);
                    lineSize += id.length();
                    if (counter < maxNumOfPoints - 1) {
                        ids.append(", ");
                    }
                    if (++counter < maxNumOfPoints) continue;
                    if (nonTransformedPointIds.size() - 1 < counter) break;
                    ids.append(",... ");
                    break;
                }
                JOptionPane.showMessageDialog(this.getParent(), String.format(Locale.ENGLISH, GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchBodyWithWarning"), nonTransformedPointIds.size(), ids), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchTitleWithWarning"), 2);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchTitle"), 1);
            }
        }
    }

    private class GridActionListener
    implements ActionListener {
        private GridActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals("FILE")) {
                new Thread(){

                    @Override
                    public void run() {
                        ((GridActionListener)GridActionListener.this).GridTransformationSettingPanel.this.warnIconLabel.setIcon(null);
                        ((GridActionListener)GridActionListener.this).GridTransformationSettingPanel.this.warnIconLabel.setToolTipText("");
                        ((GridActionListener)GridActionListener.this).GridTransformationSettingPanel.this.srcSystemPanel.setEnabled(false);
                        ((GridActionListener)GridActionListener.this).GridTransformationSettingPanel.this.trgSystemPanel.setEnabled(false);
                        GridTransformationSettingPanel.this.setGrid(GridTransformationSettingPanel.this.getGridFromFile());
                        ((GridActionListener)GridActionListener.this).GridTransformationSettingPanel.this.srcSystemPanel.setEnabled(true);
                        ((GridActionListener)GridActionListener.this).GridTransformationSettingPanel.this.trgSystemPanel.setEnabled(true);
                    }
                }.start();
            } else if (evt.getActionCommand().equals("GRID") && evt.getSource() == GridTransformationSettingPanel.this.autoSelectingSubGrid) {
                GridTransformationSettingPanel.this.gridComboBox.setEnabled(!GridTransformationSettingPanel.this.autoSelectingSubGrid.isSelected());
            } else if (evt.getActionCommand().equals("EXTRAPOLATION") && evt.getSource() == GridTransformationSettingPanel.this.pseudoExtrapolationCB) {
                GridTransformationSettingPanel.this.pseudoExtrapolationValueFTF.setEditable(GridTransformationSettingPanel.this.pseudoExtrapolationCB.isSelected());
            }
        }
    }
}

