/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.projection.MapProjection;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.geotra.gui.GeoTra;
import com.derletztekick.geodesy.geotra.gui.combobox.ProjectionComboBox;
import com.derletztekick.geodesy.geotra.gui.panel.ProjectionChangedEvent;
import com.derletztekick.geodesy.geotra.gui.panel.ProjectionChangedListener;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.tools.textfieldverifier.AbsoluteValueFormattedTextFieldVerifier;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class GridSystemPanel
extends JPanel {
    private static final long serialVersionUID = -2767107821719996151L;
    private ProjectionComboBox projectionComboBox;
    private JFormattedTextField ellipsoidMajorAxisFTF;
    private JFormattedTextField ellipsoidMinorAxisFTF;
    private JComboBox<GeodeticDatumType> datumComboBox;
    private JCheckBox estimationTypeCB;
    private NTGrid[] grids = new NTGrid[0];
    private DatumActionListener datumlistener = new DatumActionListener();
    private ProjectionActionListener projectionListener = new ProjectionActionListener();
    private EventListenerList listenerList = new EventListenerList();

    public GridSystemPanel() {
        double[][] size = new double[][]{{-1.0, -2.0, 5.0, -2.0, 10.0, -2.0, 5.0, -2.0, -1.0}, {-2.0, 10.0, -2.0, 5.0, -2.0}};
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.ellipsoidMajorAxisFTF.setEnabled(enabled);
        this.ellipsoidMinorAxisFTF.setEnabled(enabled);
        this.projectionComboBox.setEnabled(enabled);
        this.datumComboBox.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setGrid(NTGrid[] grids, GeodeticDatumType datumType) {
        if (grids == null || grids.length == 0) {
            return;
        }
        this.grids = grids;
        NTGrid subgrid = this.grids[0];
        this.projectionComboBox.removeActionListener(this.projectionListener);
        this.datumComboBox.removeActionListener(this.datumlistener);
        this.datumComboBox.removeAllItems();
        this.datumComboBox.addItem(subgrid.getSourceDatum().getType());
        this.datumComboBox.addItem(subgrid.getTargetDatum().getType());
        this.datumComboBox.setSelectedItem((Object)datumType);
        this.setGeodeticDatum(datumType);
        this.datumComboBox.addActionListener(this.datumlistener);
        this.projectionComboBox.addActionListener(this.projectionListener);
        this.fireProjectionChanged();
    }

    private void setGeodeticDatum(GeodeticDatumType datumType) {
        if (this.grids == null || this.grids.length == 0 || datumType == null) {
            return;
        }
        NTGrid subgrid = this.grids[0];
        if (subgrid.getTargetDatum().getType() == datumType) {
            this.ellipsoidMajorAxisFTF.setValue(subgrid.getTargetDatum().getProjection().getEllipsoid().getMajorAxis());
            this.ellipsoidMinorAxisFTF.setValue(subgrid.getTargetDatum().getProjection().getEllipsoid().getMinorAxis());
            this.projectionComboBox.setSelectedItem((Object)subgrid.getTargetDatum().getProjection().getType());
        } else {
            this.ellipsoidMajorAxisFTF.setValue(subgrid.getSourceDatum().getProjection().getEllipsoid().getMajorAxis());
            this.ellipsoidMinorAxisFTF.setValue(subgrid.getSourceDatum().getProjection().getEllipsoid().getMinorAxis());
            this.projectionComboBox.setSelectedItem((Object)subgrid.getSourceDatum().getProjection().getType());
        }
    }

    private void initComponents() {
        this.datumComboBox = new JComboBox();
        this.projectionComboBox = new ProjectionComboBox(this.datumComboBox);
        this.estimationTypeCB = new JCheckBox(GeoTra.BABEL.getString("TransformationSettingPanel", "strictEstimation"), false);
        NumberFormat format = this.getDoubleNumberDisplayFormat();
        this.ellipsoidMajorAxisFTF = this.getFormattedTextField(format, true);
        this.ellipsoidMinorAxisFTF = this.getFormattedTextField(format, true);
        this.add(this.datumComboBox, "1,0, 3,0");
        this.add((Component)this.projectionComboBox, "5,0,7,0");
        this.add((Component)new JLabel("a [m]:"), "1,2");
        this.add((Component)new JLabel("b [m]:"), "5,2");
        this.add((Component)this.ellipsoidMajorAxisFTF, "3,2");
        this.add((Component)this.ellipsoidMinorAxisFTF, "7,2");
        this.add((Component)this.estimationTypeCB, "1,4,7,4");
    }

    private NumberFormat getDoubleNumberDisplayFormat() {
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        doubleFormat.setMinimumFractionDigits(3);
        doubleFormat.setMaximumFractionDigits(8);
        doubleFormat.setMinimumIntegerDigits(1);
        doubleFormat.setGroupingUsed(false);
        return doubleFormat;
    }

    private JFormattedTextField getFormattedTextField(NumberFormat format, boolean excludeZeroValues) {
        JFormattedTextField jft = new JFormattedTextField(format);
        jft.setInputVerifier(new AbsoluteValueFormattedTextFieldVerifier(excludeZeroValues, false));
        jft.setFocusLostBehavior(1);
        jft.setHorizontalAlignment(4);
        jft.setColumns(12);
        jft.setEditable(false);
        return jft;
    }

    public GeodeticDatum getGeodeticDatum() {
        boolean projectionTypeHasChanged;
        if (this.grids == null || this.grids.length == 0) {
            return null;
        }
        NTGrid subgrid = this.grids[0];
        GeodeticDatum trgDatum = subgrid.getTargetDatum();
        GeodeticDatum srcDatum = subgrid.getSourceDatum();
        ProjectionType projectionType = this.projectionComboBox.getSelectedItem();
        if ((GeodeticDatumType)((Object)this.datumComboBox.getSelectedItem()) == trgDatum.getType()) {
            boolean projectionTypeHasChanged2;
            boolean bl = projectionTypeHasChanged2 = projectionType != trgDatum.getProjection().getType();
            if (trgDatum.getType() == GeodeticDatumType.UNKNOWN_TARGET_GEODETIC_DATUM || projectionTypeHasChanged2) {
                Ellipsoid ellipsoid = trgDatum.getProjection().getEllipsoid();
                trgDatum = new GeodeticDatum(trgDatum.getType(), new MapProjection(ellipsoid, projectionType, !this.estimationTypeCB.isSelected()));
                return trgDatum;
            }
            trgDatum.getProjection().useApproximation(!this.estimationTypeCB.isSelected());
            return trgDatum;
        }
        boolean bl = projectionTypeHasChanged = projectionType != trgDatum.getProjection().getType();
        if (srcDatum.getType() == GeodeticDatumType.UNKNOWN_SOURCE_GEODETIC_DATUM || projectionTypeHasChanged) {
            Ellipsoid ellipsoid = srcDatum.getProjection().getEllipsoid();
            srcDatum = new GeodeticDatum(srcDatum.getType(), new MapProjection(ellipsoid, projectionType, !this.estimationTypeCB.isSelected()));
            return srcDatum;
        }
        srcDatum.getProjection().useApproximation(!this.estimationTypeCB.isSelected());
        return srcDatum;
    }

    public NTGrid[] getGrids() {
        return this.grids;
    }

    void addProjectionChangedListener(ProjectionChangedListener listener) {
        this.listenerList.add(ProjectionChangedListener.class, listener);
    }

    void removeProjectionChangedListener(ProjectionChangedListener listener) {
        this.listenerList.remove(ProjectionChangedListener.class, listener);
    }

    private void fireProjectionChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ProjectionChangedEvent event = new ProjectionChangedEvent(this.projectionComboBox);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ProjectionChangedListener.class) {
                ((ProjectionChangedListener)listeners[i + 1]).projectionChanged(event);
            }
            i -= 2;
        }
    }

    private class DatumActionListener
    implements ActionListener {
        private DatumActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GridSystemPanel.this.datumComboBox) {
                GridSystemPanel.this.setGeodeticDatum((GeodeticDatumType)((Object)GridSystemPanel.this.datumComboBox.getSelectedItem()));
            }
        }
    }

    private class ProjectionActionListener
    implements ActionListener {
        private ProjectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GridSystemPanel.this.projectionComboBox) {
                GridSystemPanel.this.fireProjectionChanged();
                if (GridSystemPanel.this.estimationTypeCB != null) {
                    GridSystemPanel.this.estimationTypeCB.setEnabled(GridSystemPanel.this.projectionComboBox.getSelectedItem() != ProjectionType.SOLDNER);
                }
            }
        }
    }
}

