/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.earth.point.PointXYZ;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.geodesy.geotra.gui.panel.ProjectionChangedEvent;
import com.derletztekick.geodesy.geotra.gui.panel.ProjectionChangedListener;
import com.derletztekick.geodesy.geotra.gui.textfieldverifier.GeographicCoordinateFormattedTextFieldVerifier;
import com.derletztekick.tools.textfieldverifier.NumberValueFormattedTextFieldVerifier;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class CoordinatePanel
extends JPanel
implements ProjectionChangedListener {
    private static final long serialVersionUID = -6232262520994701238L;
    private JFormattedTextField[][] fields = new JFormattedTextField[3][3];
    private JFormattedTextField longitudeRefGKUTMJFT;
    private JFormattedTextField longitudeRefSoldnerJFT;
    private JFormattedTextField latitudeRefSoldnerJFT;
    private JLabel warnIconLabel = new JLabel();
    private Icon warnIcon = null;
    private JRadioButton[] selectedCoordinateBlockRBs = new JRadioButton[3];
    private SelectedCoordinatePanel listener = new SelectedCoordinatePanel();
    private final boolean isEditable;
    private boolean hasHeight = false;
    private String[][] labels = new String[][]{{"\u03bb [\u00b0]:", "\u03c6 [\u00b0]:", "<html>h<small>Ell</small> [m]:</html>"}, {"East y [m]:", "North x [m]:", "<html>h<small>Ell</small> [m]:</html>"}, {"X [m]:", "Y [m]:", "Z [m]:"}};

    public CoordinatePanel(boolean isEditable, boolean hasHeight) {
        this.isEditable = isEditable;
        this.hasHeight = hasHeight;
        double[] columns = this.isEditable ? new double[]{-1.0, -2.0, 2.0, -2.0, 5.0, -2.0, 10.0, -2.0, 5.0, -2.0, 5.0, -2.0, -1.0} : new double[]{-1.0, -2.0, 5.0, -2.0, 10.0, -2.0, 5.0, -2.0, 5.0, -2.0, -1.0};
        double[] rows = this.hasHeight ? new double[]{-2.0, 5.0, -2.0, 5.0, -2.0, 20.0, -2.0, 5.0, -2.0, 5.0, -2.0, 20.0, -2.0, 5.0, -2.0, 5.0, -2.0} : new double[]{-2.0, 5.0, -2.0, 20.0, -2.0, 5.0, -2.0};
        double[][] size = new double[][]{columns, rows};
        try {
            this.warnIcon = new ImageIcon(this.getClass().getResource("/com/derletztekick/geodesy/geotra/gui/icon/exclamation.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.init();
    }

    private void init() {
        int cols = 10;
        NumberFormat doubleFormat39 = this.getDoubleNumberDisplayFormat(3, 9);
        NumberFormat doubleFormat59 = this.getDoubleNumberDisplayFormat(5, 9);
        NumberFormat intFormat = this.getIntegerNumberDisplayFormat();
        if (this.hasHeight) {
            this.fields = new JFormattedTextField[3][3];
            this.selectedCoordinateBlockRBs = new JRadioButton[3];
        } else {
            this.fields = new JFormattedTextField[2][2];
            this.selectedCoordinateBlockRBs = new JRadioButton[2];
        }
        this.fields[0][0] = this.getFormattedTextField(this.getDegreeFormatter(doubleFormat59), this.getDegreeFormatter(doubleFormat59), cols, true);
        this.fields[0][1] = this.getFormattedTextField(this.getDegreeFormatter(doubleFormat59), this.getDegreeFormatter(doubleFormat59), cols, true);
        this.fields[1][0] = this.getFormattedTextField(doubleFormat39, cols);
        this.fields[1][1] = this.getFormattedTextField(doubleFormat39, cols);
        if (this.hasHeight) {
            this.fields[0][2] = this.getFormattedTextField(doubleFormat39, cols);
            this.fields[1][2] = this.getFormattedTextField(doubleFormat39, cols);
            this.fields[2][0] = this.getFormattedTextField(doubleFormat39, cols);
            this.fields[2][1] = this.getFormattedTextField(doubleFormat39, cols);
            this.fields[2][2] = this.getFormattedTextField(doubleFormat39, cols);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        int i = 0;
        while (i < this.fields.length) {
            this.selectedCoordinateBlockRBs[i] = new JRadioButton("", false);
            buttonGroup.add(this.selectedCoordinateBlockRBs[i]);
            int j = 0;
            while (j < this.fields[i].length) {
                this.fields[i][j].addFocusListener(this.listener);
                this.fields[i][j].setActionCommand(String.valueOf(i));
                ++j;
            }
            ++i;
        }
        this.latitudeRefSoldnerJFT = this.getFormattedTextField(this.getDegreeFormatter(doubleFormat59), this.getDegreeFormatter(doubleFormat59), 4, true);
        this.latitudeRefSoldnerJFT.setEditable(false);
        this.latitudeRefSoldnerJFT.setVisible(true);
        this.longitudeRefGKUTMJFT = this.getFormattedTextField(this.getDegreeFormatter(intFormat), this.getDegreeFormatter(intFormat), 4, true);
        this.longitudeRefGKUTMJFT.setEditable(true);
        this.longitudeRefGKUTMJFT.setVisible(true);
        this.longitudeRefSoldnerJFT = this.getFormattedTextField(this.getDegreeFormatter(doubleFormat59), this.getDegreeFormatter(doubleFormat59), 4, true);
        this.longitudeRefSoldnerJFT.setEditable(true);
        this.longitudeRefSoldnerJFT.setVisible(false);
        if (this.isEditable) {
            this.add((Component)new JLabel("<html>\u03bb<small>0</small> [\u00b0]:</html>"), "7,0");
            this.add((Component)this.longitudeRefGKUTMJFT, "9,0");
            this.add((Component)this.longitudeRefSoldnerJFT, "9,0");
            this.add((Component)this.warnIconLabel, "11,0");
            this.add((Component)new JLabel("<html>\u03c6<small>0</small> [\u00b0]:</html>"), "7,2");
            this.add((Component)this.latitudeRefSoldnerJFT, "9,2");
        } else {
            this.add((Component)new JLabel("<html>\u03bb<small>0</small> [\u00b0]:</html>"), "5,0");
            this.add((Component)this.longitudeRefGKUTMJFT, "7,0");
            this.add((Component)this.longitudeRefSoldnerJFT, "7,0");
            this.add((Component)this.warnIconLabel, "9,0");
            this.add((Component)new JLabel("<html>\u03c6<small>0</small> [\u00b0]:</html>"), "5,2");
            this.add((Component)this.latitudeRefSoldnerJFT, "7,2");
        }
        i = 0;
        int row = 0;
        int incRow = this.hasHeight ? 4 : 2;
        while (i < this.fields.length) {
            if (this.isEditable) {
                this.add((Component)this.selectedCoordinateBlockRBs[i], "1," + row + ",1," + (row + incRow));
            }
            int j = 0;
            int col = this.isEditable ? 3 : 1;
            while (j < this.fields[i].length) {
                this.add((Component)new JLabel(this.labels[i][j]), col + "," + row);
                this.add((Component)this.fields[i][j], col + 2 + "," + row);
                ++j;
                row += 2;
            }
            ++i;
        }
    }

    private JFormattedTextField getFormattedTextField(NumberFormatter display, NumberFormatter edit, int cols, boolean containsGeographicCoordinates) {
        JFormattedTextField jft = new JFormattedTextField(new DefaultFormatterFactory(display, edit)){
            private static final long serialVersionUID = -7424783936731406142L;

            @Override
            protected void processFocusEvent(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (e.getID() == 1005 && (this.getText() == null || this.getText().trim().isEmpty())) {
                    this.setValue(null);
                }
                super.processFocusEvent(e);
            }
        };
        if (containsGeographicCoordinates) {
            jft.setInputVerifier(new GeographicCoordinateFormattedTextFieldVerifier(true));
        } else {
            jft.setInputVerifier(new NumberValueFormattedTextFieldVerifier(true));
        }
        jft.setFocusLostBehavior(1);
        jft.setHorizontalAlignment(4);
        jft.setColumns(cols);
        jft.setEditable(this.isEditable);
        return jft;
    }

    private NumberFormat getIntegerNumberDisplayFormat() {
        NumberFormat intFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        intFormat.setMinimumFractionDigits(0);
        intFormat.setMaximumFractionDigits(0);
        intFormat.setMinimumIntegerDigits(1);
        intFormat.setGroupingUsed(false);
        return intFormat;
    }

    private NumberFormat getDoubleNumberDisplayFormat(int minDig, int maxDig) {
        NumberFormat doubleFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        doubleFormat.setMinimumFractionDigits(minDig);
        doubleFormat.setMaximumFractionDigits(maxDig >= 0 ? maxDig : Integer.MAX_VALUE);
        doubleFormat.setMinimumIntegerDigits(1);
        doubleFormat.setGroupingUsed(false);
        return doubleFormat;
    }

    private JFormattedTextField getFormattedTextField(NumberFormat format, int cols) {
        JFormattedTextField jft = new JFormattedTextField(format){
            private static final long serialVersionUID = 1664905922027529040L;

            @Override
            protected void processFocusEvent(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (e.getID() == 1005 && (this.getText() == null || this.getText().isEmpty())) {
                    this.setValue(null);
                }
                super.processFocusEvent(e);
            }
        };
        jft.setInputVerifier(new NumberValueFormattedTextFieldVerifier(true));
        jft.setFocusLostBehavior(1);
        jft.setHorizontalAlignment(4);
        jft.setColumns(cols);
        jft.setEditable(this.isEditable);
        return jft;
    }

    private NumberFormatter getDegreeFormatter(NumberFormat format) {
        return new NumberFormatter(format){
            private static final long serialVersionUID = 1L;

            @Override
            public String valueToString(Object o) throws ParseException {
                Number number = (Number)o;
                if (number != null) {
                    double d = number.doubleValue() * 57.29577951308232;
                    number = d;
                }
                return super.valueToString(number);
            }

            @Override
            public Object stringToValue(String s) throws ParseException {
                Number number = (Number)super.stringToValue(s);
                if (number != null) {
                    double d = number.doubleValue() * (Math.PI / 180);
                    number = d;
                }
                return number;
            }
        };
    }

    private double[] getCoordinates(int row) {
        double[] coords = new double[3];
        int i = 0;
        while (i < this.fields[row].length) {
            Object value = this.fields[row][i].getValue();
            if (row != 2 && i == 2 && (value == null || value.toString().trim().isEmpty())) {
                value = 0;
            }
            coords[i] = ((Number)value).doubleValue();
            ++i;
        }
        return coords;
    }

    public PointLatLonH getLatLonCoords() {
        if (!this.isLatLonCoordsSubmission(true)) {
            return null;
        }
        double[] coords = this.getCoordinates(0);
        return new PointLatLonH(coords[1], coords[0], coords[2]);
    }

    public PointENH getEastNorthCoords() {
        if (!this.isEastNorthCoordsSubmission(true)) {
            return null;
        }
        double[] coords = this.getCoordinates(1);
        return new PointENH(coords[0], coords[1], coords[2]);
    }

    public PointXYZ getXYZCoords() {
        if (!this.isXYZCoordsSubmission(true)) {
            return null;
        }
        double[] coords = this.getCoordinates(2);
        return new PointXYZ(coords[0], coords[1], coords[2]);
    }

    public void setLatLonCoords(PointLatLonH pointBLh) {
        this.fields[0][0].setValue(pointBLh.getLongitude());
        this.fields[0][1].setValue(pointBLh.getLatitude());
        if (this.hasHeight) {
            this.fields[0][2].setValue(pointBLh.getHeight());
        }
    }

    public void setEastNorthCoords(PointENH pointENh) {
        this.fields[1][0].setValue(pointENh.getY());
        this.fields[1][1].setValue(pointENh.getX());
        if (this.hasHeight) {
            this.fields[1][2].setValue(pointENh.getHeight());
        }
    }

    public void setXYZCoords(PointXYZ pointXYZ) {
        this.fields[2][0].setValue(pointXYZ.getX());
        this.fields[2][1].setValue(pointXYZ.getY());
        this.fields[2][2].setValue(pointXYZ.getZ());
    }

    public double getReferenceLongitude() {
        return this.longitudeRefGKUTMJFT.isVisible() ? ((Number)this.longitudeRefGKUTMJFT.getValue()).doubleValue() : (this.longitudeRefSoldnerJFT.isVisible() ? ((Number)this.longitudeRefSoldnerJFT.getValue()).doubleValue() : 0.0);
    }

    public double getReferenceLatitude() {
        return ((Number)this.latitudeRefSoldnerJFT.getValue()).doubleValue();
    }

    public boolean isLatLonCoordsSubmission(boolean regardsNumericalInput) {
        int row = 0;
        if (!regardsNumericalInput) {
            return this.selectedCoordinateBlockRBs[row].isSelected();
        }
        if (this.selectedCoordinateBlockRBs[row].isSelected()) {
            int i = 0;
            while (i < 2) {
                Object value = this.fields[row][i].getValue();
                if (value == null || value.toString().trim().isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isEastNorthCoordsSubmission(boolean regardsNumericalInput) {
        int row = 1;
        if (!regardsNumericalInput) {
            return this.selectedCoordinateBlockRBs[row].isSelected();
        }
        if (this.selectedCoordinateBlockRBs[row].isSelected()) {
            int i = 0;
            while (i < 2) {
                Object value = this.fields[row][i].getValue();
                if (value == null || value.toString().trim().isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isXYZCoordsSubmission(boolean regardsNumericalInput) {
        int row = 2;
        if (row >= this.selectedCoordinateBlockRBs.length) {
            return false;
        }
        if (!regardsNumericalInput) {
            return this.selectedCoordinateBlockRBs[row].isSelected();
        }
        if (this.selectedCoordinateBlockRBs[row].isSelected()) {
            int i = 0;
            while (i < 3) {
                Object value = this.fields[row][i].getValue();
                if (value == null || value.toString().trim().isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean hasReferenceLongitude() {
        return this.longitudeRefGKUTMJFT.isVisible() && this.longitudeRefGKUTMJFT.getValue() != null && !this.longitudeRefGKUTMJFT.toString().trim().isEmpty() || this.longitudeRefSoldnerJFT.isVisible() && this.longitudeRefSoldnerJFT.getValue() != null && !this.longitudeRefSoldnerJFT.toString().trim().isEmpty();
    }

    public boolean hasReferenceLongitudeAndLatitude() {
        return this.longitudeRefSoldnerJFT.isVisible() && this.longitudeRefSoldnerJFT.getValue() != null && !this.longitudeRefSoldnerJFT.toString().trim().isEmpty() && this.latitudeRefSoldnerJFT.getValue() != null && !this.latitudeRefSoldnerJFT.toString().trim().isEmpty();
    }

    public void displayWarningMessage(String msg) {
        this.warnIconLabel.setIcon(msg == null || msg.trim().isEmpty() ? null : this.warnIcon);
        this.warnIconLabel.setToolTipText(msg == null || msg.trim().isEmpty() ? "" : msg);
    }

    @Override
    public void projectionChanged(ProjectionChangedEvent event) {
        if (event.getSource() != null) {
            ProjectionType type = event.getSource().getSelectedItem();
            this.latitudeRefSoldnerJFT.setEditable(type == ProjectionType.SOLDNER);
            this.longitudeRefSoldnerJFT.setVisible(type == ProjectionType.SOLDNER);
            this.longitudeRefGKUTMJFT.setVisible(type != ProjectionType.SOLDNER);
            this.longitudeRefGKUTMJFT.setEditable(type != ProjectionType.MGI_M28 && type != ProjectionType.MGI_M31 && type != ProjectionType.MGI_M34);
            this.latitudeRefSoldnerJFT.setText("");
            this.longitudeRefSoldnerJFT.setText("");
            this.longitudeRefGKUTMJFT.setText("");
            this.latitudeRefSoldnerJFT.setValue(null);
            this.longitudeRefSoldnerJFT.setValue(null);
            this.longitudeRefGKUTMJFT.setValue(null);
        }
    }

    private class SelectedCoordinatePanel
    implements FocusListener {
        private SelectedCoordinatePanel() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (evt.getSource() instanceof JFormattedTextField) {
                JFormattedTextField tf = (JFormattedTextField)evt.getSource();
                int i = 0;
                while (i < CoordinatePanel.this.fields.length) {
                    int j = 0;
                    while (j < CoordinatePanel.this.fields[i].length) {
                        if (CoordinatePanel.this.fields[i][j] == tf) {
                            CoordinatePanel.this.selectedCoordinateBlockRBs[i].setSelected(true);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }
    }
}

