/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.geotra.gui.GeoTra;
import com.derletztekick.geodesy.geotra.gui.button.IconButton;
import com.derletztekick.tools.io.FileChooser;
import com.derletztekick.tools.io.filter.DefaultFileFilter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BatchFilePanel
extends JPanel {
    private static final long serialVersionUID = 4275242182035710319L;
    private JTextField path2FileTF = new JTextField("");
    private JButton searchPathJB;
    private FileChooser fileChooser;
    private final boolean isReadOnlyFileDialog;

    public BatchFilePanel(FileChooser fileChooser, boolean isReadOnlyFileDialog) {
        this.isReadOnlyFileDialog = isReadOnlyFileDialog;
        this.fileChooser = fileChooser;
        double[][] size = new double[][]{{-1.0, -2.0, 3.0, -2.0, -1.0}, {-2.0}};
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.init();
    }

    private void init() {
        try {
            String path = "/com/derletztekick/geodesy/geotra/gui/icon/";
            ImageIcon icon = new ImageIcon(this.getClass().getResource(path + (this.isReadOnlyFileDialog ? "folder.png" : "disc.png")));
            ImageIcon iconHovered = new ImageIcon(this.getClass().getResource(path + (this.isReadOnlyFileDialog ? "folder_hover.png" : "disc_hover.png")));
            this.searchPathJB = new IconButton(icon, iconHovered);
        }
        catch (Exception e) {
            this.searchPathJB = new JButton("Browse");
        }
        this.searchPathJB.addActionListener(new FileChooserActionListener());
        this.path2FileTF.setColumns(14);
        this.add((Component)this.path2FileTF, "1,0");
        this.add((Component)this.searchPathJB, "3,0");
    }

    private File openSingleFileDialog(DefaultFileFilter filter, int dialog) {
        this.fileChooser.removeAllChoosableFileFilters();
        if (filter != null) {
            this.fileChooser.addChoosableFileFilter(filter);
        }
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setSelectedFile(new File(this.path2FileTF.getText()));
        if (dialog == 0 && this.fileChooser.showOpenDialog(null) == 0) {
            return this.fileChooser.getSelectedFile();
        }
        if (dialog == 1) {
            boolean stopLoop = false;
            File selectedFile = null;
            do {
                selectedFile = null;
                if (this.fileChooser.showSaveDialog(null) == 0) {
                    selectedFile = this.fileChooser.getSelectedFile();
                    if (filter != null && !filter.accept(selectedFile)) {
                        selectedFile = new File(String.valueOf(selectedFile) + filter.getDefaultExtension());
                        this.fileChooser.setSelectedFile(selectedFile);
                    }
                    int overwriteFile = -1;
                    if (!selectedFile.exists() || selectedFile.exists() && (overwriteFile = JOptionPane.showConfirmDialog(this.getParent(), GeoTra.BABEL.getString(this.getClass().getSimpleName(), "msg.fileExistBody"), GeoTra.BABEL.getString(this.getClass().getSimpleName(), "msg.fileExistTitle"), 1)) == 0) {
                        stopLoop = true;
                        break;
                    }
                    if (overwriteFile == 2 || overwriteFile != 1) continue;
                    return null;
                }
                return null;
            } while (!stopLoop);
            return selectedFile;
        }
        return null;
    }

    public File getFile() {
        String str = this.path2FileTF.getText();
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        return new File(str.trim());
    }

    private class FileChooserActionListener
    implements ActionListener {
        private FileChooserActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            File f;
            if (evt.getSource() == BatchFilePanel.this.searchPathJB && (f = BatchFilePanel.this.openSingleFileDialog(new DefaultFileFilter(), BatchFilePanel.this.isReadOnlyFileDialog ? 0 : 1)) != null) {
                BatchFilePanel.this.path2FileTF.setText(f.getAbsolutePath());
            }
        }
    }
}

