/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.panel;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.transformation.HomologuePointSet;
import com.derletztekick.geodesy.earth.transformation.TransformationType;
import com.derletztekick.geodesy.earth.transformation.Transformator;
import com.derletztekick.geodesy.geotra.gui.GeoTra;
import com.derletztekick.geodesy.geotra.gui.combobox.DistanceWeightingExponentComboBox;
import com.derletztekick.geodesy.geotra.gui.combobox.FileComboBox;
import com.derletztekick.geodesy.geotra.gui.panel.BasePointsSystemPanel;
import com.derletztekick.geodesy.geotra.gui.panel.BatchFilePanel;
import com.derletztekick.geodesy.geotra.gui.panel.CoordinatePanel;
import com.derletztekick.geodesy.geotra.io.BasePointsFileReader;
import com.derletztekick.geodesy.geotra.io.CoordinateType;
import com.derletztekick.geodesy.geotra.io.DualPointFileReaderAndWriter;
import com.derletztekick.tools.io.FileChooser;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class BasePointsTransformationSettingPanel
extends JPanel {
    private static final long serialVersionUID = 8499874926690297875L;
    private static final String PATH2GRIDS = "NTv2/";
    private FileComboBox fileComboBox;
    private File lastSelectedBasePointFile = null;
    private DistanceWeightingExponentComboBox distanceWeightingExponentComboBox = new DistanceWeightingExponentComboBox();
    private BasePointsSystemPanel srcSystemPanel = new BasePointsSystemPanel();
    private BasePointsSystemPanel trgSystemPanel = new BasePointsSystemPanel();
    private Map<String, PointENH> basePoints = null;
    private CoordinatePanel srcCoordPanel = new CoordinatePanel(true, false);
    private CoordinatePanel trgCoordPanel = new CoordinatePanel(false, false);
    private FileChooser fileChooser = new FileChooser(this);
    private BatchFilePanel srcBatchFilePanel = new BatchFilePanel(this.fileChooser, true);
    private BatchFilePanel trgBatchFilePanel = new BatchFilePanel(this.fileChooser, false);
    private JRadioButton helmert2dRB;
    private JRadioButton affin2dRB;

    public BasePointsTransformationSettingPanel() {
        double[][] size = new double[][]{{-1.0, -2.0, 10.0, -2.0, -1.0}, {-2.0, 5.0, -2.0, 10.0, -2.0, 15.0, -2.0, 15.0, -2.0, 15.0, -2.0}};
        TableLayout contentPaneLayout = new TableLayout(size);
        this.setLayout(contentPaneLayout);
        this.initComponents();
    }

    private void initComponents() {
        BaseFileActionListener bfal = new BaseFileActionListener();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        File[] files = this.getBasePointsFiles();
        if (files == null || files.length == 0) {
            JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.noBasePointsDirBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.noBasePointsDirTitle"), 0);
        }
        this.fileComboBox = new FileComboBox(files);
        this.srcSystemPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.system")));
        this.trgSystemPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.system")));
        this.srcCoordPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.coords")));
        this.trgCoordPanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.coords")));
        this.srcBatchFilePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.src.batch")));
        this.trgBatchFilePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, GeoTra.BABEL.getString("TransformationSettingPanel", "border.trg.batch")));
        this.helmert2dRB = new JRadioButton(GeoTra.BABEL.getString("TransformationSettingPanel", "transformation.helmert2d"), false);
        this.affin2dRB = new JRadioButton(GeoTra.BABEL.getString("TransformationSettingPanel", "transformation.affin2d"), true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.helmert2dRB);
        bg.add(this.affin2dRB);
        JPanel transformationTypePanel = new JPanel(new FlowLayout(0, 10, 0));
        transformationTypePanel.add(this.helmert2dRB);
        transformationTypePanel.add(this.affin2dRB);
        this.setBasePoints(this.getBasePointsFromFile());
        this.distanceWeightingExponentComboBox.setSelectedItem(2.0);
        JPanel distanceWeightSchemePanel = new JPanel(new FlowLayout(2, 10, 0));
        distanceWeightSchemePanel.add(new JLabel(GeoTra.BABEL.getString("TransformationSettingPanel", "transformation.inversedistanceweighting")));
        distanceWeightSchemePanel.add(this.distanceWeightingExponentComboBox);
        this.add((Component)this.fileComboBox, "1,0");
        this.add((Component)distanceWeightSchemePanel, "3,0");
        this.add((Component)transformationTypePanel, "1,2,3,2");
        this.add((Component)this.srcSystemPanel, "1,4,3,4");
        this.add((Component)this.trgSystemPanel, "1,6,3,6");
        this.add((Component)this.srcCoordPanel, "1,8");
        this.add((Component)this.trgCoordPanel, "3,8");
        this.add((Component)this.srcBatchFilePanel, "1,10");
        this.add((Component)this.trgBatchFilePanel, "3,10");
        this.fileComboBox.setActionCommand("FILE");
        this.fileComboBox.addActionListener(bfal);
        this.srcSystemPanel.addProjectionChangedListener(this.srcCoordPanel);
        this.trgSystemPanel.addProjectionChangedListener(this.trgCoordPanel);
    }

    private void resetWarningMessages() {
        this.srcCoordPanel.displayWarningMessage(null);
        this.trgCoordPanel.displayWarningMessage(null);
    }

    private void setBasePoints(Map<String, PointENH> basePoints) {
        if (basePoints == null || basePoints.size() == 0) {
            return;
        }
        this.basePoints = basePoints;
        this.srcSystemPanel.setGeodeticDatum(GeodeticDatumType.DHDN);
        this.trgSystemPanel.setGeodeticDatum(GeodeticDatumType.ETRS89);
    }

    private File[] getBasePointsFiles() {
        URL url = this.getClass().getClassLoader().getResource(PATH2GRIDS);
        if (url == null) {
            return new File[0];
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String name = entry.getFileName().toString().toLowerCase();
                return !name.matches("(?i)readme\\.txt$") && name.matches("(?i).+\\.txt$");
            }
        };
        ArrayList<File> fileList = new ArrayList<File>();
        DirectoryStream<Path> stream = null;
        try {
            try {
                Path root = Paths.get(url.toURI());
                stream = Files.newDirectoryStream(root, (DirectoryStream.Filter<? super Path>)filter);
                for (Path p : stream) {
                    if (!Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)) continue;
                    fileList.add(p.toFile());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                File[] fileArray = new File[]{};
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return fileArray;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private Map<String, PointENH> getBasePointsFromFile() {
        Map<String, PointENH> basePoints = null;
        File src = this.fileComboBox.getSelectedItem();
        if (src != null) {
            if (src == this.lastSelectedBasePointFile) {
                return null;
            }
            BasePointsFileReader reader = new BasePointsFileReader(src);
            if (reader.readSourceFile()) {
                basePoints = reader.getBasePoints();
            }
            if (basePoints == null || basePoints.isEmpty()) {
                JOptionPane.showMessageDialog(this.getParent(), String.format(Locale.ENGLISH, GeoTra.BABEL.getString("TransformationSettingPanel", "err.ioNTV2FileBody"), src.getName()), GeoTra.BABEL.getString("TransformationSettingPanel", "err.ioNTV2FileTitle"), 0);
            } else {
                this.lastSelectedBasePointFile = src;
            }
        }
        return basePoints;
    }

    public void transform() {
        this.resetWarningMessages();
        if (this.basePoints == null || this.basePoints.size() == 0) {
            return;
        }
        GeodeticDatum srcDatum = this.srcSystemPanel.getGeodeticDatum();
        GeodeticDatum trgDatum = this.trgSystemPanel.getGeodeticDatum();
        boolean hasSrcRefLonLat = this.srcCoordPanel.hasReferenceLongitudeAndLatitude();
        boolean hasTrgRefLonLat = this.trgCoordPanel.hasReferenceLongitudeAndLatitude();
        boolean hasSrcRefLon = !hasSrcRefLonLat && this.srcCoordPanel.hasReferenceLongitude();
        boolean hasTrgRefLon = !hasTrgRefLonLat && this.trgCoordPanel.hasReferenceLongitude();
        double exponentDistanceWeighting = this.distanceWeightingExponentComboBox.getSelectedItem();
        Transformator transformator = new Transformator(this.affin2dRB.isSelected(), this.basePoints, srcDatum, trgDatum, exponentDistanceWeighting);
        boolean isValidCenterMeridian = true;
        if (hasSrcRefLonLat) {
            refLonSrc = this.srcCoordPanel.getReferenceLongitude();
            double refLatSrc = this.srcCoordPanel.getReferenceLatitude();
            transformator.setReferenceLongitudeAndLatitudeSourceSystem(refLonSrc, refLatSrc);
        } else if (hasSrcRefLon) {
            boolean isValidSourceSystemCenterMeridian;
            refLonSrc = this.srcCoordPanel.getReferenceLongitude();
            transformator.setReferenceLongitudeSourceSystem(refLonSrc);
            isValidCenterMeridian = isValidSourceSystemCenterMeridian = transformator.isValidSourceSystemCenterMeridian();
            if (!isValidSourceSystemCenterMeridian) {
                this.srcCoordPanel.displayWarningMessage(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaIconTooltip"));
            }
        }
        if (hasTrgRefLonLat) {
            refLonTrg = this.trgCoordPanel.getReferenceLongitude();
            double refLatTrg = this.trgCoordPanel.getReferenceLatitude();
            transformator.setReferenceLongitudeAndLatitudeTargetSystem(refLonTrg, refLatTrg);
        } else if (hasTrgRefLon) {
            refLonTrg = this.trgCoordPanel.getReferenceLongitude();
            transformator.setReferenceLongitudeTargetSystem(refLonTrg);
            boolean isValidTargetSystemCenterMeridian = transformator.isValidTargetSystemCenterMeridian();
            boolean bl = isValidCenterMeridian = isValidCenterMeridian && isValidTargetSystemCenterMeridian;
            if (!transformator.isValidTargetSystemCenterMeridian()) {
                this.trgCoordPanel.displayWarningMessage(GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaIconTooltip"));
            }
        }
        if (!isValidCenterMeridian && JOptionPane.showConfirmDialog(this, GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.lambdaTitle"), 0) == 1) {
            return;
        }
        HomologuePointSet pointSet = null;
        boolean hasUserSubmission = true;
        if (this.srcCoordPanel.isLatLonCoordsSubmission(true)) {
            pointSet = transformator.transformLatitudeLongitudeHeight(this.srcCoordPanel.getLatLonCoords());
        } else if (this.srcCoordPanel.isEastNorthCoordsSubmission(true)) {
            pointSet = transformator.transformEastNorthHeight(this.srcCoordPanel.getEastNorthCoords());
        } else {
            hasUserSubmission = false;
        }
        if (pointSet != null) {
            this.srcCoordPanel.setEastNorthCoords(pointSet.getSourcePointEastNorthHeight());
            this.srcCoordPanel.setLatLonCoords(pointSet.getSourcePointLatitudeLongitudeHeight());
            this.trgCoordPanel.setEastNorthCoords(pointSet.getTargetPointEastNorthHeight());
            this.trgCoordPanel.setLatLonCoords(pointSet.getTargetPointLatitudeLongitudeHeight());
        } else if (pointSet == null && hasUserSubmission) {
            if (transformator.getTransformationType() == TransformationType.AFFIN_2D || transformator.getTransformationType() == TransformationType.HELMERT_2D) {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoBasePointsBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoBasePointsTitle"), 0);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.trafoTitle"), 0);
            }
        }
        File srcFile = this.srcBatchFilePanel.getFile();
        File destFile = this.trgBatchFilePanel.getFile();
        if (srcFile != null && destFile != null) {
            DualPointFileReaderAndWriter dualPointFileReaderAndWriter = null;
            if (this.srcCoordPanel.isLatLonCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.LatLonHeight, srcFile, destFile);
            } else if (this.srcCoordPanel.isEastNorthCoordsSubmission(false)) {
                dualPointFileReaderAndWriter = new DualPointFileReaderAndWriter(transformator, CoordinateType.EastNorthHeight, srcFile, destFile);
            }
            if (dualPointFileReaderAndWriter == null || !dualPointFileReaderAndWriter.readSourceFile()) {
                System.err.println(this.getClass().getSimpleName() + " Fehler beim Konvertieren der Daten! " + srcFile.getName() + " --> " + destFile.getName());
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "err.batchBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "err.batchTitle"), 0);
                return;
            }
            Set<String> nonTransformedPointIds = dualPointFileReaderAndWriter.getNonTransformedPointIds();
            if (nonTransformedPointIds.size() > 0) {
                int maxNumOfPoints = Math.min(nonTransformedPointIds.size(), 35);
                StringBuffer ids = new StringBuffer("");
                int counter = 0;
                int lineSize = 0;
                for (String id : nonTransformedPointIds) {
                    if (lineSize > 40) {
                        ids.append("\n");
                        lineSize = 0;
                    }
                    ids.append(id);
                    lineSize += id.length();
                    if (counter < maxNumOfPoints - 1) {
                        ids.append(", ");
                    }
                    if (++counter < maxNumOfPoints) continue;
                    if (nonTransformedPointIds.size() - 1 < counter) break;
                    ids.append(",... ");
                    break;
                }
                JOptionPane.showMessageDialog(this.getParent(), String.format(Locale.ENGLISH, GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchBodyWithWarning"), nonTransformedPointIds.size(), ids), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchTitleWithWarning"), 2);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchBody"), GeoTra.BABEL.getString("TransformationSettingPanel", "msg.batchTitle"), 1);
            }
        }
    }

    private class BaseFileActionListener
    implements ActionListener {
        private BaseFileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equals("FILE")) {
                new Thread(){

                    @Override
                    public void run() {
                        ((BaseFileActionListener)BaseFileActionListener.this).BasePointsTransformationSettingPanel.this.srcSystemPanel.setEnabled(false);
                        ((BaseFileActionListener)BaseFileActionListener.this).BasePointsTransformationSettingPanel.this.trgSystemPanel.setEnabled(false);
                        BasePointsTransformationSettingPanel.this.setBasePoints(BasePointsTransformationSettingPanel.this.getBasePointsFromFile());
                        ((BaseFileActionListener)BaseFileActionListener.this).BasePointsTransformationSettingPanel.this.srcSystemPanel.setEnabled(true);
                        ((BaseFileActionListener)BaseFileActionListener.this).BasePointsTransformationSettingPanel.this.trgSystemPanel.setEnabled(true);
                    }
                }.start();
            }
        }
    }
}

