/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.combobox;

import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ProjectionComboBox
extends JComboBox<ProjectionType> {
    private static final long serialVersionUID = -1979434084030427573L;

    public ProjectionComboBox(JComboBox<GeodeticDatumType> datumComboBox) {
        super(ProjectionType.values());
        super.setRenderer(new DisabledItemsRenderer(datumComboBox));
    }

    public ProjectionType getSelectedItem() {
        return (ProjectionType)((Object)super.getSelectedItem());
    }

    private class DisabledItemsRenderer
    extends JLabel
    implements ListCellRenderer<ProjectionType> {
        private static final long serialVersionUID = -3249879061265545332L;
        private JComboBox<GeodeticDatumType> datumComboBox;

        public DisabledItemsRenderer(JComboBox<GeodeticDatumType> datumComboBox) {
            this.datumComboBox = datumComboBox;
            super.setOpaque(true);
        }

        private boolean isPreferedProjection(GeodeticDatumType datumType, ProjectionType projectionType) {
            if (datumType == null || projectionType == null) {
                return true;
            }
            switch (datumType) {
                case MGI_A: {
                    return projectionType == ProjectionType.MGI_M28 || projectionType == ProjectionType.MGI_M31 || projectionType == ProjectionType.MGI_M34;
                }
                case DKSBiH: {
                    return projectionType == ProjectionType.MGI_DKSBiH_GK;
                }
                case BH_ETRS89: {
                    return projectionType == ProjectionType.MGI_DKSBiH_UTM;
                }
                case DHDN: 
                case RD83: 
                case PD83: 
                case S4283: {
                    return projectionType == ProjectionType.GK_3 || projectionType == ProjectionType.GK_6 || projectionType == ProjectionType.SOLDNER;
                }
                case ETRS89: 
                case WGS84_N: 
                case WGS84_S: {
                    return projectionType == ProjectionType.UTM_N || projectionType == ProjectionType.UTM_S;
                }
            }
            return true;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ProjectionType> list, ProjectionType projectionType, int index, boolean isSelected, boolean cellHasFocus) {
            GeodeticDatumType datumType = (GeodeticDatumType)((Object)this.datumComboBox.getSelectedItem());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!this.isPreferedProjection(datumType, projectionType)) {
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            super.setText(projectionType == null ? "" : projectionType.toString());
            return this;
        }
    }
}

