/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui.combobox;

import com.derletztekick.geodesy.earth.ellipsoid.EllipsoidType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class EllipsoidComboBox
extends JComboBox<EllipsoidType> {
    private static final long serialVersionUID = 2695551388798127041L;
    private DefaultComboBoxModel<EllipsoidType> model = this.getModel();

    public EllipsoidComboBox() {
        super(new DefaultComboBoxModel<EllipsoidType>(EllipsoidType.values()));
        this.addActionListener(new EllipsoidComboBoxActionListener());
    }

    @Override
    public DefaultComboBoxModel<EllipsoidType> getModel() {
        return (DefaultComboBoxModel)super.getModel();
    }

    public EllipsoidType getSelectedItem() {
        return (EllipsoidType)((Object)super.getSelectedItem());
    }

    private class EllipsoidComboBoxActionListener
    implements ActionListener {
        private int lastSelectedIndex = -1;
        private EllipsoidType userDefinedType = EllipsoidType.USER_DEFINED;

        private EllipsoidComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getActionCommand().equalsIgnoreCase("comboBoxChanged")) {
                EllipsoidComboBox.this.setEditable(EllipsoidComboBox.this.getSelectedItem() == EllipsoidType.USER_DEFINED);
                this.lastSelectedIndex = EllipsoidComboBox.this.getSelectedIndex() < 0 ? this.lastSelectedIndex : EllipsoidComboBox.this.getSelectedIndex();
            } else if (evt.getActionCommand().equalsIgnoreCase("comboBoxEdited") && this.lastSelectedIndex >= 0) {
                this.userDefinedType.setLabel(EllipsoidComboBox.this.getSelectedItem().toString());
                EllipsoidComboBox.this.model.removeElementAt(this.lastSelectedIndex);
                EllipsoidComboBox.this.model.insertElementAt(this.userDefinedType, this.lastSelectedIndex);
                EllipsoidComboBox.this.model.setSelectedItem((Object)this.userDefinedType);
                EllipsoidComboBox.this.setEditable(EllipsoidComboBox.this.getSelectedItem() == EllipsoidType.USER_DEFINED);
            }
        }
    }
}

