/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra.gui;

import com.derletztekick.geodesy.geotra.gui.panel.BasePointsTransformationSettingPanel;
import com.derletztekick.geodesy.geotra.gui.panel.GridTransformationSettingPanel;
import com.derletztekick.geodesy.geotra.gui.panel.StrictTransformationSettingPanel;
import com.derletztekick.tools.babel.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class GeoTra
extends JFrame {
    private static final long serialVersionUID = 7455448786752145215L;
    private final String frameTitle;
    public static double VERSION = 2.1;
    public static int BUILD = 20251119;
    public static final Babel BABEL = new Babel("lang.geotra", Locale.getDefault());
    public static String ICON = "/com/derletztekick/geodesy/geotra/gui/icon/geotra.png";
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JButton processButton;
    private GridTransformationSettingPanel gridTransformationSettingPanel = new GridTransformationSettingPanel();
    private StrictTransformationSettingPanel strictTransformationSettingPanel = new StrictTransformationSettingPanel();
    private BasePointsTransformationSettingPanel basePointsTransformationSettingPanel = new BasePointsTransformationSettingPanel();

    public GeoTra() {
        this(750, 675, false);
    }

    public GeoTra(boolean isSlaveApp) {
        this(750, 675, isSlaveApp);
    }

    public GeoTra(int frameWidth, int frameHeight, boolean isSlaveApp) {
        this.frameTitle = "GeoTra - Conversion and Transformation v" + VERSION + "." + BUILD;
        super.setTitle(this.frameTitle + " - https://software.applied-geodesy.org");
        super.addWindowListener(new CloseWindowListener());
        super.setDefaultCloseOperation(isSlaveApp ? 2 : 3);
        try {
            this.setIconImage(new ImageIcon(this.getClass().getResource(ICON)).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSize(new Dimension(frameWidth, frameHeight));
        this.setMinimumSize(new Dimension((int)(0.7 * (double)frameWidth), (int)(0.7 * (double)frameHeight)));
        this.setPreferredSize(new Dimension(frameWidth, frameHeight));
        this.setLocationRelativeTo(null);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        this.tabbedPane.addTab(BABEL.getString(this.getClass().getSimpleName(), "tab.ntv2grid"), new JScrollPane(this.gridTransformationSettingPanel));
        this.tabbedPane.addTab(BABEL.getString(this.getClass().getSimpleName(), "tab.helmert3d"), new JScrollPane(this.strictTransformationSettingPanel));
        this.tabbedPane.addTab(BABEL.getString(this.getClass().getSimpleName(), "tab.basepoints"), new JScrollPane(this.basePointsTransformationSettingPanel));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.setMnemonicAt(2, 51);
        this.processButton = new JButton(BABEL.getString(this.getClass().getSimpleName(), "button.label"));
        this.processButton.addActionListener(new TransformActionListener());
        JPanel footerPane = new JPanel(new BorderLayout(25, 5));
        footerPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        footerPane.add((Component)this.processButton, "East");
        footerPane.add((Component)new JLabel("<html><p style=\"margin-bottom: 0; color: #9f9f9f;\">GeoTra \u2015 The <em>OpenSource</em> Conversion and Transformation Program</p></html>"), "Center");
        contentPane.add((Component)footerPane, "South");
        contentPane.add((Component)this.tabbedPane, "Center");
        this.setResizable(true);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void setTitle(String subTitle) {
        super.setTitle(this.frameTitle + " - " + subTitle + " - https://software.applied-geodesy.org");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GeoTra(true);
            }
        });
    }

    private class CloseWindowListener
    implements WindowListener {
        private CloseWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.out.println("Thank you for using GeoTra - Conversion and Transformation\r\nby Michael Loesler <https://software.applied-geodesy.org>");
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    private class TransformActionListener
    implements ActionListener {
        private TransformActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GeoTra.this.processButton) {
                new Thread(){

                    @Override
                    public void run() {
                        ((TransformActionListener)TransformActionListener.this).GeoTra.this.processButton.setEnabled(false);
                        if (((TransformActionListener)TransformActionListener.this).GeoTra.this.tabbedPane.getSelectedIndex() == 0) {
                            ((TransformActionListener)TransformActionListener.this).GeoTra.this.gridTransformationSettingPanel.transform();
                        } else if (((TransformActionListener)TransformActionListener.this).GeoTra.this.tabbedPane.getSelectedIndex() == 1) {
                            ((TransformActionListener)TransformActionListener.this).GeoTra.this.strictTransformationSettingPanel.transform();
                        } else if (((TransformActionListener)TransformActionListener.this).GeoTra.this.tabbedPane.getSelectedIndex() == 2) {
                            ((TransformActionListener)TransformActionListener.this).GeoTra.this.basePointsTransformationSettingPanel.transform();
                        }
                        ((TransformActionListener)TransformActionListener.this).GeoTra.this.processButton.setEnabled(true);
                    }
                }.start();
            }
        }
    }
}

