/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.projection.MapProjection;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.earth.transformation.Transformator;
import com.derletztekick.geodesy.geotra.io.CoordinateType;
import com.derletztekick.geodesy.geotra.io.DualPointFileReaderAndWriter;
import com.derletztekick.geodesy.geotra.io.nt.NTGSAReader;
import com.derletztekick.geodesy.geotra.io.nt.NTGSBReader;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTReader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class GeoTraBatchShell {
    private Map<String, String> arguments = new HashMap<String, String>(15);

    public GeoTraBatchShell(String[] args) {
        File destFile;
        File srcFile;
        DualPointFileReaderAndWriter io;
        int refLon;
        if (args == null || args.length == 0) {
            System.err.println("No ARGUMENTS!");
            System.exit(-1);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.length() > 5 && arg.charAt(0) == '-') {
                this.arguments.put(arg.substring(0, 5), arg.substring(5));
            }
            ++n2;
        }
        if (!(this.arguments.containsKey("-type") && this.arguments.containsKey("-coor") && this.arguments.containsKey("-srcf") && this.arguments.containsKey("-trgf"))) {
            System.err.println("MISSING ARGUMENTS: -type, -coor, srcf and/or -trgf!");
            System.exit(-1);
        }
        Transformator transformator = null;
        boolean isNTV2Transformation = true;
        if (this.arguments.get("-type").equalsIgnoreCase("ntv2")) {
            transformator = this.createNTv2Transformator();
            isNTV2Transformation = true;
        } else if (this.arguments.get("-type").equalsIgnoreCase("helmert")) {
            transformator = this.createHelmertTransformator();
            isNTV2Transformation = false;
        }
        if (transformator == null) {
            System.err.println("TRANSFORMATOR NOT INITIALISED!");
            System.exit(-1);
        }
        if (this.arguments.containsKey("-srcl") && this.arguments.get("-srcl").matches("\\d+")) {
            refLon = Integer.parseInt(this.arguments.get("-srcl"), 10);
            transformator.setReferenceLongitudeSourceSystem((double)refLon * (Math.PI / 180));
        }
        if (this.arguments.containsKey("-trgl") && this.arguments.get("-trgl").matches("\\d+")) {
            refLon = Integer.parseInt(this.arguments.get("-trgl"), 10);
            transformator.setReferenceLongitudeTargetSystem((double)refLon * (Math.PI / 180));
        }
        CoordinateType submissionType = null;
        if (this.arguments.get("-coor").equalsIgnoreCase("EN")) {
            submissionType = CoordinateType.EastNorthHeight;
        } else if (this.arguments.get("-coor").equalsIgnoreCase("BL")) {
            submissionType = CoordinateType.LatLonHeight;
        } else if (!isNTV2Transformation && this.arguments.get("-coor").equalsIgnoreCase("XYZ")) {
            submissionType = CoordinateType.XYZ;
        }
        if (submissionType == null) {
            System.err.println("INVALID COORDINATE TYPE!");
            System.exit(-1);
        }
        if (!(io = new DualPointFileReaderAndWriter(transformator, submissionType, srcFile = new File(this.arguments.get("-srcf")), destFile = new File(this.arguments.get("-trgf")))).readSourceFile()) {
            System.err.println("I/O ERROR DURING TRANSFORMATION PROCESS!");
            System.exit(-1);
        }
    }

    private NTGrid[] getGridFromFile(File file) {
        NTGrid[] grids = null;
        if (file != null) {
            try {
                NTReader reader = file.getName().matches("(?i).+\\.gsb$") ? new NTGSBReader() : new NTGSAReader();
                grids = reader.read(file);
            }
            catch (Exception e) {
                grids = null;
                e.printStackTrace();
            }
        }
        return grids;
    }

    private Transformator createNTv2Transformator() {
        Ellipsoid ellipsoid;
        NTGrid[] grids;
        if (!(this.arguments.containsKey("-grid") && this.arguments.containsKey("-srcd") && this.arguments.containsKey("-trgd"))) {
            System.err.println("MISSING ARGUMENTS: -grid, -srcd and/or -trgd!");
            System.exit(-1);
        }
        if ((grids = this.getGridFromFile(new File(this.arguments.get("-grid")))) == null || grids.length == 0) {
            System.err.println("NOT A VALID NTv2-GRID-FILE!");
            System.exit(-1);
        }
        NTGrid subgrid = grids[0];
        GeodeticDatum trgDatumNTv2 = subgrid.getTargetDatum();
        GeodeticDatum srcDatumNTv2 = subgrid.getSourceDatum();
        GeodeticDatumType srcDatumType = GeodeticDatumType.valueByName(this.arguments.get("-srcd"));
        GeodeticDatumType trgDatumType = GeodeticDatumType.valueByName(this.arguments.get("-trgd"));
        if (srcDatumNTv2.getType() == trgDatumType && trgDatumNTv2.getType() == srcDatumType) {
            GeodeticDatum tmp = srcDatumNTv2;
            srcDatumNTv2 = trgDatumNTv2;
            trgDatumNTv2 = tmp;
        }
        if (this.arguments.containsKey("-srcp")) {
            ellipsoid = srcDatumNTv2.getProjection().getEllipsoid();
            if (this.arguments.get("-srcp").equalsIgnoreCase("GK3")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.GK_3));
            } else if (this.arguments.get("-srcp").equalsIgnoreCase("GK6")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.GK_6));
            } else if (this.arguments.get("-srcp").equalsIgnoreCase("UTMN")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.UTM_N));
            } else if (this.arguments.get("-srcp").equalsIgnoreCase("UTMS")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.UTM_S));
            } else if (this.arguments.get("-srcp").equalsIgnoreCase("SOLDNER")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.SOLDNER));
            } else if (this.arguments.get("-srcp").equalsIgnoreCase("DKSBIH")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.MGI_DKSBiH_GK));
            } else if (this.arguments.get("-srcp").equalsIgnoreCase("BH_ETRS89")) {
                srcDatumNTv2 = new GeodeticDatum(srcDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.MGI_DKSBiH_UTM));
            } else {
                System.err.println("UNKWNON PROJECTION!");
                System.exit(-1);
            }
        }
        if (this.arguments.containsKey("-trgp")) {
            ellipsoid = trgDatumNTv2.getProjection().getEllipsoid();
            if (this.arguments.get("-trgp").equalsIgnoreCase("GK3")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.GK_3));
            } else if (this.arguments.get("-trgp").equalsIgnoreCase("GK6")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.GK_6));
            } else if (this.arguments.get("-trgp").equalsIgnoreCase("UTMN")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.UTM_N));
            } else if (this.arguments.get("-trgp").equalsIgnoreCase("UTMS")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.UTM_S));
            } else if (this.arguments.get("-trgp").equalsIgnoreCase("SOLDNER")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.SOLDNER));
            } else if (this.arguments.get("-trgp").equalsIgnoreCase("DKSBIH")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.MGI_DKSBiH_GK));
            } else if (this.arguments.get("-trgp").equalsIgnoreCase("BH_ETRS89")) {
                trgDatumNTv2 = new GeodeticDatum(trgDatumNTv2.getType(), new MapProjection(ellipsoid, ProjectionType.MGI_DKSBiH_UTM));
            } else {
                System.err.println("UNKWNON PROJECTION!");
                System.exit(-1);
            }
        }
        srcDatumNTv2.getProjection().useApproximation(false);
        trgDatumNTv2.getProjection().useApproximation(false);
        return new Transformator(grids, srcDatumNTv2, trgDatumNTv2, true);
    }

    private Transformator createHelmertTransformator() {
        double m;
        double rz;
        double ry;
        double rx;
        double tz;
        double ty;
        double tx;
        if (!(this.arguments.containsKey("-srcd") && this.arguments.containsKey("-trgd") && this.arguments.containsKey("-srcx") && this.arguments.containsKey("-srcy") && this.arguments.containsKey("-srcz") && this.arguments.containsKey("-trgx") && this.arguments.containsKey("-trgy") && this.arguments.containsKey("-trgz") && this.arguments.containsKey("-srca") && this.arguments.containsKey("-srcb") && this.arguments.containsKey("-srcg") && this.arguments.containsKey("-trga") && this.arguments.containsKey("-trgb") && this.arguments.containsKey("-trgg") && this.arguments.containsKey("-srcs") && this.arguments.containsKey("-trgs"))) {
            System.err.println("MISSING ARGUMENTS: -srcx, -srcy, -srcz, -srcs, -srca, -srcb, -srcg, -trgx, -trgy, -trgz, -trgs, -trga, -trgb, -trgg-srcd and/or -trgd!");
            System.exit(-1);
        }
        GeodeticDatumType srcDatumType = GeodeticDatumType.valueByName(this.arguments.get("-srcd"));
        GeodeticDatumType trgDatumType = GeodeticDatumType.valueByName(this.arguments.get("-trgd"));
        if (srcDatumType == null || trgDatumType == null) {
            return null;
        }
        GeodeticDatum srcGeodeticDatum = null;
        GeodeticDatum trgGeodeticDatum = null;
        try {
            tx = Double.parseDouble(this.arguments.get("-srcx"));
            ty = Double.parseDouble(this.arguments.get("-srcy"));
            tz = Double.parseDouble(this.arguments.get("-srcz"));
            rx = Double.parseDouble(this.arguments.get("-srca"));
            ry = Double.parseDouble(this.arguments.get("-srcb"));
            rz = Double.parseDouble(this.arguments.get("-srcg"));
            m = Double.parseDouble(this.arguments.get("-srcs"));
            srcGeodeticDatum = new GeodeticDatum(srcDatumType, tx, ty, tz, m, rx, ry, rz);
        }
        catch (Exception e) {
            return null;
        }
        try {
            tx = Double.parseDouble(this.arguments.get("-trgx"));
            ty = Double.parseDouble(this.arguments.get("-trgy"));
            tz = Double.parseDouble(this.arguments.get("-trgz"));
            rx = Double.parseDouble(this.arguments.get("-trga"));
            ry = Double.parseDouble(this.arguments.get("-trgb"));
            rz = Double.parseDouble(this.arguments.get("-trgg"));
            m = Double.parseDouble(this.arguments.get("-trgs"));
            trgGeodeticDatum = new GeodeticDatum(srcDatumType, tx, ty, tz, m, rx, ry, rz);
        }
        catch (Exception e) {
            return null;
        }
        if (srcGeodeticDatum != null && trgGeodeticDatum != null) {
            return new Transformator(srcGeodeticDatum, trgGeodeticDatum);
        }
        return null;
    }

    public static void main(String[] args) {
        new GeoTraBatchShell(args);
    }
}

