/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.geotra;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.datum.GeodeticDatumType;
import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.ellipsoid.EllipsoidType;
import com.derletztekick.geodesy.earth.point.PointXYZ;
import com.derletztekick.geodesy.earth.projection.MapProjection;
import com.derletztekick.geodesy.earth.projection.ProjectionType;
import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.geodesy.earth.transformation.HomologuePointSet;
import com.derletztekick.geodesy.earth.transformation.Transformator;
import com.derletztekick.geodesy.geotra.io.nt.NTGSAReader;
import com.derletztekick.geodesy.geotra.io.nt.NTGSBReader;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import com.derletztekick.geodesy.geotra.io.nt.NTReader;
import java.io.File;

public class GeoTra {
    private static NTGrid[] getGridFromFile(File file) {
        NTGrid[] grids = null;
        if (file != null) {
            try {
                NTReader reader = file.getName().matches("(?i).+\\.gsb$") ? new NTGSBReader() : new NTGSAReader();
                grids = reader.read(file);
            }
            catch (Exception e) {
                grids = null;
                e.printStackTrace();
            }
        }
        return grids;
    }

    public static void main(String[] args) {
        GeodeticDatum srcDatum = new GeodeticDatum(GeodeticDatumType.DHDN);
        GeodeticDatum trgDatum = new GeodeticDatum(GeodeticDatumType.ETRS89);
        System.out.println("\nPunkt in verebneten y/x-Koordinaten im Ausgangssystem");
        PointENH pEN_SRC = new PointENH(3439006.021, 5826642.388, 157.02);
        System.out.println(pEN_SRC);
        System.out.println("\nPunkt in Laenge und Breite im Ausgangssystem");
        PointLatLonH pBL_SRC = srcDatum.getProjection().EastNorth2LatLon(pEN_SRC);
        System.out.println(pBL_SRC.getLatitude() * 57.29577951308232 + "  " + pBL_SRC.getLongitude() * 57.29577951308232 + "  " + pBL_SRC.getHeight());
        System.out.println("\nPunkt in geoz. Koordinaten im Ausgangssystem");
        PointXYZ pXYZ_SRC = srcDatum.getProjection().getEllipsoid().LatLonH2XYZ(pBL_SRC);
        System.out.println(pXYZ_SRC);
        System.out.println("\nPunkt in geoz. Koordinaten im WGS84");
        PointXYZ pXYZ_WGS84 = srcDatum.getTransformationFromLocalToWGS84().transform(pXYZ_SRC);
        System.out.println(pXYZ_WGS84);
        System.out.println("\nPunkt in geoz. Koordinaten im Zielsystem");
        PointXYZ pXYZ_TRG = trgDatum.getTransformationFromLocalToWGS84().invTransform(pXYZ_WGS84);
        System.out.println(pXYZ_TRG);
        System.out.println("\nPunkt in Laenge und Breite im Zielsystem");
        PointLatLonH pBL_TRG = trgDatum.getProjection().getEllipsoid().XYZ2LatLonH(pXYZ_TRG);
        System.out.println(pBL_TRG.getLatitude() * 57.29577951308232 + "  " + pBL_TRG.getLongitude() * 57.29577951308232 + "  " + pBL_TRG.getHeight());
        System.out.println("\nPunkt in verebneten y/x-Koordinaten im Zielsystem");
        PointENH pEN_TRG = trgDatum.getProjection().LatLon2EastNorth(pBL_TRG);
        System.out.println(pEN_TRG);
        NTGrid[] grids = GeoTra.getGridFromFile(new File("NTv2/BETA2007.gsa"));
        if (grids == null || grids.length == 0) {
            System.err.println("Kein NTV2-Grid vorhanden!");
            return;
        }
        NTGrid subgrid = grids[0];
        GeodeticDatum trgDatumNTv2 = subgrid.getTargetDatum();
        GeodeticDatum srcDatumNTv2 = subgrid.getSourceDatum();
        PointENH pEN = new PointENH(3439006.021, 5826642.388, 0.0);
        Transformator transformator = new Transformator(grids, srcDatumNTv2, trgDatumNTv2, true);
        HomologuePointSet pointSet = transformator.transformEastNorthHeight(pEN);
        System.out.println(pointSet.getTargetPointEastNorthHeight());
        MapProjection srcProjMGI = new MapProjection(new Ellipsoid(EllipsoidType.BESSEL), ProjectionType.MGI_M34);
        PointLatLonH pBL_MGI = new PointLatLonH(0.8410754890069483, 0.26292583640580924, 0.0);
        PointENH pEN_MGI = srcProjMGI.LatLon2EastNorth(pBL_MGI, 0.28507044449240715);
        System.out.println(pEN_MGI);
        pEN_MGI = new PointENH(-94323.45, 339796.29, 0.0);
        pBL_MGI = srcProjMGI.EastNorth2LatLon(pEN_MGI, 0.28507044449240715);
        System.out.println(pBL_MGI.getLatitude() * 57.29577951308232 + "  " + pBL_MGI.getLongitude() * 57.29577951308232);
    }
}

