/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.point.PointXYZ;
import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.geodesy.earth.transformation.Affin2D;
import com.derletztekick.geodesy.earth.transformation.Helmert2D;
import com.derletztekick.geodesy.earth.transformation.HomologuePointSet;
import com.derletztekick.geodesy.earth.transformation.TransformationType;
import com.derletztekick.geodesy.geotra.io.nt.NTGrid;
import java.util.Locale;
import java.util.Map;

public class Transformator {
    private final GeodeticDatum srcDatum;
    private final GeodeticDatum trgDatum;
    private boolean hasSrcRefLonLat = false;
    private boolean hasTrgRefLonLat = false;
    private boolean hasSrcRefLon = false;
    private boolean hasTrgRefLon = false;
    private boolean hasHigherResolutionGrid = false;
    private boolean useHigherResolutionGrid;
    private double referenceLongitudeSrc = 0.0;
    private double referenceLongitudeTrg = 0.0;
    private double referenceLatitudeSrc = 0.0;
    private double referenceLatitudeTrg = 0.0;
    private double pseudoValueForExtrapolationLimit = 0.0;
    private double distanceWeightSchemeExponent = 0.0;
    private final TransformationType type;
    private NTGrid[] grids = null;
    private Map<String, PointENH> basePoints = null;
    private boolean isInverseGridTransformation;
    private boolean isSRCequalsTRG;

    public Transformator(GeodeticDatum srcDatum, GeodeticDatum trgDatum) {
        this.srcDatum = srcDatum;
        this.trgDatum = trgDatum;
        this.type = TransformationType.HELMERT_3D;
    }

    public Transformator(boolean isAffin, Map<String, PointENH> basePoints, GeodeticDatum srcDatum, GeodeticDatum trgDatum, double distanceWeightSchemeExponent) {
        this.srcDatum = srcDatum;
        this.trgDatum = trgDatum;
        this.basePoints = basePoints;
        this.setExponentForDistanceWeighting(distanceWeightSchemeExponent);
        this.type = isAffin ? TransformationType.AFFIN_2D : TransformationType.HELMERT_2D;
    }

    public Transformator(NTGrid[] grids, GeodeticDatum srcDatum, GeodeticDatum trgDatum, boolean deep) {
        if (grids == null || grids.length == 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " Fehler, es wurden keine Gitterdaten uebergeben!");
        }
        this.srcDatum = srcDatum;
        this.trgDatum = trgDatum;
        this.useHigherResolutionGrid = deep;
        this.grids = grids;
        NTGrid subgrid = grids[0];
        this.isInverseGridTransformation = srcDatum.getName().equals(subgrid.getTargetDatum().getName());
        this.isSRCequalsTRG = srcDatum.getName().equals(trgDatum.getName());
        this.type = TransformationType.NTv2_GRID;
    }

    public void setExponentForDistanceWeighting(double value) {
        this.distanceWeightSchemeExponent = value;
    }

    public void setValueForExtrapolationLimit(double value) {
        this.pseudoValueForExtrapolationLimit = value <= 0.0 ? Double.MAX_VALUE : value;
    }

    public void setReferenceLongitudeSourceSystem(double referenceLongitude) {
        this.referenceLongitudeSrc = referenceLongitude;
        this.hasSrcRefLon = true;
        this.hasSrcRefLonLat = false;
    }

    public void setReferenceLongitudeTargetSystem(double referenceLongitude) {
        this.referenceLongitudeTrg = referenceLongitude;
        this.hasTrgRefLon = true;
        this.hasTrgRefLonLat = false;
    }

    public void setReferenceLongitudeAndLatitudeSourceSystem(double referenceLongitude, double referenceLatitude) {
        this.referenceLongitudeSrc = referenceLongitude;
        this.referenceLatitudeSrc = referenceLatitude;
        this.hasSrcRefLon = false;
        this.hasSrcRefLonLat = true;
    }

    public void setReferenceLongitudeAndLatitudeTargetSystem(double referenceLongitude, double referenceLatitude) {
        this.referenceLongitudeTrg = referenceLongitude;
        this.referenceLatitudeTrg = referenceLatitude;
        this.hasTrgRefLon = false;
        this.hasTrgRefLonLat = true;
    }

    public HomologuePointSet transformLatitudeLongitudeHeight(PointLatLonH srcPointBLh) {
        PointENH srcPointENh = this.convertTo(srcPointBLh, this.srcDatum);
        PointXYZ srcPointXYZ = this.type == TransformationType.HELMERT_3D ? this.srcDatum.getProjection().getEllipsoid().LatLonH2XYZ(srcPointBLh) : null;
        return this.transform(this.getHomologueSourcePointSet(srcPointENh, srcPointBLh, srcPointXYZ));
    }

    public HomologuePointSet transformXYZ(PointXYZ srcPointXYZ) {
        if (this.type != TransformationType.HELMERT_3D) {
            return null;
        }
        PointLatLonH srcPointBLh = this.srcDatum.getProjection().getEllipsoid().XYZ2LatLonH(srcPointXYZ);
        PointENH srcPointENh = this.convertTo(srcPointBLh, this.srcDatum);
        return this.transform(this.getHomologueSourcePointSet(srcPointENh, srcPointBLh, srcPointXYZ));
    }

    public HomologuePointSet transformEastNorthHeight(PointENH srcPointENh) {
        PointLatLonH srcPointBLh = this.convertTo(srcPointENh, this.srcDatum);
        PointXYZ srcPointXYZ = this.type == TransformationType.HELMERT_3D ? this.srcDatum.getProjection().getEllipsoid().LatLonH2XYZ(srcPointBLh) : null;
        return this.transform(this.getHomologueSourcePointSet(srcPointENh, srcPointBLh, srcPointXYZ));
    }

    private HomologuePointSet transform(HomologuePointSet pointSet) {
        if (this.type == TransformationType.NTv2_GRID) {
            return this.transformNTv2Grid(pointSet);
        }
        if (this.type == TransformationType.HELMERT_3D) {
            return this.transformHelmert3D(pointSet);
        }
        if (this.type == TransformationType.AFFIN_2D) {
            return this.transformAffin2D(pointSet);
        }
        if (this.type == TransformationType.HELMERT_2D) {
            return this.transformHelmert2D(pointSet);
        }
        return null;
    }

    private HomologuePointSet transformAffin2D(HomologuePointSet pointSet) {
        PointENH srcPointEN;
        PointENH trgPointEN = srcPointEN = pointSet.getSourcePointEastNorthHeight();
        PointLatLonH trgPointBL = null;
        int x = (int)(srcPointEN.getX() / 1000.0);
        int y = (int)(srcPointEN.getY() / 1000.0);
        String format = "%d%d";
        String lu = String.format(Locale.ENGLISH, format, y, x);
        String lo = String.format(Locale.ENGLISH, format, y + 1, x);
        String ro = String.format(Locale.ENGLISH, format, y + 1, x + 1);
        String ru = String.format(Locale.ENGLISH, format, y, x + 1);
        if (this.basePoints.containsKey(lu) && this.basePoints.containsKey(lo) && this.basePoints.containsKey(ru) && this.basePoints.containsKey(ro)) {
            PointENH[] src = new PointENH[]{new PointENH((double)y * 1000.0, (double)x * 1000.0, 0.0), new PointENH((double)(y + 1) * 1000.0, (double)x * 1000.0, 0.0), new PointENH((double)(y + 1) * 1000.0, (double)(x + 1) * 1000.0, 0.0), new PointENH((double)y * 1000.0, (double)(x + 1) * 1000.0, 0.0)};
            PointENH[] trg = new PointENH[]{this.basePoints.get(lu), this.basePoints.get(lo), this.basePoints.get(ro), this.basePoints.get(ru)};
            Affin2D affin2d = new Affin2D();
            affin2d.estimateParameters(src, trg);
            trgPointEN = affin2d.transformAndInverseDistanceWeighting(src, trg, srcPointEN, 0.0, this.distanceWeightSchemeExponent);
            trgPointBL = this.hasTrgRefLonLat ? this.trgDatum.getProjection().EastNorth2LatLon(trgPointEN, this.referenceLongitudeTrg, this.referenceLatitudeTrg) : (this.hasTrgRefLon ? this.trgDatum.getProjection().EastNorth2LatLon(trgPointEN, this.referenceLongitudeTrg) : this.trgDatum.getProjection().EastNorth2LatLon(trgPointEN));
            pointSet.setTargetPointEastNorthHeight(trgPointEN);
            pointSet.setTargetPointLatitudeLongitudeHeight(trgPointBL);
            return pointSet;
        }
        return null;
    }

    private HomologuePointSet transformHelmert2D(HomologuePointSet pointSet) {
        PointENH srcPointEN;
        PointENH trgPointEN = srcPointEN = pointSet.getSourcePointEastNorthHeight();
        PointLatLonH trgPointBL = null;
        int x = (int)(srcPointEN.getX() / 1000.0);
        int y = (int)(srcPointEN.getY() / 1000.0);
        String format = "%d%d";
        String lu = String.format(Locale.ENGLISH, format, y, x);
        String lo = String.format(Locale.ENGLISH, format, y + 1, x);
        String ro = String.format(Locale.ENGLISH, format, y + 1, x + 1);
        String ru = String.format(Locale.ENGLISH, format, y, x + 1);
        if (this.basePoints.containsKey(lu) && this.basePoints.containsKey(lo) && this.basePoints.containsKey(ru) && this.basePoints.containsKey(ro)) {
            PointENH[] src = new PointENH[]{new PointENH((double)y * 1000.0, (double)x * 1000.0, 0.0), new PointENH((double)(y + 1) * 1000.0, (double)x * 1000.0, 0.0), new PointENH((double)(y + 1) * 1000.0, (double)(x + 1) * 1000.0, 0.0), new PointENH((double)y * 1000.0, (double)(x + 1) * 1000.0, 0.0)};
            PointENH[] trg = new PointENH[]{this.basePoints.get(lu), this.basePoints.get(lo), this.basePoints.get(ro), this.basePoints.get(ru)};
            Helmert2D helmert2d = new Helmert2D();
            helmert2d.estimateParameters(src, trg);
            trgPointEN = helmert2d.transformAndInverseDistanceWeighting(src, trg, srcPointEN, 0.0, this.distanceWeightSchemeExponent);
            trgPointBL = this.hasTrgRefLonLat ? this.trgDatum.getProjection().EastNorth2LatLon(trgPointEN, this.referenceLongitudeTrg, this.referenceLatitudeTrg) : (this.hasTrgRefLon ? this.trgDatum.getProjection().EastNorth2LatLon(trgPointEN, this.referenceLongitudeTrg) : this.trgDatum.getProjection().EastNorth2LatLon(trgPointEN));
            pointSet.setTargetPointEastNorthHeight(trgPointEN);
            pointSet.setTargetPointLatitudeLongitudeHeight(trgPointBL);
            return pointSet;
        }
        return null;
    }

    private HomologuePointSet transformHelmert3D(HomologuePointSet pointSet) {
        PointXYZ srcPointXYZ = pointSet.getSourcePointXYZ();
        PointXYZ wgs84PointXYZ = this.srcDatum.getTransformationFromLocalToWGS84().transform(srcPointXYZ);
        PointXYZ trgPointXYZ = this.trgDatum.getTransformationFromLocalToWGS84().invTransform(wgs84PointXYZ);
        PointLatLonH trgPointBLh = this.trgDatum.getProjection().getEllipsoid().XYZ2LatLonH(trgPointXYZ);
        PointENH trgPointENh = null;
        trgPointENh = this.hasTrgRefLonLat ? this.trgDatum.getProjection().LatLon2EastNorth(trgPointBLh, this.referenceLongitudeTrg, this.referenceLatitudeTrg) : (this.hasTrgRefLon ? this.trgDatum.getProjection().LatLon2EastNorth(trgPointBLh, this.referenceLongitudeTrg) : this.trgDatum.getProjection().LatLon2EastNorth(trgPointBLh));
        pointSet.setTargetPointEastNorthHeight(trgPointENh);
        pointSet.setTargetPointLatitudeLongitudeHeight(trgPointBLh);
        pointSet.setTargetPointXYZ(trgPointXYZ);
        return pointSet;
    }

    public static NTGrid getSubGrid(NTGrid grid, HomologuePointSet pointSet, boolean deep) {
        return Transformator.getSubGrid(new NTGrid[]{grid}, pointSet, deep);
    }

    public static NTGrid getSubGrid(NTGrid[] grids, HomologuePointSet pointSet, boolean deep) {
        if (grids != null && pointSet != null && grids.length > 0) {
            PointLatLonH srcPointBL = pointSet.getSourcePointLatitudeLongitudeHeight();
            NTGrid[] nTGridArray = grids;
            int n = grids.length;
            int n2 = 0;
            while (n2 < n) {
                NTGrid grid = nTGridArray[n2];
                if (grid.contains(srcPointBL)) {
                    NTGrid[] subGrids;
                    NTGrid lastValidGrid = grid;
                    if (deep && (subGrids = grid.getSubGrids()) != null && subGrids.length > 0) {
                        grid = Transformator.getSubGrid(subGrids, pointSet, deep);
                        grid = grid == null ? lastValidGrid : grid;
                    }
                    return grid;
                }
                ++n2;
            }
        }
        return null;
    }

    private HomologuePointSet transformNTv2Grid(HomologuePointSet pointSet) {
        PointLatLonH srcPointBL;
        PointLatLonH trgPointBL = srcPointBL = pointSet.getSourcePointLatitudeLongitudeHeight();
        PointENH trgPointEN = null;
        if (!this.isSRCequalsTRG) {
            NTGrid subgrid = null;
            if (!this.isInverseGridTransformation) {
                subgrid = Transformator.getSubGrid(this.grids, pointSet, this.useHigherResolutionGrid);
                if (subgrid == null) {
                    return null;
                }
                subgrid.setValueForExtrapolationLimit(this.pseudoValueForExtrapolationLimit);
                trgPointBL = subgrid.transform(srcPointBL);
                this.hasHigherResolutionGrid = !this.useHigherResolutionGrid && subgrid != Transformator.getSubGrid(subgrid, pointSet, true);
            } else {
                trgPointBL = new PointLatLonH(srcPointBL.getLatitude(), srcPointBL.getLongitude(), srcPointBL.getHeight());
                HomologuePointSet trgPointSet = new HomologuePointSet();
                trgPointSet.setSourcePointLatitudeLongitudeHeight(trgPointBL);
                int itr = 0;
                while (itr < 8) {
                    trgPointSet = new HomologuePointSet();
                    trgPointSet.setSourcePointLatitudeLongitudeHeight(trgPointBL);
                    subgrid = Transformator.getSubGrid(this.grids, trgPointSet, this.useHigherResolutionGrid);
                    if (subgrid == null) {
                        return null;
                    }
                    subgrid.setValueForExtrapolationLimit(this.pseudoValueForExtrapolationLimit);
                    trgPointBL = subgrid.inverseTransform(srcPointBL, trgPointBL);
                    if (trgPointBL == null) break;
                    ++itr;
                }
                boolean bl = this.hasHigherResolutionGrid = !this.useHigherResolutionGrid && subgrid != Transformator.getSubGrid(subgrid, trgPointSet, true);
            }
            if (trgPointBL == null) {
                return null;
            }
        }
        trgPointEN = this.hasTrgRefLonLat ? this.trgDatum.getProjection().LatLon2EastNorth(trgPointBL, this.referenceLongitudeTrg, this.referenceLatitudeTrg) : (this.hasTrgRefLon ? this.trgDatum.getProjection().LatLon2EastNorth(trgPointBL, this.referenceLongitudeTrg) : this.trgDatum.getProjection().LatLon2EastNorth(trgPointBL));
        pointSet.setTargetPointEastNorthHeight(trgPointEN);
        pointSet.setTargetPointLatitudeLongitudeHeight(trgPointBL);
        return pointSet;
    }

    private HomologuePointSet getHomologueSourcePointSet(PointENH srcPointENh, PointLatLonH srcPointBLh, PointXYZ srcPointXYZ) {
        HomologuePointSet set = new HomologuePointSet();
        set.setSourcePointEastNorthHeight(srcPointENh);
        set.setSourcePointLatitudeLongitudeHeight(srcPointBLh);
        set.setSourcePointXYZ(srcPointXYZ);
        return set;
    }

    private PointLatLonH convertTo(PointENH srcPointENh, GeodeticDatum datum) {
        if (this.hasSrcRefLonLat) {
            return datum.getProjection().EastNorth2LatLon(srcPointENh, this.referenceLongitudeSrc, this.referenceLatitudeSrc);
        }
        if (this.hasSrcRefLon) {
            return datum.getProjection().EastNorth2LatLon(srcPointENh, this.referenceLongitudeSrc);
        }
        return datum.getProjection().EastNorth2LatLon(srcPointENh);
    }

    private PointENH convertTo(PointLatLonH srcPointBLh, GeodeticDatum datum) {
        if (this.hasSrcRefLonLat) {
            return datum.getProjection().LatLon2EastNorth(srcPointBLh, this.referenceLongitudeSrc, this.referenceLatitudeSrc);
        }
        if (this.hasSrcRefLon) {
            return datum.getProjection().LatLon2EastNorth(srcPointBLh, this.referenceLongitudeSrc);
        }
        return datum.getProjection().LatLon2EastNorth(srcPointBLh);
    }

    public final TransformationType getTransformationType() {
        return this.type;
    }

    public boolean hasHigherResolutionGrid() {
        return this.type == TransformationType.NTv2_GRID && this.hasHigherResolutionGrid;
    }

    public boolean isValidSourceSystemCenterMeridian() {
        return !this.hasSrcRefLon || this.srcDatum.getProjection().isValidCentralMeridian(this.referenceLongitudeSrc);
    }

    public boolean isValidTargetSystemCenterMeridian() {
        return !this.hasTrgRefLon || this.trgDatum.getProjection().isValidCentralMeridian(this.referenceLongitudeTrg);
    }
}

