/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.projection.point.PointENH;
import com.derletztekick.tools.geodesy.Constant;

public abstract class Transformation2D {
    private double tx = 0.0;
    private double ty = 0.0;
    private double a11 = 1.0;
    private double a12 = 0.0;
    private double a22 = 1.0;
    private double a21 = 0.0;
    private static final double SQRT_EPS = Math.sqrt(Constant.EPS);

    public Transformation2D() {
    }

    public Transformation2D(double[] params) {
        this(params[0], params[1], params[2], params[3], params[4], params[5]);
    }

    public Transformation2D(double tx, double ty, double a11, double a12, double a22, double a21) {
        this.setTransformationParameter(tx, ty, a11, a12, a22, a21);
    }

    void setTransformationParameter(double tx, double ty, double a11, double a12, double a22, double a21) {
        this.tx = tx;
        this.ty = ty;
        this.a11 = a11;
        this.a12 = a12;
        this.a22 = a22;
        this.a21 = a21;
    }

    public double[] getTransformationParameter() {
        return new double[]{this.tx, this.ty, this.a11, this.a12, this.a22, this.a21};
    }

    public PointENH transform(PointENH point) {
        return Transformation2D.transform(point, this.tx, this.ty, this.a11, this.a12, this.a22, this.a21);
    }

    public PointENH invTransform(PointENH point) {
        return Transformation2D.invTransform(point, this.tx, this.ty, this.a11, this.a12, this.a22, this.a21);
    }

    public static PointENH transform(PointENH point, double tx, double ty, double a11, double a12, double a22, double a21) {
        double xP = point.getX();
        double yP = point.getY();
        double XP = tx + a11 * xP - a12 * yP;
        double YP = ty + a21 * xP + a22 * yP;
        return new PointENH(YP, XP, 0.0);
    }

    public static PointENH invTransform(PointENH point, double tx, double ty, double a11, double a12, double a22, double a21) {
        double XP = point.getX();
        double YP = point.getY();
        double xP = a11 * (XP - tx) + a21 * (YP - ty);
        double yP = -a12 * (XP - tx) + a22 * (YP - ty);
        return new PointENH(yP, xP, 0.0);
    }

    public PointENH transformAndInverseDistanceWeighting(PointENH[] src, PointENH[] trg, PointENH pointSRC, double m, double k) {
        double nop = src.length;
        if (nop <= 0.0 || nop != (double)trg.length) {
            return null;
        }
        PointENH pointTRG = this.transform(pointSRC);
        if (m == 0.0 && k == 0.0) {
            return pointTRG;
        }
        double sumWeights = 0.0;
        double ux = 0.0;
        double uy = 0.0;
        int i = 0;
        while ((double)i < nop) {
            PointENH srcP = src[i];
            PointENH trgP = trg[i];
            double dist = this.getDistance(srcP, pointSRC);
            dist = dist < SQRT_EPS ? SQRT_EPS : dist;
            double weight = Math.pow(m + dist, -k);
            sumWeights += weight;
            PointENH transTrgP = this.transform(srcP);
            double vx = trgP.getX() - transTrgP.getX();
            double vy = trgP.getY() - transTrgP.getY();
            ux += weight * vx;
            uy += weight * vy;
            ++i;
        }
        return new PointENH(pointTRG.getY() + (uy /= sumWeights), pointTRG.getX() + (ux /= sumWeights), pointTRG.getZ());
    }

    public double getDistance(PointENH p1, PointENH p2) {
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        return Math.hypot(x1 - x2, y1 - y2);
    }

    public abstract double[] estimateParameters(PointENH[] var1, PointENH[] var2);
}

