/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.datum.GeodeticDatum;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;
import com.derletztekick.geodesy.earth.transformation.NTv2GridValue;
import com.derletztekick.tools.geodesy.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NTv2SubGrid {
    private final GeodeticDatum srcDatum;
    private final GeodeticDatum trgDatum;
    private String name;
    private String parent;
    private Date created;
    private Date updated;
    private double[] boundary = new double[]{0.0, 0.0, 0.0, 0.0};
    private double[] incLatLong = new double[]{0.0, 0.0};
    private List<NTv2GridValue> gridValues = new ArrayList<NTv2GridValue>();
    private List<NTv2SubGrid> subGrids = new ArrayList<NTv2SubGrid>();
    private double pseudoValueForExtrapolationLimit = Double.MAX_VALUE;
    private String unitName = "SECONDS";

    public NTv2SubGrid(String name, String parent, String unitName, GeodeticDatum srcDatum, GeodeticDatum trgDatum) {
        this.setName(name);
        this.setParent(parent);
        this.unitName = unitName;
        this.srcDatum = srcDatum;
        this.trgDatum = trgDatum;
    }

    public void addSubGrid(NTv2SubGrid grid) {
        if (grid.getParent().equals(this.name) && !this.subGrids.contains(grid)) {
            this.subGrids.add(grid);
        }
    }

    public List<NTv2SubGrid> getSubGrids() {
        return this.subGrids;
    }

    public void setBoundary(double latN, double latS, double lonW, double lonE) {
        this.boundary = new double[]{latN, latS, lonW, lonE};
    }

    public void setGridWidth(double incLat, double incLon) {
        this.incLatLong = new double[]{incLat, incLon};
    }

    public void addGridValue(NTv2GridValue v) {
        this.gridValues.add(v);
    }

    public void setValueForExtrapolationLimit(double value) {
        double scale = this.unitName.equalsIgnoreCase("SECONDS") ? 4.84813681109536E-6 : (this.unitName.equalsIgnoreCase("MINUTES") ? 2.908882086657216E-4 : (this.unitName.equalsIgnoreCase("DEGREES") ? Math.PI / 180 : 1.0));
        this.pseudoValueForExtrapolationLimit = value <= 0.0 ? Double.MAX_VALUE : (value - Math.sqrt(Constant.EPS)) * scale;
    }

    public boolean contains(PointLatLonH point) {
        double lat = point.getLatitude();
        double lon = -point.getLongitude();
        double latN = this.boundary[0];
        double latS = this.boundary[1];
        double lonW = this.boundary[2];
        double lonE = this.boundary[3];
        return latS <= lat && lat <= latN && lonE <= lon && lon <= lonW;
    }

    public PointLatLonH inverseTransform(PointLatLonH point) {
        PointLatLonH qpoint = new PointLatLonH(point.getLatitude(), point.getLongitude(), point.getHeight());
        int i = 0;
        do {
            double[] shiftValues;
            if ((shiftValues = this.getShiftParameters(qpoint)) == null) {
                return null;
            }
            qpoint = new PointLatLonH(point.getLatitude() - shiftValues[0], point.getLongitude() + shiftValues[1], point.getHeight());
        } while (i++ < 8);
        return qpoint;
    }

    public PointLatLonH transform(PointLatLonH point) {
        double[] shiftValues = this.getShiftParameters(point);
        if (shiftValues == null) {
            return null;
        }
        return new PointLatLonH(point.getLatitude() + shiftValues[0], point.getLongitude() - shiftValues[1], point.getHeight());
    }

    public double[] getShiftParameters(PointLatLonH point) {
        double lat = point.getLatitude();
        double lon = -point.getLongitude();
        double latN = this.boundary[0];
        double latS = this.boundary[1];
        double lonW = this.boundary[2];
        double lonE = this.boundary[3];
        double incLat = this.incLatLong[0];
        double incLon = this.incLatLong[1];
        double fcol = (lon - lonE) / incLon;
        double frow = (lat - latS) / incLat;
        int col = (int)fcol;
        int row = (int)frow;
        int ppr = (int)((lonW - lonE) / incLon + 0.5) + 1;
        int ppc = (int)((latN - latS) / incLat + 0.5) + 1;
        int se = row * ppr + col;
        int sw = se + 1;
        int ne = se + ppr;
        int nw = ne + 1;
        if (col >= ppr - 1) {
            nw = sw = se;
        }
        if (row >= ppc - 1) {
            ne = se;
            nw = sw;
        }
        double dx = fcol - (double)col;
        double dy = frow - (double)row;
        return this.interp(ne, nw, se, sw, dx, dy);
    }

    private double[] interp(int ne, int nw, int se, int sw, double dx, double dy) {
        double lonSNW;
        double latSNW;
        double lonSSW;
        double latSSW;
        double lonSNE;
        double latSNE;
        double lonSSE;
        double latSSE;
        block4: {
            int len = this.gridValues.size();
            if (ne >= len || nw >= len || sw >= len || sw >= len) {
                System.err.println(this.getClass().getSimpleName() + " Fehler, Indizes der Eckpunkte ueberstreigen Datengroesse: ne = " + ne + ", nw = " + nw + ", se = " + se + ", sw = " + sw + " und size = " + len);
                return null;
            }
            try {
                latSSE = this.gridValues.get(se).getLatitude();
                lonSSE = this.gridValues.get(se).getLongitude();
                latSNE = this.gridValues.get(ne).getLatitude();
                lonSNE = this.gridValues.get(ne).getLongitude();
                latSSW = this.gridValues.get(sw).getLatitude();
                lonSSW = this.gridValues.get(sw).getLongitude();
                latSNW = this.gridValues.get(nw).getLatitude();
                lonSNW = this.gridValues.get(nw).getLongitude();
                if (!(Math.abs(latSSE) >= this.pseudoValueForExtrapolationLimit || Math.abs(lonSSE) >= this.pseudoValueForExtrapolationLimit || Math.abs(latSNE) >= this.pseudoValueForExtrapolationLimit || Math.abs(lonSNE) >= this.pseudoValueForExtrapolationLimit || Math.abs(latSSW) >= this.pseudoValueForExtrapolationLimit || Math.abs(lonSSW) >= this.pseudoValueForExtrapolationLimit || Math.abs(latSNW) >= this.pseudoValueForExtrapolationLimit) && !(Math.abs(lonSNW) >= this.pseudoValueForExtrapolationLimit)) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        double latS = (1.0 - dx) * (1.0 - dy) * latSSE + dx * (1.0 - dy) * latSSW + (1.0 - dx) * dy * latSNE + dx * dy * latSNW;
        double lonS = (1.0 - dx) * (1.0 - dy) * lonSSE + dx * (1.0 - dy) * lonSSW + (1.0 - dx) * dy * lonSNE + dx * dy * lonSNW;
        return new double[]{latS, lonS};
    }

    public String toString() {
        return this.name;
    }

    public Date getCreatedDate() {
        return this.created;
    }

    public Date getUpdatedDate() {
        return this.updated;
    }

    public String getParent() {
        return this.parent;
    }

    public GeodeticDatum getTargetDatum() {
        return this.trgDatum;
    }

    public GeodeticDatum getSourceDatum() {
        return this.srcDatum;
    }

    public void setCreatedDate(Date created) {
        this.created = created;
    }

    public void setUpdatedDate(Date updated) {
        this.updated = updated;
    }

    public double[] getBoundary() {
        return this.boundary;
    }

    public double[] getGridWidth() {
        return this.incLatLong;
    }

    public List<NTv2GridValue> getGridValues() {
        return this.gridValues;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setName(String name) {
        this.name = name;
    }
}

