/*
 * Decompiled with CFR 0.152.
 */
package com.derletztekick.geodesy.earth.transformation;

import com.derletztekick.geodesy.earth.ellipsoid.Ellipsoid;
import com.derletztekick.geodesy.earth.ellipsoid.EllipsoidType;
import com.derletztekick.geodesy.earth.projection.point.PointLatLonH;

public class Molodensky {
    private Ellipsoid srcEllipsoid;
    private Ellipsoid trgEllipsoid;
    private double dX = 0.0;
    private double dY = 0.0;
    private double dZ = 0.0;

    public Molodensky(Ellipsoid srcEllipsoid, Ellipsoid trgEllipsoid, double dX, double dY, double dZ) {
        this.srcEllipsoid = srcEllipsoid;
        this.trgEllipsoid = trgEllipsoid;
        this.dX = dX;
        this.dY = dY;
        this.dZ = dZ;
    }

    public PointLatLonH transform(PointLatLonH PointLatLonH2) {
        return Molodensky.transform(PointLatLonH2, this.srcEllipsoid, this.trgEllipsoid, this.dX, this.dY, this.dZ);
    }

    public PointLatLonH invTransform(PointLatLonH PointLatLonH2) {
        return Molodensky.invTransform(PointLatLonH2, this.srcEllipsoid, this.trgEllipsoid, this.dX, this.dY, this.dZ);
    }

    public static PointLatLonH invTransform(PointLatLonH PointLatLonH2, Ellipsoid srcEllipsoid, Ellipsoid trgEllipsoid, double dX, double dY, double dZ) {
        return Molodensky.transform(PointLatLonH2, trgEllipsoid, srcEllipsoid, -dX, -dY, -dZ);
    }

    public static PointLatLonH transform(PointLatLonH PointLatLonH2, Ellipsoid srcEllipsoid, Ellipsoid trgEllipsoid, double dX, double dY, double dZ) {
        double lat = PointLatLonH2.getLatitude();
        double lon = PointLatLonH2.getLongitude();
        double hel = PointLatLonH2.getHeight();
        double slat = Math.sin(lat);
        double clat = Math.cos(lat);
        double clon = Math.cos(lon);
        double slon = Math.sin(lon);
        double fs = srcEllipsoid.flattening();
        double df = trgEllipsoid.flattening() - fs;
        double as = srcEllipsoid.getMajorAxis();
        double da = trgEllipsoid.getMajorAxis() - as;
        double bs = srcEllipsoid.getMinorAxis();
        double e1Sqr = srcEllipsoid.getE1Square();
        double eta = 1.0 - e1Sqr * slat * slat;
        double Rm = as * (1.0 - e1Sqr) / Math.pow(eta, 1.5);
        double Rn = as / Math.sqrt(eta);
        double dlat = (-dX * slat * clon - dY * slat * slon + dZ * clat + da * (Rn * e1Sqr * slat * clat) / as + df * (Rm * as / bs + Rn * bs / as) * slat * clat) / (Rm + hel);
        double dlon = (-dX * slon + dY * clon) / ((Rn + hel) * clat);
        double dhel = dX * clat * clon + dY * clat * slon + dZ * slat - as / Rn * da + Rn * bs / as * slat * slat * df;
        return new PointLatLonH(lat + dlat, lon + dlon, hel + dhel);
    }

    public static void main(String[] args) {
        Ellipsoid ellipsoid1 = new Ellipsoid(EllipsoidType.HAYFORD);
        Ellipsoid ellipsoid2 = new Ellipsoid(EllipsoidType.WGS84);
        double dX = -87.0;
        double dY = -98.0;
        double dZ = -121.0;
        Molodensky molodensky = new Molodensky(ellipsoid1, ellipsoid2, dX, dY, dZ);
        double lat = 0.9346238144429634;
        double lon = 0.13002702927357757;
        double hel = 50.0;
        PointLatLonH PointLatLonHSrc = new PointLatLonH(lat, lon, hel);
        PointLatLonH PointLatLonHTrg = molodensky.transform(PointLatLonHSrc);
        PointLatLonH invPointLatLonHSrc = molodensky.invTransform(PointLatLonHTrg);
        System.out.println(PointLatLonHSrc.getLatitude() * 57.29577951308232 + "  " + PointLatLonHSrc.getLongitude() * 57.29577951308232 + "  " + PointLatLonHSrc.getHeight());
        System.out.println(ellipsoid1.LatLonH2XYZ(PointLatLonHSrc));
        System.out.println(PointLatLonHTrg.getLatitude() * 57.29577951308232 + "  " + PointLatLonHTrg.getLongitude() * 57.29577951308232 + "  " + PointLatLonHTrg.getHeight());
        System.out.println(ellipsoid2.LatLonH2XYZ(PointLatLonHTrg));
        System.out.println(invPointLatLonHSrc.getLatitude() * 57.29577951308232 + "  " + invPointLatLonHSrc.getLongitude() * 57.29577951308232 + "  " + invPointLatLonHSrc.getHeight());
        System.out.println(ellipsoid1.LatLonH2XYZ(invPointLatLonHSrc));
    }
}

